/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;

public final class SubSequence
extends BasedSequenceImpl {
    private final CharSequence baseSeq;
    private final SubSequence base;
    private final int startOffset;
    private final int endOffset;

    @Override
    public SubSequence getBaseSequence() {
        return this.base;
    }

    @Override
    public Object getBase() {
        return this.baseSeq;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    private SubSequence(CharSequence charSequence) {
        assert (!(charSequence instanceof BasedSequence));
        this.base = this;
        this.baseSeq = charSequence;
        this.startOffset = 0;
        this.endOffset = charSequence.length();
    }

    private SubSequence(SubSequence subSequence, int start, int end) {
        assert (start > 0 || end < subSequence.length());
        this.base = subSequence;
        this.baseSeq = subSequence.baseSeq;
        this.startOffset = subSequence.startOffset + start;
        this.endOffset = subSequence.startOffset + end;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        if (index >= 0 && index <= this.endOffset - this.startOffset) {
            return this.startOffset + index;
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 && index < this.endOffset - this.startOffset) {
            char c = this.baseSeq.charAt(index + this.startOffset);
            return c == '\u0000' ? (char)'\ufffd' : (char)c;
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public SubSequence subSequence(Range range) {
        return this.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    public SubSequence subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public SubSequence subSequence(int start, int end) {
        if (start >= 0 && end <= this.endOffset - this.startOffset) {
            return this.baseSubSequence(this.startOffset + start, this.startOffset + end);
        }
        if (start < 0 || this.startOffset + start > this.endOffset) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    @Override
    public SubSequence baseSubSequence(int start, int end) {
        if (start >= 0 && end <= this.base.length()) {
            return start == this.startOffset && end == this.endOffset ? this : (this.base != this ? this.base.baseSubSequence(start, end) : new SubSequence(this, start, end));
        }
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    @Override
    public BasedSequence appendTo(StringBuilder out, int start, int end) {
        out.append(this.baseSeq, this.startOffset + start, this.startOffset + end);
        return this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        this.appendTo(sb, 0, this.length());
        return sb.toString();
    }

    public static BasedSequence of(CharSequence charSequence) {
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)charSequence;
        }
        return charSequence == null ? BasedSequence.NULL : new SubSequence(charSequence);
    }

    public static BasedSequence of(CharSequence charSequence, int start) {
        if (charSequence instanceof BasedSequence) {
            return ((BasedSequence)charSequence).subSequence(start);
        }
        return charSequence == null ? BasedSequence.NULL : (start == 0 ? new SubSequence(charSequence) : new SubSequence(charSequence).subSequence(start, charSequence.length()));
    }

    public static BasedSequence of(CharSequence charSequence, int start, int end) {
        if (charSequence instanceof BasedSequence) {
            return ((BasedSequence)charSequence).subSequence(start, end);
        }
        return charSequence == null ? BasedSequence.NULL : (start == 0 && end == charSequence.length() ? new SubSequence(charSequence) : new SubSequence(charSequence).subSequence(start, end));
    }
}

