/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import com.vladsch.flexmark.util.collection.DataValueFactory;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.DataSet;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;

public class MutableDataSet
extends DataSet
implements MutableDataHolder {
    public MutableDataSet() {
    }

    public MutableDataSet(DataHolder other) {
        super(other);
    }

    @Override
    public <T> MutableDataSet set(DataKey<T> key, T value) {
        this.dataSet.put(key, value);
        return this;
    }

    @Override
    public MutableDataHolder setFrom(MutableDataSetter dataSetter) {
        return dataSetter.setIn(this);
    }

    @Override
    public void setAll(DataHolder other) {
        for (DataKey key : other.keySet()) {
            this.set(key, other.get(key));
        }
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return this.getOrCompute(key, key.getFactory());
    }

    @Override
    public <T> MutableDataSet remove(DataKey<T> key) {
        this.dataSet.remove(key);
        return this;
    }

    @Override
    public <T> T getOrCompute(DataKey<T> key, DataValueFactory<T> factory) {
        if (this.dataSet.containsKey(key)) {
            return key.getValue(this.dataSet.get(key));
        }
        Object newValue = factory.create(this);
        this.dataSet.put(key, newValue);
        return newValue;
    }

    public static MutableDataSet merge(DataHolder ... dataHolders) {
        MutableDataSet dataSet = new MutableDataSet();
        for (DataHolder dataHolder : dataHolders) {
            if (dataHolder == null) continue;
            dataSet.dataSet.putAll(dataHolder.getAll());
        }
        return dataSet;
    }

    @Override
    public MutableDataSet toMutable() {
        return this;
    }

    @Override
    public DataHolder toImmutable() {
        return new DataSet(this);
    }

    @Override
    public void clear() {
        this.dataSet.clear();
    }
}

