/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.BasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.PlainSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.SegmentOptimizer;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequenceBuilder
implements ISequenceBuilder<SequenceBuilder, BasedSequence> {
    private final BasedSegmentBuilder segments;
    @NotNull
    private final BasedSequence baseSeq;
    @NotNull
    private final BasedSequence altBase;
    @NotNull
    private final HashMap<BasedSequence, Boolean> equivalentBases;
    @Nullable
    private BasedSequence resultSeq;

    private SequenceBuilder(@NotNull BasedSequence base, @Nullable SegmentOptimizer optimizer) {
        this(base, optimizer, new HashMap<BasedSequence, Boolean>());
    }

    private SequenceBuilder(@NotNull BasedSequence base, @Nullable SegmentOptimizer optimizer, @NotNull HashMap<BasedSequence, Boolean> equivalentBases) {
        this.altBase = base;
        this.baseSeq = base.getBaseSequence();
        this.equivalentBases = equivalentBases;
        int options = PlainSegmentBuilder.F_DEFAULT;
        if (!this.baseSeq.anyOptions(BasedSequence.F_FULL_SEGMENTED_SEQUENCES) || this.baseSeq.anyOptions(BasedSequence.F_COLLECT_FIRST256_STATS)) {
            options |= PlainSegmentBuilder.F_TRACK_FIRST256;
        }
        if (this.baseSeq.anyOptions(BasedSequence.F_NO_ANCHORS)) {
            options &= ~PlainSegmentBuilder.F_INCLUDE_ANCHORS;
        }
        this.segments = optimizer == null ? BasedSegmentBuilder.emptyBuilder(this.baseSeq, options) : BasedSegmentBuilder.emptyBuilder(this.baseSeq, optimizer, options);
    }

    private SequenceBuilder(@NotNull BasedSequence base, int options, @Nullable SegmentOptimizer optimizer, @NotNull HashMap<BasedSequence, Boolean> equivalentBases) {
        this.altBase = base;
        this.baseSeq = base.getBaseSequence();
        this.equivalentBases = equivalentBases;
        if (!this.baseSeq.anyOptions(BasedSequence.F_FULL_SEGMENTED_SEQUENCES) || this.baseSeq.anyOptions(BasedSequence.F_COLLECT_FIRST256_STATS)) {
            options |= PlainSegmentBuilder.F_TRACK_FIRST256;
        }
        if (this.baseSeq.anyOptions(BasedSequence.F_NO_ANCHORS)) {
            options &= ~PlainSegmentBuilder.F_INCLUDE_ANCHORS;
        }
        this.segments = optimizer == null ? BasedSegmentBuilder.emptyBuilder(this.baseSeq, options) : BasedSegmentBuilder.emptyBuilder(this.baseSeq, optimizer, options);
    }

    @NotNull
    public BasedSequence getBaseSequence() {
        return this.baseSeq;
    }

    @NotNull
    public BasedSegmentBuilder getSegmentBuilder() {
        return this.segments;
    }

    @Nullable
    public Range getLastRangeOrNull() {
        Object part = this.segments.getPart(this.segments.size());
        return part instanceof Range && ((Range)part).isNotNull() ? (Range)part : null;
    }

    @Override
    @Nullable
    public BasedSequence getSingleBasedSequence() {
        Range range = this.segments.getBaseSubSequenceRange();
        return range == null ? null : this.baseSeq.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    @NotNull
    public SequenceBuilder getBuilder() {
        return new SequenceBuilder(this.altBase, this.segments.options, this.segments.optimizer, this.equivalentBases);
    }

    @Override
    public char charAt(int index) {
        return this.toSequence().charAt(index);
    }

    boolean isCommonBaseSequence(@NotNull BasedSequence chars) {
        if (chars.isNull()) {
            return false;
        }
        BasedSequence charsBaseSequence = chars.getBaseSequence();
        if (charsBaseSequence == this.baseSeq) {
            return true;
        }
        Boolean inCommon = this.equivalentBases.get(charsBaseSequence);
        if (inCommon != null) {
            return inCommon;
        }
        boolean equivalent = this.baseSeq.equals(charsBaseSequence);
        this.equivalentBases.put(charsBaseSequence, equivalent);
        return equivalent;
    }

    @Override
    @NotNull
    public SequenceBuilder append(@Nullable CharSequence chars, int startIndex, int endIndex) {
        if (chars instanceof BasedSequence && this.isCommonBaseSequence((BasedSequence)chars)) {
            if (((BasedSequence)chars).isNotNull()) {
                if (startIndex == 0 && endIndex == chars.length()) {
                    ((BasedSequence)chars).addSegments(this.segments);
                } else {
                    ((BasedSequence)chars).subSequence(startIndex, endIndex).addSegments(this.segments);
                }
                this.resultSeq = null;
            }
        } else if (chars != null && startIndex < endIndex) {
            if (startIndex == 0 && endIndex == chars.length()) {
                this.segments.append(chars);
            } else {
                this.segments.append(chars.subSequence(startIndex, endIndex));
            }
            this.resultSeq = null;
        }
        return this;
    }

    @Override
    @NotNull
    public SequenceBuilder append(char c) {
        this.segments.append(c);
        this.resultSeq = null;
        return this;
    }

    @Override
    @NotNull
    public SequenceBuilder append(char c, int count) {
        if (count > 0) {
            this.segments.append(c, count);
            this.resultSeq = null;
        }
        return this;
    }

    @NotNull
    public SequenceBuilder append(int startOffset, int endOffset) {
        return this.addByOffsets(startOffset, endOffset);
    }

    @NotNull
    public SequenceBuilder append(@NotNull Range chars) {
        return this.addRange(chars);
    }

    @NotNull
    public SequenceBuilder addRange(@NotNull Range range) {
        this.segments.append(range);
        this.resultSeq = null;
        return this;
    }

    @NotNull
    public SequenceBuilder addByOffsets(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > endOffset || endOffset > this.baseSeq.length()) {
            throw new IllegalArgumentException("addByOffsets start/end must be a valid range in [0, " + this.baseSeq.length() + "], got: [" + startOffset + ", " + endOffset + "]");
        }
        this.segments.append(Range.of(startOffset, endOffset));
        this.resultSeq = null;
        return this;
    }

    @NotNull
    public SequenceBuilder addByLength(int startOffset, int textLength) {
        return (SequenceBuilder)this.add(this.baseSeq.subSequence(startOffset, startOffset + textLength));
    }

    @Override
    @NotNull
    public BasedSequence toSequence() {
        if (this.resultSeq == null) {
            this.resultSeq = SegmentedSequence.create(this);
        }
        return this.resultSeq;
    }

    @NotNull
    public BasedSequence toSequence(@NotNull BasedSequence altSequence) {
        return this.toSequence(altSequence, null, null);
    }

    @NotNull
    public BasedSequence toSequence(@NotNull BasedSequence altSequence, @Nullable CharPredicate trimStart, @Nullable CharPredicate ignoreCharDiff) {
        if (altSequence == this.altBase) {
            return this.toSequence();
        }
        assert (altSequence.equals(this.altBase)) : String.format("altSequence must be character identical to builder.altBase\naltBase: '%s'\n altSeq: '%s'\n", this.altBase.toVisibleWhitespaceString(), altSequence.toVisibleWhitespaceString());
        SequenceBuilder altBuilder = new SequenceBuilder(altSequence, this.segments.options, this.segments.optimizer, new HashMap<BasedSequence, Boolean>());
        int deleted = 0;
        for (Object part : this.segments) {
            if (part instanceof Range) {
                int startTrimmed;
                BasedSequence s = altSequence.subSequence(deleted + ((Range)part).getStart(), deleted + ((Range)part).getEnd());
                int n = startTrimmed = trimStart == null ? 0 : s.countLeading(trimStart);
                if (startTrimmed > 0) {
                    s = altSequence.subSequence((deleted += startTrimmed) + ((Range)part).getStart(), deleted + ((Range)part).getEnd());
                }
                altBuilder.append(s);
                continue;
            }
            if (part instanceof CharSequence) {
                altBuilder.append((CharSequence)part);
                continue;
            }
            if (part == null) continue;
            throw new IllegalStateException("Invalid part type " + part.getClass());
        }
        BasedSequence result = SegmentedSequence.create(altBuilder);
        BasedSequence sequence = this.toSequence();
        assert (SequenceUtils.compare(result, sequence, false, ignoreCharDiff) == 0) : String.format("result must be character identical to builder.toSequence()\nresult: '%s'\n sequence: '%s'\n", result.toVisibleWhitespaceString(), sequence.toVisibleWhitespaceString());
        return result;
    }

    @NotNull
    public BasedSequence toSequenceByIndex(@NotNull BasedSequence altSequence, @Nullable CharPredicate trimStart, @Nullable CharPredicate ignoreCharDiff) {
        if (altSequence == this.altBase) {
            return this.toSequence();
        }
        assert (altSequence.equals(this.altBase)) : String.format("altSequence must be character identical to builder.altBase\naltBase: '%s'\n altSeq: '%s'\n", this.altBase.toVisibleWhitespaceString(), altSequence.toVisibleWhitespaceString());
        SequenceBuilder altBuilder = new SequenceBuilder(altSequence, this.segments.options, this.segments.optimizer, new HashMap<BasedSequence, Boolean>());
        int length = 0;
        int deleted = 0;
        for (Object part : this.segments) {
            if (part instanceof Range) {
                int startTrimmed;
                BasedSequence s = altSequence.subSequence(length + deleted, length + deleted + ((Range)part).getSpan());
                int n = startTrimmed = trimStart == null ? 0 : s.countLeading(trimStart);
                if (startTrimmed > 0) {
                    s = altSequence.subSequence(length + (deleted += startTrimmed), length + deleted + ((Range)part).getSpan());
                }
                altBuilder.append(s);
                length += ((Range)part).getSpan();
                continue;
            }
            if (part instanceof CharSequence) {
                altBuilder.append((CharSequence)part);
                length += ((CharSequence)part).length();
                continue;
            }
            if (part == null) continue;
            throw new IllegalStateException("Invalid part type " + part.getClass());
        }
        BasedSequence result = SegmentedSequence.create(altBuilder);
        BasedSequence sequence = this.toSequence();
        assert (SequenceUtils.compare(result, sequence, false, ignoreCharDiff) == 0) : String.format("result must be character identical to builder.toSequence()\nresult: '%s'\n sequence: '%s'\n", result.toVisibleWhitespaceString(), sequence.toVisibleWhitespaceString());
        return result;
    }

    @Override
    public int length() {
        return this.segments.length();
    }

    @NotNull
    public String toStringWithRanges() {
        return this.segments.toStringWithRangesVisibleWhitespace(this.baseSeq);
    }

    @NotNull
    public String toStringWithRanges(boolean toVisibleWhiteSpace) {
        return toVisibleWhiteSpace ? this.segments.toStringWithRangesVisibleWhitespace(this.baseSeq) : this.segments.toStringWithRanges(this.baseSeq);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        BasedSequence last = null;
        for (Object part : this.segments) {
            if (part instanceof Range) {
                BasedSequence s = this.baseSeq.subSequence(((Range)part).getStart(), ((Range)part).getEnd());
                if (s.isNotEmpty()) {
                    if (last != null && last.isNotEmpty() && last.getEndOffset() < s.getStartOffset() && " \t\r\n".indexOf(last.charAt(last.length() - 1)) == -1 && " \t\r\n".indexOf(s.charAt(0)) == -1 && s.baseSubSequence(last.getEndOffset(), s.getStartOffset()).endsWith(" ")) {
                        sb.append(' ');
                    }
                    s.appendTo(sb);
                }
                last = s;
                continue;
            }
            if (part instanceof CharSequence) {
                sb.append(part);
                last = null;
                continue;
            }
            if (part == null) continue;
            throw new IllegalStateException("Invalid part type " + part.getClass());
        }
        return sb.toString();
    }

    @NotNull
    public String toStringNoAddedSpaces() {
        StringBuilder sb = new StringBuilder();
        for (Object part : this.segments) {
            if (part instanceof Range) {
                sb.append(this.baseSeq.subSequence(((Range)part).getStart(), ((Range)part).getEnd()));
                continue;
            }
            if (part instanceof CharSequence) {
                sb.append(part);
                continue;
            }
            if (part == null) continue;
            throw new IllegalStateException("Invalid part type " + part.getClass());
        }
        return sb.toString();
    }

    @NotNull
    public static SequenceBuilder emptyBuilder(@NotNull BasedSequence base) {
        return new SequenceBuilder(base, null);
    }

    @NotNull
    public static SequenceBuilder emptyBuilder(@NotNull BasedSequence base, @NotNull SegmentOptimizer optimizer) {
        return new SequenceBuilder(base, optimizer);
    }

    @NotNull
    public static SequenceBuilder emptyBuilder(@NotNull BasedSequence base, int options) {
        return new SequenceBuilder(base, options, null, new HashMap<BasedSequence, Boolean>());
    }

    @NotNull
    public static SequenceBuilder emptyBuilder(@NotNull BasedSequence base, int options, @NotNull SegmentOptimizer optimizer) {
        return new SequenceBuilder(base, options, optimizer, new HashMap<BasedSequence, Boolean>());
    }
}

