/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.collection.iteration;

import com.vladsch.flexmark.experimental.util.collection.iteration.IPosition;
import com.vladsch.flexmark.experimental.util.collection.iteration.IPositionUpdater;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.PositionAnchor;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IPositionBase<T, P extends IPosition<T, P>>
implements IPosition<T, P> {
    private static final int F_CURRENT = 0;
    private static final int F_NEXT = 1;
    private static final int F_PREVIOUS = 2;
    private static final int F_VALID = 4;
    private static final int F_DETACHED = 8;
    private static final int F_SETTING = 16;
    @NotNull
    private final IPositionUpdater<T, P> myParent;
    @NotNull
    private final List<T> myList;
    private int myIndex;
    private byte myFlags;

    public IPositionBase(@NotNull IPositionUpdater<T, P> parent, int index, @NotNull PositionAnchor anchor) {
        this.myParent = parent;
        this.myList = this.myParent.getList();
        this.myIndex = index;
        this.myFlags = (byte)(4 | (anchor == PositionAnchor.PREVIOUS ? 2 : (anchor == PositionAnchor.NEXT ? 1 : 0)));
    }

    @Override
    public void inserted(int index, int count) {
        if ((this.myFlags & 8) != 0) {
            throw new IllegalStateException("Position is detached but still receiving notifications");
        }
        int positionIndex = this.myIndex;
        assert (positionIndex + count <= this.myList.size());
        if ((this.myFlags & 0x10) == 0) {
            if ((this.myFlags & 2) != 0) {
                if (index <= positionIndex) {
                    if (index == positionIndex - 1) {
                        this.setIndex(index, true);
                    } else if (index != positionIndex) {
                        this.setIndex(positionIndex + count, true);
                    }
                }
            } else if (index <= positionIndex) {
                assert (positionIndex + count <= this.myList.size());
                this.setIndex(positionIndex + count, true);
            }
        }
    }

    @Override
    public void deleted(int index, int count) {
        if ((this.myFlags & 8) != 0) {
            throw new IllegalStateException("Position is detached but still receiving notifications");
        }
        if ((this.myFlags & 0x10) == 0) {
            int positionIndex = this.myIndex;
            if ((this.myFlags & 2) != 0) {
                if (index <= positionIndex) {
                    if (index + count <= positionIndex) {
                        this.setIndex(positionIndex - count, true);
                    } else if (index > 0) {
                        this.setIndex(index - 1, true);
                    } else {
                        this.setIndex(index, false);
                    }
                }
            } else if (index <= positionIndex) {
                if (index + count <= positionIndex) {
                    this.setIndex(positionIndex - count, true);
                } else {
                    this.setIndex(index, (this.myFlags & 1) != 0);
                }
            }
        }
    }

    private void setIndex(int i, boolean isValid) {
        if (this.isValid() && !isValid) {
            this.myFlags = (byte)(this.myFlags & 0xFFFFFFFB);
        }
        this.myIndex = i;
    }

    @Override
    public boolean isValid() {
        return (this.myFlags & 8) == 0 && (this.myFlags & 5) != 0;
    }

    @Override
    public void invalidate() {
        this.myFlags = (byte)(this.myFlags & 0xFFFFFFFB);
    }

    @Override
    public boolean isDetached() {
        return (this.myFlags & 8) != 0;
    }

    @Override
    public void detachListener() {
        this.myFlags = (byte)(this.myFlags | 8);
        this.myParent.removePositionListener(this);
    }

    @Override
    public void setDetached() {
        this.myFlags = (byte)(this.myFlags | 8);
    }

    @Override
    public void unframed() {
        this.validateDetached();
        this.myParent.unframe(this);
    }

    @Override
    @NotNull
    public PositionAnchor getAnchor() {
        return (this.myFlags & 1) != 0 ? PositionAnchor.NEXT : ((this.myFlags & 2) != 0 ? PositionAnchor.PREVIOUS : PositionAnchor.CURRENT);
    }

    @Override
    @NotNull
    public P withAnchor(@NotNull PositionAnchor anchor) {
        if (this.getAnchor() != anchor) {
            return (P)((IPosition)this.myParent.getPosition(this.myIndex, anchor));
        }
        return (P)this;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public int getIndex(int offset) {
        if (this.isValid()) {
            return this.myIndex + offset;
        }
        return offset > 0 ? this.myIndex + offset - 1 : this.myIndex + offset;
    }

    private void validateDetached() {
        if (this.isDetached()) {
            throw new IllegalStateException("Position is detached from its list");
        }
    }

    private void validateOffset(int offset) {
        if (!this.isValid() && offset == 0) {
            throw new IllegalStateException("Position is not valid");
        }
    }

    private void validateIndex(int index, int offset) {
        this.validateDetached();
        if (index < 0 || index > this.myList.size()) {
            throw new IndexOutOfBoundsException("ListPosition at " + this.myIndex + " offset: " + offset + " is out of range [" + -this.myIndex + ", " + (this.myList.size() - this.myIndex) + "]");
        }
    }

    private void validateWithIndex(int index, int offset) {
        this.validateDetached();
        this.validateOffset(offset);
        if (index < 0 || index > this.myList.size()) {
            throw new IndexOutOfBoundsException("ListPosition at " + this.myIndex + " offset: " + offset + " is out of range [" + -this.myIndex + ", " + (this.myList.size() - this.myIndex) + "]");
        }
    }

    private void validateWithElementIndex(int index, int offset) {
        this.validateDetached();
        this.validateOffset(offset);
        if (index < 0 || index >= this.myList.size()) {
            throw new IndexOutOfBoundsException("ListIndex at " + this.myIndex + " offset: " + offset + " is out of range [" + -this.myIndex + ", " + (this.myList.size() - this.myIndex) + ")");
        }
    }

    @Override
    public P getPosition(int offset) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        return (P)((IPosition)this.myParent.getPosition(index, this.getAnchor()));
    }

    @Override
    public P previous() {
        int index = this.getIndex(-1);
        this.validateIndex(index, -1);
        return (P)((IPosition)this.myParent.getPosition(index, this.getAnchor()));
    }

    @Override
    public P previousOrNull() {
        int index = this.getIndex(-1);
        return (P)(index < 0 || index > this.myList.size() ? null : (IPosition)this.myParent.getPosition(index, this.getAnchor()));
    }

    @Override
    public P next() {
        int index = this.getIndex(1);
        this.validateIndex(index, 1);
        return (P)((IPosition)this.myParent.getPosition(index, this.getAnchor()));
    }

    @Override
    public int nextIndex() {
        this.validateDetached();
        int index = this.getIndex(1);
        this.validateDetached();
        return index;
    }

    @Override
    public int previousIndex() {
        this.validateDetached();
        int index = this.getIndex(-1);
        this.validateDetached();
        return index;
    }

    @Override
    public P nextOrNull() {
        this.validateDetached();
        int index = this.getIndex(1);
        return (P)(index < 0 || index > this.myList.size() ? null : (IPosition)this.myParent.getPosition(index, this.getAnchor()));
    }

    @Override
    public Iterable<P> forwards() {
        this.validateDetached();
        return () -> this.myParent.iterator(this.withAnchor(PositionAnchor.NEXT));
    }

    @Override
    public Iterable<P> nextForwards() {
        this.validateDetached();
        return () -> this.myParent.iterator((IPosition)this.myParent.getPosition(this.getIndex(1), PositionAnchor.NEXT));
    }

    @Override
    public Iterable<P> backwards() {
        this.validateDetached();
        int index = !this.isValidElement() ? this.getIndex(-1) : this.getIndex();
        int useIndex = Math.max(0, index);
        IPosition position = (IPosition)this.myParent.getPosition(useIndex, PositionAnchor.PREVIOUS);
        if (useIndex > index) {
            position.invalidate();
        }
        return () -> this.myParent.iterator(position);
    }

    @Override
    public Iterable<P> previousBackwards() {
        this.validateDetached();
        int index = !this.isValidElement() ? this.getIndex(-2) : this.getIndex(-1);
        int useIndex = Math.max(0, index);
        IPosition position = (IPosition)this.myParent.getPosition(useIndex, PositionAnchor.PREVIOUS);
        if (useIndex > index) {
            position.invalidate();
        }
        return () -> this.myParent.iterator(position);
    }

    @Override
    public boolean isValidIndex() {
        this.validateDetached();
        return this.myIndex <= this.myList.size();
    }

    @Override
    public boolean isValidElement() {
        this.validateDetached();
        return this.isValid() && this.myIndex < this.myList.size();
    }

    @Override
    public boolean hasPrevious() {
        this.validateDetached();
        return this.getIndex(-1) >= 0;
    }

    @Override
    public boolean hasNext() {
        this.validateDetached();
        return this.getIndex(1) < this.myList.size();
    }

    @Override
    public T get() {
        return this.get(0);
    }

    @Override
    public T get(int offset) {
        int index = this.getIndex(offset);
        this.validateWithElementIndex(index, offset);
        return this.myList.get(index);
    }

    @Override
    public T getOrNull() {
        return this.getOrNull(0);
    }

    @Override
    public T getOrNull(int offset) {
        this.validateDetached();
        return (T)Utils.getOrNull(this.myList, (int)this.getIndex(offset));
    }

    @Override
    public <S extends T> S getOrNull(Class<S> elementClass) {
        this.validateDetached();
        return this.getOrNull(0, elementClass);
    }

    @Override
    public <S extends T> S getOrNull(int offset, Class<S> elementClass) {
        this.validateDetached();
        return (S)Utils.getOrNull(this.myList, (int)this.getIndex(offset), elementClass);
    }

    @Override
    public void set(T element) {
        this.set(0, element);
    }

    @Override
    public T set(int offset, T element) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        this.myFlags = (byte)(this.myFlags | 0x10);
        Object result = this.myParent.changing(index, element);
        this.myFlags = (byte)(this.myFlags & 0xFFFFFFEF);
        return (T)result;
    }

    @Override
    public boolean add(T element) {
        return this.add(0, element);
    }

    @Override
    public boolean add(int offset, T element) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        this.myList.add(index, element);
        this.myParent.inserted(index, 1);
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<T> elements) {
        return this.addAll(0, elements);
    }

    @Override
    public boolean addAll(int offset, @NotNull Collection<T> elements) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        boolean result = this.myList.addAll(index, elements);
        this.myParent.inserted(index, elements.size());
        return result;
    }

    @Override
    public T remove() {
        return this.remove(0);
    }

    @Override
    public T remove(int offset) {
        int index = this.getIndex(offset);
        this.validateWithElementIndex(index, offset);
        this.myParent.deleting(index, 1);
        T value = this.myList.remove(index);
        this.myParent.deleted(index, 1);
        return value;
    }

    @Override
    public void remove(int startOffset, int endOffset) {
        int startIndex = this.getIndex(startOffset);
        int endIndex = this.getIndex(endOffset);
        this.validateWithElementIndex(startIndex, startOffset);
        this.validateWithIndex(endIndex, endOffset);
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("startOffset: " + startOffset + " must be less than endOffset: " + endOffset);
        }
        if (startIndex < endIndex) {
            this.myParent.deleting(startIndex, endIndex - startIndex);
            this.myList.subList(startIndex, endIndex).clear();
            this.myParent.deleted(startIndex, endIndex - startIndex);
        }
    }

    @Override
    public int maxOffset() {
        return this.myList.size() - this.myIndex;
    }

    @Override
    public int minOffset() {
        return -this.myIndex;
    }

    @Override
    public int size() {
        return this.myList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @Override
    public boolean append(T element) {
        this.validateDetached();
        int index = this.myList.size();
        this.myList.add(element);
        this.myParent.inserted(index, 1);
        return true;
    }

    @Override
    public P indexOf(T o) {
        return this.indexOf(0, o);
    }

    @Override
    public P indexOf(int offset, T o) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        int itemIndex = this.myList.subList(index, this.myList.size()).indexOf(o);
        return (P)(itemIndex == -1 ? (IPosition)this.myParent.getPosition(this.myList.size(), this.getAnchor()) : (IPosition)this.myParent.getPosition(itemIndex + index, this.getAnchor()));
    }

    @Override
    public P indexOf(@NotNull Predicate<P> predicate) {
        return this.indexOf(0, predicate);
    }

    @Override
    public P indexOf(int offset, @NotNull Predicate<P> predicate) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        int iMax = this.myList.size();
        PositionAnchor anchor = this.getAnchor();
        for (int i = index; i < iMax; ++i) {
            IPosition pos = (IPosition)this.myParent.getPosition(i, anchor);
            if (!predicate.test(pos)) continue;
            return (P)pos;
        }
        return (P)((IPosition)this.myParent.getPosition(this.myList.size(), anchor));
    }

    @Override
    public P lastIndexOf(T o) {
        return this.lastIndexOf(0, o);
    }

    @Override
    public P lastIndexOf(int offset, T o) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        int itemIndex = this.myList.subList(0, index).lastIndexOf(o);
        return (P)(itemIndex == -1 ? (IPosition)this.myParent.getPosition(this.myList.size(), this.getAnchor()) : (IPosition)this.myParent.getPosition(itemIndex, this.getAnchor()));
    }

    @Override
    public P lastIndexOf(@NotNull Predicate<P> predicate) {
        return this.lastIndexOf(0, predicate);
    }

    @Override
    public P lastIndexOf(int offset, @NotNull Predicate<P> predicate) {
        int index = this.getIndex(offset);
        this.validateWithIndex(index, offset);
        int iMax = index;
        PositionAnchor anchor = this.getAnchor();
        int i = iMax;
        while (i-- > 0) {
            IPosition pos = (IPosition)this.myParent.getPosition(i, anchor);
            if (!predicate.test(pos)) continue;
            return (P)pos;
        }
        return (P)((IPosition)this.myParent.getPosition(this.myList.size(), anchor));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "Position{anchor=" + this.getAnchor() + ", index=" + this.myIndex + ", valid=" + this.isValid() + "}";
    }
}

