/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.collection.iteration;

import java.util.Iterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class MappingIterable<T, R>
implements Iterable<R> {
    @NotNull
    private final Iterable<T> myIterable;
    @NotNull
    private final Function<T, R> myFunction;

    public MappingIterable(@NotNull Iterable<T> iterable, @NotNull Function<T, R> function) {
        this.myIterable = iterable;
        this.myFunction = function;
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        return new MyIterator<T, R>(this.myIterable.iterator(), this.myFunction);
    }

    private static class MyIterator<E, V>
    implements Iterator<V> {
        @NotNull
        private final Iterator<E> myIterator;
        @NotNull
        private final Function<E, V> myFunction;

        public MyIterator(@NotNull Iterator<E> iterator, @NotNull Function<E, V> function) {
            this.myIterator = iterator;
            this.myFunction = function;
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public V next() {
            return this.myFunction.apply(this.myIterator.next());
        }
    }
}

