/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.tree.iteration;

import com.vladsch.flexmark.tree.iteration.FixedIterationConditions;
import com.vladsch.flexmark.tree.iteration.TreeIterator;
import com.vladsch.flexmark.tree.iteration.ValueIterationAdapter;
import com.vladsch.flexmark.tree.iteration.ValueIterationAdapterImpl;
import com.vladsch.flexmark.tree.iteration.ValueIterationConsumer;
import com.vladsch.flexmark.tree.iteration.ValueIterationFilter;
import com.vladsch.flexmark.tree.iteration.VoidIterationConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class MappedIterator<B, T extends B> {
    @NotNull
    protected final B myElement;
    @NotNull
    protected final ValueIterationAdapter<? super B, T> myAdapter;
    @NotNull
    protected final TreeIterator<B> myTreeIterator;

    public MappedIterator(@NotNull B element, @NotNull ValueIterationAdapter<? super B, T> adapter, @NotNull TreeIterator<B> treeIterator) {
        this.myElement = element;
        this.myAdapter = adapter;
        this.myTreeIterator = treeIterator;
    }

    @NotNull
    public final TreeIterator<B> getTreeIterator() {
        return this.myTreeIterator;
    }

    @NotNull
    public final <R> R doLoop(@NotNull R defaultValue, @NotNull ValueIterationConsumer<? super T, R> consumer) {
        return this.myTreeIterator.doLoop(this.myElement, defaultValue, this.myAdapter, consumer);
    }

    public final void doLoop(@NotNull VoidIterationConsumer<? super T> consumer) {
        this.myTreeIterator.doLoop(this.myElement, this.myAdapter, consumer);
    }

    @NotNull
    public MappedIterator<B, T> getModifiedCopy(B element, ValueIterationAdapter<? super B, T> adapter, TreeIterator<B> treeIterator) {
        return new MappedIterator<B, T>(element, adapter, treeIterator);
    }

    @NotNull
    public <F extends B> MappedIterator<B, F> getModifiedCopyF(B element, ValueIterationAdapter<? super B, F> adapter, TreeIterator<B> treeIterator) {
        return new MappedIterator<B, F>(element, adapter, treeIterator);
    }

    @NotNull
    public MappedIterator<B, T> reversed() {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.reversed());
    }

    @NotNull
    public MappedIterator<B, T> recursive() {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.recursive());
    }

    @NotNull
    public MappedIterator<B, T> nonRecursive() {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.nonRecursive());
    }

    @NotNull
    public MappedIterator<B, T> recursive(boolean recursive) {
        return recursive ? this.recursive() : this.nonRecursive();
    }

    @NotNull
    public MappedIterator<B, T> nonRecursive(boolean nonRecursive) {
        return nonRecursive ? this.nonRecursive() : this.recursive();
    }

    @NotNull
    public MappedIterator<B, T> recurse(@NotNull Predicate<? super B> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.recurse(predicate));
    }

    @NotNull
    public MappedIterator<B, T> recurse(@NotNull Class<? super B> clazz) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.recurse(clazz));
    }

    @NotNull
    public <F extends B> MappedIterator<B, T> recurse(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.recurse(clazz, predicate));
    }

    @NotNull
    public MappedIterator<B, T> noRecurse(@NotNull Predicate<? super B> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.noRecurse(predicate));
    }

    @NotNull
    public MappedIterator<B, T> noRecurse(@NotNull Class<? super B> clazz) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.noRecurse(clazz));
    }

    @NotNull
    public <F extends B> MappedIterator<B, T> noRecurse(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.recurse(clazz, predicate));
    }

    @NotNull
    public MappedIterator<B, T> filterFalse() {
        return this.aborted();
    }

    @NotNull
    public MappedIterator<B, T> aborted() {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.aborted());
    }

    @NotNull
    public MappedIterator<B, T> filterOut(@NotNull Predicate<? super B> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.filterOut(predicate));
    }

    @NotNull
    public MappedIterator<B, T> filterOut(@NotNull Class<? super B> clazz) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.filterOut(clazz));
    }

    @NotNull
    public <F extends B> MappedIterator<B, T> filterOut(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.filterOut(clazz, predicate));
    }

    @NotNull
    public MappedIterator<B, T> filter(@NotNull Predicate<? super B> predicate) {
        return this.getModifiedCopy(this.myElement, this.myAdapter, this.myTreeIterator.filter(predicate));
    }

    @NotNull
    public MappedIterator<B, T> acceptFilter(@NotNull ValueIterationFilter<? super T> filter) {
        return this.getModifiedCopy(this.myElement, this.myAdapter.andThen(ValueIterationAdapterImpl.of(filter)), this.myTreeIterator);
    }

    @NotNull
    public <F extends B> MappedIterator<B, F> filter(@NotNull Class<F> clazz) {
        return this.getModifiedCopyF(this.myElement, this.myAdapter.andThen(ValueIterationAdapterImpl.of(clazz)), this.myTreeIterator);
    }

    @NotNull
    public <F extends B> MappedIterator<B, F> filter(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.getModifiedCopyF(this.myElement, this.myAdapter.andThen(ValueIterationAdapterImpl.of(clazz, predicate)), this.myTreeIterator);
    }

    @NotNull
    public <F extends B> MappedIterator<B, F> adapt(@NotNull Function<? super T, F> adapter) {
        return this.getModifiedCopyF(this.myElement, this.myAdapter.andThen(ValueIterationAdapterImpl.of(adapter)), this.myTreeIterator);
    }

    @NotNull
    public <F extends B> MappedIterator<B, F> adapt(@NotNull ValueIterationAdapter<? super T, F> adapter) {
        return this.getModifiedCopyF(this.myElement, this.myAdapter.andThen(adapter), this.myTreeIterator);
    }

    @NotNull
    public MappedIterator<Object, B> toObjectMapped(Class<B> clazz) {
        Function<Object, Object> objectToB = it -> clazz.isInstance(it) ? clazz.cast(it) : null;
        Function<Object, Object> tToObject = it -> it;
        FixedIterationConditions<Object> constraints = FixedIterationConditions.mapTtoB(this.myTreeIterator.getConstraints(), objectToB, tToObject);
        return new MappedIterator<Object, Object>(this.myElement, new ValueIterationAdapterImpl<Object, Object>(objectToB), new TreeIterator<Object>(constraints));
    }

    public static <N> MappedIterator<N, N> create(N element, @NotNull TreeIterator<N> treeIterator) {
        return new MappedIterator(element, ValueIterationAdapterImpl.of(), treeIterator);
    }
}

