/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util.spec;

import com.vladsch.flexmark.test.util.spec.ResourceUrlResolver;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ResourceResolverManager {
    private static final ArrayList<Function<String, String>> urlResolvers = new ArrayList();

    public static void registerUrlResolver(@NotNull Function<String, String> resolver) {
        urlResolvers.add(resolver);
    }

    @NotNull
    public static String adjustedFileUrl(@NotNull URL url) {
        String externalForm = url.toExternalForm();
        String bestProtocolMatch = null;
        for (Function<String, String> resolver : urlResolvers) {
            String filePath = resolver.apply(externalForm);
            if (filePath == null) continue;
            if (ResourceUrlResolver.hasProtocol(filePath) && bestProtocolMatch == null) {
                bestProtocolMatch = filePath;
                continue;
            }
            File file = new File(filePath);
            if (!file.exists()) continue;
            return "file://" + filePath;
        }
        return bestProtocolMatch != null ? bestProtocolMatch : externalForm;
    }
}

