/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class SpecExampleParse {
    private DataHolder myOptions;
    private SpecExampleRenderer myRenderer;
    private DataHolder myExampleOptions;
    private String mySource;
    private boolean myTimed;
    private int myIterations;
    private long myStartTime;
    private long myParseTime;

    public SpecExampleParse(DataHolder options, SpecExampleRenderer exampleRenderer, DataHolder exampleOptions, String parseSource) {
        this.myOptions = options;
        this.myRenderer = exampleRenderer;
        this.myExampleOptions = exampleOptions;
        this.mySource = parseSource;
        this.parse(parseSource);
    }

    public DataHolder getOptions() {
        return this.myOptions;
    }

    public SpecExampleRenderer getRenderer() {
        return this.myRenderer;
    }

    public DataHolder getExampleOptions() {
        return this.myExampleOptions;
    }

    public String getSource() {
        return this.mySource;
    }

    public boolean isTimed() {
        return this.myTimed;
    }

    public int getIterations() {
        return this.myIterations;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getParseTime() {
        return this.myParseTime;
    }

    public String parse(String source) {
        BasedSequence input;
        if (((Boolean)TestUtils.NO_FILE_EOL.get(this.myOptions)).booleanValue()) {
            this.mySource = TestUtils.trimTrailingEOL(source);
        }
        String sourcePrefix = (String)TestUtils.SOURCE_PREFIX.get(this.myExampleOptions);
        String sourceSuffix = (String)TestUtils.SOURCE_SUFFIX.get(this.myExampleOptions);
        String sourceIndent = (String)TestUtils.SOURCE_INDENT.get(this.myExampleOptions);
        if (!sourcePrefix.isEmpty() || !sourceSuffix.isEmpty()) {
            String combinedSource = sourcePrefix + Utils.suffixWith((String)this.mySource, (String)"\n") + sourceSuffix;
            input = BasedSequence.of((CharSequence)combinedSource).subSequence(0, combinedSource.length()).subSequence(sourcePrefix.length(), combinedSource.length() - sourceSuffix.length());
        } else {
            input = BasedSequence.of((CharSequence)this.mySource);
        }
        input = TestUtils.stripIndent(input, sourceIndent);
        String includedText = (String)TestUtils.INCLUDED_DOCUMENT.get(this.myExampleOptions);
        this.myRenderer.includeDocument(includedText);
        this.myTimed = (Boolean)TestUtils.TIMED.get(this.myExampleOptions);
        this.myIterations = this.myTimed ? (Integer)TestUtils.TIMED_ITERATIONS.get(this.myExampleOptions) : 1;
        this.myStartTime = System.nanoTime();
        this.myRenderer.parse(input.toString());
        for (int i = 1; i < this.myIterations; ++i) {
            this.myRenderer.parse((CharSequence)input);
        }
        this.myParseTime = System.nanoTime();
        this.myRenderer.finalizeDocument();
        return this.mySource;
    }

    public void finalizeRender() {
        this.myRenderer.finalizeRender();
    }
}

