/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpecExampleRendererBase
implements SpecExampleRenderer {
    @NotNull
    protected final SpecExample myExample;
    @NotNull
    protected final DataHolder myOptions;
    protected final boolean myIncludeExampleInfo;
    private boolean myIsFinalized;
    @Nullable
    private String myRenderedHtml;
    @Nullable
    private String myRenderedAst;

    public SpecExampleRendererBase(@NotNull SpecExample example, @Nullable DataHolder options) {
        this(example, options, true);
    }

    public SpecExampleRendererBase(@NotNull SpecExample example, @Nullable DataHolder options, boolean includeExampleInfo) {
        this.myExample = example;
        this.myOptions = options == null ? new DataSet() : options.toImmutable();
        this.myIncludeExampleInfo = includeExampleInfo;
    }

    public boolean isFinalized() {
        return this.myIsFinalized;
    }

    @Override
    @NotNull
    public final String getHtml() {
        if (this.myRenderedHtml == null || !this.isFinalized()) {
            this.myRenderedHtml = this.renderHtml();
        }
        return this.myRenderedHtml;
    }

    @Override
    @NotNull
    public final String getAst() {
        if (this.myRenderedAst == null || !this.isFinalized()) {
            this.myRenderedAst = this.renderAst();
        }
        return this.myRenderedAst;
    }

    @NotNull
    protected abstract String renderHtml();

    @NotNull
    protected abstract String renderAst();

    @Override
    public void finalizeRender() {
        this.myIsFinalized = true;
    }

    @Override
    public boolean includeExampleInfo() {
        return this.myIncludeExampleInfo;
    }

    @Override
    @NotNull
    public SpecExample getExample() {
        return this.myExample;
    }

    @Override
    @NotNull
    public DataHolder getOptions() {
        return this.myOptions.toImmutable();
    }
}

