/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.jetbrains.annotations.NotNull;

public class ExceptionMatcher
extends BaseMatcher<Throwable> {
    @NotNull
    private final String prefix;
    @NotNull
    private final Pattern pattern;
    @NotNull
    private final String message;

    public ExceptionMatcher(@NotNull Class<? extends Throwable> throwable, @NotNull Pattern pattern, @NotNull String message) {
        this.prefix = throwable.getName();
        this.pattern = pattern;
        this.message = message;
    }

    public boolean matches(Object o) {
        if (o instanceof RuntimeException) {
            if (o.toString().startsWith(this.prefix + ": ")) {
                return this.pattern.matcher(o.toString().substring(this.prefix.length() + ": ".length())).matches();
            }
        } else if (o instanceof Throwable && o.toString().startsWith(this.prefix)) {
            Throwable throwable = (Throwable)o;
            String input = throwable.getCause().toString();
            return this.pattern.matcher(input).matches();
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText(this.prefix + ": " + this.message);
    }

    @NotNull
    public static ExceptionMatcher match(@NotNull Class<? extends Throwable> throwable, @NotNull String text) {
        return new ExceptionMatcher(throwable, Pattern.compile(Pattern.quote(text)), text);
    }

    @NotNull
    public static ExceptionMatcher matchPrefix(@NotNull Class<? extends Throwable> throwable, @NotNull String text) {
        return new ExceptionMatcher(throwable, Pattern.compile(Pattern.quote(text) + "(?s:.*)"), text);
    }

    @NotNull
    public static ExceptionMatcher matchRegEx(@NotNull Class<? extends Throwable> throwable, @NotNull String regEx) {
        return new ExceptionMatcher(throwable, Pattern.compile(regEx), regEx);
    }
}

