/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.test.FullSpecTestCase;
import com.vladsch.flexmark.test.RenderingTestCase;
import com.vladsch.flexmark.util.IParse;
import com.vladsch.flexmark.util.IRender;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.io.InputStream;
import org.junit.AssumptionViolatedException;

public class DumpSpecReader
extends SpecReader {
    protected final StringBuilder sb = new StringBuilder();
    protected final FullSpecTestCase testCase;
    protected StringBuilder exampleComment;

    public DumpSpecReader(InputStream stream, FullSpecTestCase testCase) {
        super(stream);
        this.testCase = testCase;
    }

    public String getFullSpec() {
        return this.sb.toString();
    }

    @Override
    public void addSpecLine(String line) {
        this.sb.append(line).append("\n");
    }

    @Override
    protected void addSpecExample(SpecExample example) {
        String html;
        boolean timed;
        BasedSequence input;
        DataHolder options;
        boolean ignoredCase = false;
        try {
            options = this.testCase.getOptions(example, example.getOptionsSet());
        }
        catch (AssumptionViolatedException ignored) {
            ignoredCase = true;
            options = null;
        }
        if (options != null && ((Boolean)options.get(RenderingTestCase.FAIL)).booleanValue()) {
            ignoredCase = true;
        }
        IParse parserWithOptions = this.testCase.parser().withOptions(options);
        IRender rendererWithOptions = this.testCase.renderer().withOptions(options);
        String parseSource = example.getSource();
        if (options != null && ((Boolean)options.get(RenderingTestCase.NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        String sourcePrefix = (String)RenderingTestCase.SOURCE_PREFIX.getFrom(parserWithOptions.getOptions());
        String sourceSuffix = (String)RenderingTestCase.SOURCE_SUFFIX.getFrom(parserWithOptions.getOptions());
        String sourceIndent = (String)RenderingTestCase.SOURCE_INDENT.getFrom(parserWithOptions.getOptions());
        if (!sourcePrefix.isEmpty() || !sourceSuffix.isEmpty()) {
            String combinedSource = sourcePrefix + Utils.suffixWith((String)parseSource, (String)"\n") + sourceSuffix;
            input = BasedSequenceImpl.of((CharSequence)combinedSource).subSequence(sourcePrefix.length(), combinedSource.length() - sourceSuffix.length());
        } else {
            input = BasedSequenceImpl.of((CharSequence)parseSource);
        }
        input = RenderingTestCase.stripIndent(input, sourceIndent);
        Node includedDocument = null;
        String includedText = (String)RenderingTestCase.INCLUDED_DOCUMENT.getFrom(parserWithOptions.getOptions());
        if (includedText != null && !includedText.isEmpty() && (includedDocument = parserWithOptions.parse(includedText)) instanceof Document) {
            parserWithOptions = this.testCase.adjustParserForInclusion(parserWithOptions, (Document)includedDocument);
        }
        int iterations = (timed = ((Boolean)RenderingTestCase.TIMED.getFrom(parserWithOptions.getOptions())).booleanValue()) ? (Integer)RenderingTestCase.TIMED_ITERATIONS.getFrom(parserWithOptions.getOptions()) : 1;
        long start = System.nanoTime();
        Node node = parserWithOptions.parse(input);
        for (int i = 1; i < iterations; ++i) {
            parserWithOptions.parse(input);
        }
        long parse = System.nanoTime();
        if (node instanceof Document && includedDocument instanceof Document) {
            parserWithOptions.transferReferences((Document)node, (Document)includedDocument);
        }
        String actualHTML = rendererWithOptions.render(node);
        for (int i = 1; i < iterations; ++i) {
            rendererWithOptions.render(node);
        }
        long render = System.nanoTime();
        boolean embedTimed = (Boolean)RenderingTestCase.EMBED_TIMED.getFrom((DataHolder)node.getDocument());
        if (timed || embedTimed) {
            System.out.println(String.format("Timing %s: parse %.3f ms, render %.3f ms, total %.3f\n", example.getSection() == null ? "" : example.getSection().trim() + ": " + example.getExampleNumber(), (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
        }
        String actualAST = this.testCase.ast(node);
        String string = html = !ignoredCase && this.testCase.useActualHtml() ? actualHTML : example.getHtml();
        String ast = example.getAst() == null ? null : (!ignoredCase ? actualAST : example.getAst());
        this.testCase.addSpecExample(example, node, options, ignoredCase, actualHTML, actualAST);
        if (embedTimed) {
            this.sb.append(String.format("Timing %s: parse %.3f ms, render %.3f ms, total %.3f\n", example.getSection() == null ? "" : example.getSection().trim() + ": " + example.getExampleNumber(), (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
        }
        DumpSpecReader.addSpecExample(this.sb, example.getSource(), html, ast, example.getOptionsSet(), this.testCase.includeExampleCoords(), example.getSection(), example.getExampleNumber());
    }

    public static String addSpecExample(String source, String html, String ast, String optionsSet) {
        StringBuilder sb = new StringBuilder();
        DumpSpecReader.addSpecExample(sb, source, html, ast, optionsSet, false, "", 0);
        return sb.toString();
    }

    public static void addSpecExample(StringBuilder sb, String source, String html, String ast, String optionsSet, boolean includeExampleCoords, String section, int number) {
        StringBuilder header = new StringBuilder();
        header.append("```````````````````````````````` example");
        if (includeExampleCoords) {
            if (optionsSet != null) {
                header.append("(").append(section == null ? "" : section.trim()).append(": ").append(number).append(")");
            } else {
                header.append(" ").append(section == null ? "" : section.trim()).append(": ").append(number);
            }
        }
        if (optionsSet != null) {
            header.append(" options(").append(optionsSet).append(")");
        }
        header.append("\n");
        if (includeExampleCoords) {
            sb.append(header.toString().replace(' ', '\u00a0'));
        } else {
            sb.append(header.toString());
        }
        if (ast != null) {
            sb.append(DumpSpecReader.showTabs(source + "." + "\n" + html)).append(".").append("\n").append(ast).append("````````````````````````````````").append("\n");
        } else {
            sb.append(DumpSpecReader.showTabs(source + "." + "\n" + html)).append("````````````````````````````````").append("\n");
        }
    }

    public static String showTabs(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\u2192", "&#2192;").replace("\t", "\u2192").replace("\u23ae", "&#23ae;").replace("\u001f", "\u23ae").replace("\u23ce", "&#23ce").replace("\r", "\u23ce");
    }

    public static String unShowTabs(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\u23ce", "\r").replace("&#23ce", "\u23ce").replace("\u23ae", "\u001f").replace("&#23ae;", "\u23ae").replace('\u2192', '\t').replace("&#2192;", "\u2192");
    }

    public static String trimTrailingEOL(String parseSource) {
        if (!parseSource.isEmpty() && parseSource.charAt(parseSource.length() - 1) == '\n') {
            int pos = parseSource.lastIndexOf(10, parseSource.length() - 2);
            if (pos == -1 || !parseSource.substring(pos + 1).trim().isEmpty()) {
                parseSource = parseSource.substring(0, parseSource.length() - 1);
            } else {
                boolean bl = false;
            }
        }
        return parseSource;
    }
}

