/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.IParse;
import com.vladsch.flexmark.IRender;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.test.AstCollectingVisitor;
import com.vladsch.flexmark.test.DumpSpecReader;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataSet;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public abstract class RenderingTestCase {
    public static final String IGNORE_OPTION_NAME = "IGNORE";
    public static final String FAIL_OPTION_NAME = "FAIL";
    public static final String NO_FILE_EOL_OPTION_NAME = "NO_FILE_EOL";
    public static final String FILE_EOL_OPTION_NAME = "FILE_EOL";
    public static DataKey<Boolean> FAIL = new DataKey("FAIL", (Object)false);
    public static DataKey<Boolean> IGNORE = new DataKey("IGNORE", (Object)false);
    public static DataKey<Boolean> NO_FILE_EOL = new DataKey("NO_FILE_EOL", (Object)true);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public abstract IParse parser();

    public abstract IRender renderer();

    public abstract SpecExample example();

    public DataHolder options(String optionSet) {
        assert (optionSet == null);
        return null;
    }

    public DataHolder getOptions(SpecExample example, String optionSets) {
        if (optionSets == null) {
            return null;
        }
        String[] optionNames = optionSets.replace('\u00a0', ' ').split(",");
        MutableDataSet options = null;
        boolean isFirst = true;
        for (String optionName : optionNames) {
            String option = optionName.trim();
            if (option.isEmpty() || option.startsWith("-")) continue;
            if (option.equals(IGNORE_OPTION_NAME)) {
                this.throwIgnoredOption(example, optionSets, option);
                continue;
            }
            if (option.equals(FAIL_OPTION_NAME)) {
                if (options == null) {
                    options = new MutableDataSet().set(FAIL, (Object)true);
                    continue;
                }
                options = new MutableDataSet(options).set(FAIL, (Object)true);
                continue;
            }
            if (option.equals(NO_FILE_EOL_OPTION_NAME)) {
                if (options == null) {
                    options = new MutableDataSet().set(NO_FILE_EOL, (Object)true);
                    continue;
                }
                options = new MutableDataSet((DataHolder)options).set(NO_FILE_EOL, (Object)true);
                continue;
            }
            if (option.equals(FILE_EOL_OPTION_NAME)) {
                if (options == null) {
                    options = new MutableDataSet().set(NO_FILE_EOL, (Object)false);
                    continue;
                }
                options = new MutableDataSet((DataHolder)options).set(NO_FILE_EOL, (Object)true);
                continue;
            }
            if (options == null) {
                options = this.options(option);
                if (options == null) {
                    throw new IllegalStateException("Option " + option + " is not implemented in the RenderingTestCase subclass");
                }
            } else {
                DataHolder dataSet = this.options(option);
                if (dataSet != null) {
                    if (isFirst) {
                        options = new MutableDataSet((DataHolder)options);
                        isFirst = false;
                    }
                    options.setAll(dataSet);
                } else {
                    throw new IllegalStateException("Option " + option + " is not implemented in the RenderingTestCase subclass");
                }
            }
            if (!((Boolean)IGNORE.getFrom((DataHolder)options)).booleanValue()) continue;
            this.throwIgnoredOption(example, optionSets, option);
        }
        return options;
    }

    private void throwIgnoredOption(SpecExample example, String optionSets, String option) {
        if (example == null) {
            throw new AssumptionViolatedException("Ignored: SpecExample test case options(" + optionSets + ") is using " + option + " option");
        }
        throw new AssumptionViolatedException("Ignored: example(" + example.getSection() + ": " + example.getExampleNumber() + ") options(" + optionSets + ") is using " + option + " option");
    }

    public String ast(Node node) {
        return new AstCollectingVisitor().collectAndGetAstText(node);
    }

    protected void actualSource(String html, String optionSet) {
    }

    protected void testCase(Node node, DataHolder options) {
    }

    protected void actualHtml(String html, String optionSet) {
    }

    protected void actualAst(String ast, String optionSet) {
    }

    protected void specExample(String expected, String actual, String optionSet) {
    }

    protected void assertRendering(String source, String expectedHtml) {
        this.assertRendering(source, expectedHtml, null);
    }

    protected boolean useActualHtml() {
        return true;
    }

    protected void assertRendering(String source, String expectedHtml, String optionsSet) {
        String actual;
        String expected;
        DataHolder options = optionsSet == null ? null : this.getOptions(this.example(), optionsSet);
        String parseSource = source;
        if (options != null && ((Boolean)options.get(NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        Node node = this.parser().withOptions(options).parse(parseSource);
        String html = this.renderer().withOptions(options).render(node);
        this.testCase(node, options);
        this.actualHtml(html, optionsSet);
        boolean useActualHtml = this.useActualHtml();
        if (this.example() != null && this.example().getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            DumpSpecReader.addSpecExample(outExpected, source, expectedHtml, "", optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            DumpSpecReader.addSpecExample(outActual, source, useActualHtml ? html : expectedHtml, "", optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            actual = outActual.toString();
        } else {
            expected = DumpSpecReader.addSpecExample(source, expectedHtml, "", optionsSet);
            actual = DumpSpecReader.addSpecExample(source, useActualHtml ? html : expectedHtml, "", optionsSet);
        }
        this.specExample(expected, actual, optionsSet);
        if (options != null && ((Boolean)options.get(FAIL)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertRenderingAst(String source, String expectedHtml, String expectedAst, String optionsSet) {
        String actual;
        String expected;
        DataHolder options = optionsSet == null ? null : this.getOptions(this.example(), optionsSet);
        String parseSource = source;
        if (options != null && ((Boolean)options.get(NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        Node node = this.parser().withOptions(options).parse(parseSource);
        String html = this.renderer().withOptions(options).render(node);
        this.testCase(node, options);
        this.actualHtml(html, optionsSet);
        String ast = this.ast(node);
        this.actualAst(ast, optionsSet);
        boolean useActualHtml = this.useActualHtml();
        if (this.example() != null && this.example().getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            DumpSpecReader.addSpecExample(outExpected, source, expectedHtml, expectedAst, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            DumpSpecReader.addSpecExample(outActual, source, useActualHtml ? html : expectedHtml, ast, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            actual = outActual.toString();
        } else {
            expected = DumpSpecReader.addSpecExample(source, expectedHtml, expectedAst, optionsSet);
            actual = DumpSpecReader.addSpecExample(source, useActualHtml ? html : expectedHtml, ast, optionsSet);
        }
        this.specExample(expected, actual, optionsSet);
        if (options != null && ((Boolean)options.get(FAIL)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertAst(String source, String expectedAst, String optionsSet) {
        String actual;
        String expected;
        DataHolder options = optionsSet == null ? null : this.getOptions(this.example(), optionsSet);
        String parseSource = source;
        if (options != null && ((Boolean)options.get(NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        Node node = this.parser().withOptions(options).parse(parseSource);
        String ast = this.ast(node);
        this.actualAst(ast, optionsSet);
        if (this.example() != null && this.example().getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            DumpSpecReader.addSpecExample(outExpected, source, "", expectedAst, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            DumpSpecReader.addSpecExample(outActual, source, "", ast, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            actual = outActual.toString();
        } else {
            expected = DumpSpecReader.addSpecExample(source, "", expectedAst, optionsSet);
            actual = DumpSpecReader.addSpecExample(source, "", ast, optionsSet);
        }
        this.specExample(expected, actual, optionsSet);
        if (options != null && ((Boolean)options.get(FAIL)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

