/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateEntry {
    private final int entryNumber;
    private final String source;
    private final HashSet<String> params = new HashSet();
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$[a-zA-Z_]+\\$");

    public TemplateEntry(int entryNumber, String source) {
        this.entryNumber = entryNumber;
        this.source = source;
        Matcher m = PARAMETER_PATTERN.matcher(source);
        while (m.find()) {
            String param = m.group().substring(1, m.group().length() - 1);
            this.params.add(param);
        }
    }

    public String getSource() {
        return this.source;
    }

    public Set<String> getParams() {
        return this.params;
    }

    public void replaceParams(Map<String, String> params, StringBuilder sb) {
        Matcher m = PARAMETER_PATTERN.matcher(this.source);
        int pos = 0;
        while (m.find()) {
            String param = m.group().substring(1, m.group().length() - 1);
            if (pos < m.start()) {
                sb.append(this.source.substring(pos, m.start()));
                pos = m.end();
            }
            if (!params.containsKey(param)) continue;
            sb.append(params.get(param));
        }
        if (pos < this.source.length()) {
            sb.append(this.source.substring(pos));
        }
    }

    public int getEntryNumber() {
        return this.entryNumber;
    }

    public String toString() {
        return "entry " + this.entryNumber;
    }
}

