/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

import com.vladsch.flexmark.spec.TemplateEntry;
import com.vladsch.flexmark.spec.TemplateReaderFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class TemplateReader {
    public static final String ENTRY_START = "```````````````````````````````` template";
    public static final String ENTRY_BREAK = "````````````````````````````````";
    protected final InputStream inputStream;
    protected State state = State.BEFORE;
    protected StringBuilder source;
    protected int entryNumber = 0;
    protected List<TemplateEntry> examples = new ArrayList<TemplateEntry>();

    protected TemplateReader(InputStream stream) {
        this.inputStream = stream;
    }

    public static List<TemplateEntry> readEntries() {
        return TemplateReader.readEntries(null, null);
    }

    public static List<TemplateEntry> readEntries(String resource) {
        return TemplateReader.readEntries(resource, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<TemplateEntry> readEntries(String resource, TemplateReaderFactory readerFactory) {
        try (InputStream stream = TemplateReader.getSpecInputStream(resource);){
            TemplateReader reader = readerFactory == null ? new TemplateReader(stream) : readerFactory.create(stream);
            List<TemplateEntry> list = reader.read();
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readExamplesAsString() {
        return TemplateReader.readExamplesAsString(null, null);
    }

    public static List<String> readExamplesAsString(String resource) {
        return TemplateReader.readExamplesAsString(resource, null);
    }

    public static List<String> readExamplesAsString(String resource, TemplateReaderFactory readerFactory) {
        List<TemplateEntry> examples = TemplateReader.readEntries(resource, readerFactory);
        ArrayList<String> result = new ArrayList<String>();
        for (TemplateEntry example : examples) {
            result.add(example.getSource());
        }
        return result;
    }

    public static String readSpec() {
        return TemplateReader.readSpec(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSpec(String resource) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TemplateReader.getSpecInputStream(resource), Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getSpecInputStream() {
        return TemplateReader.getSpecInputStream(null);
    }

    public static InputStream getSpecInputStream(String resource) {
        String specPath = resource != null ? resource : "/template.txt";
        InputStream stream = TemplateReader.class.getResourceAsStream(specPath);
        if (stream == null) {
            throw new IllegalStateException("Could not load " + resource + " classpath resource");
        }
        return stream;
    }

    protected List<TemplateEntry> read() throws IOException {
        this.resetContents();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        return this.examples;
    }

    protected void addSpecLine(String line) {
    }

    protected void addTemplateEntry(TemplateEntry example) {
        this.examples.add(example);
    }

    protected void processLine(String line) {
        boolean lineAbsorbed = false;
        switch (this.state) {
            case BEFORE: {
                if (!line.endsWith(ENTRY_START)) break;
                this.state = State.SOURCE;
                ++this.entryNumber;
                lineAbsorbed = true;
                break;
            }
            case SOURCE: {
                if (line.endsWith(ENTRY_BREAK)) {
                    this.state = State.BEFORE;
                    this.addTemplateEntry(new TemplateEntry(this.entryNumber, this.source.toString()));
                    this.resetContents();
                    lineAbsorbed = true;
                    break;
                }
                this.source.append(line).append('\n');
                lineAbsorbed = true;
            }
        }
        if (!lineAbsorbed) {
            this.addSpecLine(line);
        }
    }

    protected void resetContents() {
        this.source = new StringBuilder();
    }

    protected static enum State {
        BEFORE,
        SOURCE;

    }
}

