/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.ext.toc.internal.TocOptionsParser;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.util.DelimitedBuilder;
import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.Paired;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class TocUtils {
    public static final AttributablePart TOC_CONTENT = new AttributablePart("TOC_CONTENT");
    public static final AttributablePart TOC_LIST = new AttributablePart("TOC_LIST");

    public static String getTocPrefix(TocOptions options, TocOptions defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(" ");
        out.append("[TOC").mark();
        TocOptionsParser optionsParser = new TocOptionsParser();
        out.append(optionsParser.getOptionText(options, defaultOptions));
        out.unmark().append("]");
        out.append("\n").unmark();
        return out.toString();
    }

    public static String getSimTocPrefix(TocOptions options, TocOptions defaultOptions) {
        DelimitedBuilder out = new DelimitedBuilder(" ");
        out.append("[TOC").mark();
        SimTocOptionsParser optionsParser = new SimTocOptionsParser();
        out.append(optionsParser.getOptionText(options, defaultOptions));
        out.unmark().append("]:").mark().append('#').mark();
        String optionTitleHeading = options.getTitleHeading();
        String optionTitle = options.title;
        if (defaultOptions == null || !optionTitleHeading.equals(defaultOptions.getTitleHeading())) {
            if (!optionTitle.isEmpty()) {
                out.append('\"');
                if (defaultOptions == null || options.titleLevel != defaultOptions.titleLevel) {
                    out.append(optionTitleHeading);
                } else {
                    out.append(optionTitle);
                }
                out.append('\"').mark();
            } else {
                out.append("\"\"").mark();
            }
        }
        out.unmark().append("\n").unmark();
        return out.toString();
    }

    public static void renderTocContent(HtmlWriter out, String tocContents, TocOptions options, List<Heading> headings, List<String> headingTexts) {
        if (headings.isEmpty()) {
            return;
        }
        if (options.isHtml) {
            TocUtils.renderHtmlToc(out, BasedSequence.NULL, headings, headingTexts, options);
        } else {
            TocUtils.renderMarkdownToc(out, headings, headingTexts, options);
        }
    }

    public static void renderHtmlToc(HtmlWriter html, BasedSequence sourceText, List<Heading> headings, List<String> headingTexts, TocOptions tocOptions) {
        int i;
        if (headings.size() > 0 && (sourceText.isNotNull() || !tocOptions.title.isEmpty())) {
            if (sourceText.isNotNull()) {
                html.srcPos(sourceText);
            }
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)tocOptions.divClass)).withAttr(TOC_CONTENT).tag((CharSequence)"div")).line()).indent();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag((CharSequence)("h" + tocOptions.titleLevel))).text((CharSequence)tocOptions.title)).tag((CharSequence)("/h" + tocOptions.titleLevel))).line();
        }
        int initLevel = -1;
        int lastLevel = -1;
        String listOpen = tocOptions.isNumbered ? "ol" : "ul";
        String listClose = "/" + listOpen;
        boolean listNesting = false;
        boolean[] openedItems = new boolean[7];
        boolean[] openedList = new boolean[7];
        int[] openedItemAppendCount = new int[7];
        for (i = 0; i < headings.size(); ++i) {
            int headerLevel;
            Heading header = headings.get(i);
            String headerText = headingTexts.get(i);
            int n = headerLevel = tocOptions.listType != TocOptions.ListType.HIERARCHY ? 1 : header.getLevel();
            if (initLevel == -1) {
                initLevel = headerLevel;
                lastLevel = headerLevel;
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)tocOptions.listClass)).withAttr(TOC_LIST).line()).tag((CharSequence)listOpen)).indent()).line();
                openedList[0] = true;
            }
            if (lastLevel < headerLevel) {
                for (int lv = lastLevel; lv < headerLevel; ++lv) {
                    openedItems[lv + 1] = false;
                    openedList[lv + 1] = false;
                }
                if (!openedList[lastLevel]) {
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.withAttr().indent()).line()).tag((CharSequence)listOpen)).indent();
                    openedList[lastLevel] = true;
                }
            } else if (lastLevel == headerLevel) {
                if (openedItems[lastLevel]) {
                    if (openedList[lastLevel]) {
                        ((HtmlWriter)((HtmlWriter)html.unIndent()).tag((CharSequence)listClose)).line();
                    }
                    ((HtmlWriter)((HtmlWriter)html.lineIf(openedItemAppendCount[lastLevel] != html.offsetWithPending())).tag((CharSequence)"/li")).line();
                }
                openedItems[lastLevel] = false;
                openedList[lastLevel] = false;
            } else {
                for (int lv = lastLevel; lv >= headerLevel; --lv) {
                    if (openedItems[lv]) {
                        if (openedList[lv]) {
                            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.unIndent()).tag((CharSequence)listClose)).unIndent()).line();
                        }
                        ((HtmlWriter)((HtmlWriter)html.lineIf(openedItemAppendCount[lastLevel] != html.offsetWithPending())).tag((CharSequence)"/li")).line();
                    }
                    openedItems[lv] = false;
                    openedList[lv] = false;
                }
            }
            ((HtmlWriter)html.line()).tag((CharSequence)"li");
            openedItems[headerLevel] = true;
            String headerId = header.getAnchorRefId();
            if (headerId == null || headerId.isEmpty()) {
                html.raw((CharSequence)headerText);
            } else {
                ((HtmlWriter)html.attr((CharSequence)"href", (CharSequence)("#" + headerId))).withAttr().tag((CharSequence)"a");
                html.raw((CharSequence)headerText);
                html.tag((CharSequence)"/a");
            }
            lastLevel = headerLevel;
            openedItemAppendCount[headerLevel] = html.offsetWithPending();
        }
        for (i = lastLevel; i >= 1; --i) {
            if (!openedItems[i]) continue;
            if (openedList[i]) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.unIndent()).tag((CharSequence)listClose)).unIndent()).line();
            }
            ((HtmlWriter)((HtmlWriter)html.lineIf(openedItemAppendCount[lastLevel] != html.offsetWithPending())).tag((CharSequence)"/li")).line();
        }
        if (openedList[0]) {
            ((HtmlWriter)((HtmlWriter)html.unIndent()).tag((CharSequence)listClose)).line();
        }
        if (headings.size() > 0 && (sourceText.isNotNull() || !tocOptions.title.isEmpty())) {
            ((HtmlWriter)((HtmlWriter)html.line()).unIndent()).tag((CharSequence)"/div");
        }
        html.line();
    }

    public static List<Heading> filteredHeadings(List<Heading> headings, TocOptions tocOptions) {
        ArrayList<Heading> filteredHeadings = new ArrayList<Heading>(headings.size());
        for (Heading header : headings) {
            if (!tocOptions.isLevelIncluded(header.getLevel()) || header.getParent() instanceof SimTocContent) continue;
            filteredHeadings.add(header);
        }
        return filteredHeadings;
    }

    public static Paired<List<Heading>, List<String>> htmlHeadingTexts(NodeRendererContext context, List<Heading> headings, TocOptions tocOptions) {
        ArrayList<String> headingContents = new ArrayList<String>(headings.size());
        final boolean isReversed = tocOptions.listType == TocOptions.ListType.SORTED_REVERSED || tocOptions.listType == TocOptions.ListType.FLAT_REVERSED;
        boolean isSorted = tocOptions.listType == TocOptions.ListType.SORTED || tocOptions.listType == TocOptions.ListType.SORTED_REVERSED;
        boolean needText = isReversed || isSorted;
        HashMap<String, Heading> headingNodes = !needText ? null : new HashMap<String, Heading>(headings.size());
        final HashMap<String, String> headingTexts = !needText || tocOptions.isTextOnly ? null : new HashMap<String, String>(headings.size());
        for (Heading heading : headings) {
            String headingContent;
            if (tocOptions.isTextOnly) {
                headingContent = TocUtils.getHeadingText(heading).toString();
            } else {
                headingContent = TocUtils.getHeadingContent(context, heading);
                if (needText) {
                    headingTexts.put(headingContent, TocUtils.getHeadingText(heading).toString());
                }
            }
            if (needText) {
                headingNodes.put(headingContent, heading);
            }
            headingContents.add(headingContent);
        }
        if (isSorted || isReversed) {
            if (tocOptions.isTextOnly) {
                if (isSorted) {
                    Collections.sort(headingContents, new Comparator<String>(){

                        @Override
                        public int compare(String heading1, String heading2) {
                            return isReversed ? heading2.compareTo(heading1) : heading1.compareTo(heading2);
                        }
                    });
                } else {
                    Collections.reverse(headingContents);
                }
            } else if (isSorted) {
                Collections.sort(headingContents, new Comparator<String>(){

                    @Override
                    public int compare(String heading1, String heading2) {
                        String headingText1 = (String)headingTexts.get(heading1);
                        String headingText2 = (String)headingTexts.get(heading2);
                        return isReversed ? headingText2.compareTo(headingText1) : headingText1.compareTo(headingText2);
                    }
                });
            } else {
                Collections.reverse(headingContents);
            }
            headings = new ArrayList<Heading>();
            for (String headingContent : headingContents) {
                headings.add((Heading)headingNodes.get(headingContent));
            }
        }
        return Pair.of(headings, headingContents);
    }

    private static String getHeadingText(Heading header) {
        return Escaping.escapeHtml((CharSequence)new TextCollectingVisitor(new Class[0]).collectAndGetText((Node)header), (boolean)false);
    }

    private static String getHeadingContent(NodeRendererContext context, Heading header) {
        NodeRendererContext subContext = context.getSubContext(false);
        subContext.doNotRenderLinks();
        subContext.renderChildren((Node)header);
        return subContext.getHtmlWriter().toString(-1);
    }

    public static List<String> markdownHeaderTexts(List<Heading> headings, TocOptions tocOptions) {
        ArrayList<String> headingTexts = new ArrayList<String>(headings.size());
        for (Heading header : headings) {
            String headerText = tocOptions.isTextOnly ? new TextCollectingVisitor(new Class[0]).collectAndGetText((Node)header) : header.getChars().toString();
            String headerId = header.getAnchorRefId();
            String headerLink = headerId == null || headerText.isEmpty() ? headerText : "[" + headerText + "](#" + headerId + ")";
            headingTexts.add(headerLink);
        }
        return headingTexts;
    }

    public static void renderMarkdownToc(HtmlWriter html, List<Heading> headings, List<String> headingTexts, TocOptions tocOptions) {
        int initLevel = -1;
        int lastLevel = -1;
        int[] headingNumbers = new int[7];
        boolean[] openedItems = new boolean[7];
        Function<Integer, String> listOpen = level -> {
            openedItems[level.intValue()] = true;
            if (tocOptions.isNumbered) {
                int n = level;
                int n2 = headingNumbers[n] + 1;
                headingNumbers[n] = n2;
                int v = n2;
                return v + ". ";
            }
            return "- ";
        };
        Consumer<Integer> listClose = level -> {
            if (tocOptions.isNumbered) {
                headingNumbers[level.intValue()] = 0;
            }
        };
        if (headings.size() > 0 && !tocOptions.title.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"######".substring(0, tocOptions.titleLevel))).raw((CharSequence)" ")).raw((CharSequence)tocOptions.title)).line();
        }
        for (int i = 0; i < headings.size(); ++i) {
            int lv;
            int headerLevel;
            Heading header = headings.get(i);
            String headerText = headingTexts.get(i);
            int n = headerLevel = tocOptions.listType != TocOptions.ListType.HIERARCHY ? 1 : header.getLevel();
            if (initLevel == -1) {
                initLevel = headerLevel;
                lastLevel = headerLevel;
            }
            if (lastLevel < headerLevel) {
                for (lv = lastLevel; lv <= headerLevel - 1; ++lv) {
                    openedItems[lv + 1] = false;
                }
                html.indent();
            } else if (lastLevel == headerLevel) {
                if (i != 0) {
                    html.line();
                }
            } else {
                for (lv = lastLevel; lv >= headerLevel + 1; --lv) {
                    if (!openedItems[lv]) continue;
                    html.unIndent();
                    listClose.accept(lv);
                }
                html.line();
            }
            ((HtmlWriter)html.line()).raw((CharSequence)listOpen.apply(headerLevel));
            html.raw((CharSequence)headerText);
            lastLevel = headerLevel;
        }
        html.line();
    }
}

