/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DelimitedBuilder;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class TocOptions {
    public static final TocOptions DEFAULT = new TocOptions();
    public static final int DEFAULT_LEVELS = 12;
    public static final String DEFAULT_TITLE = "Table of Contents";
    public static final int DEFAULT_TITLE_LEVEL = 1;
    public static final int VALID_LEVELS = 126;
    public final int levels;
    public final boolean isHtml;
    public final boolean isTextOnly;
    public final boolean isNumbered;
    public final int titleLevel;
    public final String title;
    public final int rawTitleLevel;
    public final String rawTitle;

    public TocOptions() {
        this(12, false, false, false, 1, DEFAULT_TITLE);
    }

    public TocOptions(DataHolder options) {
        this((Integer)options.get(SimTocExtension.LEVELS), (Boolean)options.get(SimTocExtension.IS_HTML), (Boolean)options.get(SimTocExtension.IS_TEXT_ONLY), (Boolean)options.get(SimTocExtension.IS_NUMBERED), (Integer)options.get(SimTocExtension.TITLE_LEVEL), (String)options.get(SimTocExtension.TITLE));
    }

    public TocOptions(int levels, boolean isHtml, boolean isTextOnly, boolean isNumbered, int titleLevel, String title) {
        this.levels = levels & 0x7E;
        this.isHtml = isHtml;
        this.isTextOnly = isTextOnly;
        this.isNumbered = isNumbered;
        this.rawTitle = title == null ? "" : title;
        this.rawTitleLevel = titleLevel;
        if (!this.rawTitle.isEmpty()) {
            int markers = new SubSequence((CharSequence)this.rawTitle.trim()).countLeading("#");
            if (markers >= 1 && markers <= 6) {
                titleLevel = markers;
            }
            this.title = this.rawTitle.substring(markers).trim();
        } else {
            this.title = "";
        }
        this.titleLevel = titleLevel <= 1 ? 1 : (titleLevel >= 6 ? 6 : titleLevel);
    }

    public boolean isLevelIncluded(int level) {
        return level >= 1 && level <= 6 && (this.levels & 1 << level) != 0;
    }

    public TocOptions withLevels(int levels) {
        return new TocOptions(levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title);
    }

    public TocOptions withIsHtml(boolean isHtml) {
        return new TocOptions(this.levels, isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title);
    }

    public TocOptions withIsTextOnly(boolean isTextOnly) {
        return new TocOptions(this.levels, this.isHtml, isTextOnly, this.isNumbered, this.titleLevel, this.title);
    }

    public TocOptions withIsNumbered(boolean isNumbered) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, isNumbered, this.titleLevel, this.title);
    }

    public TocOptions withTitleLevel(int titleLevel) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, titleLevel, this.title);
    }

    public TocOptions withTitle(String title) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, title);
    }

    public TocOptions withRawTitleLevel(int titleLevel) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, titleLevel, this.title);
    }

    public TocOptions withRawTitle(String title) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, title);
    }

    public TocOptions withLevelList(int ... levelList) {
        int levels = TocOptions.getLevels(levelList);
        return new TocOptions(levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title);
    }

    public static int getLevels(int ... levelList) {
        int levels = 0;
        for (int level : levelList) {
            if (level < 1 || level > 6) {
                throw new IllegalArgumentException("TocOption level out of range [1, 6]");
            }
            levels |= 1 << level;
        }
        return levels;
    }

    public String getTitleHeading() {
        String title = this.title;
        if (!title.isEmpty()) {
            StringBuilder out = new StringBuilder();
            int level = this.titleLevel;
            while (level-- > 0) {
                out.append('#');
            }
            out.append(' ');
            out.append(title);
            return out.toString();
        }
        return "";
    }

    public String toString() {
        DelimitedBuilder out = new DelimitedBuilder(", ");
        out.append("TocOptions[");
        out.append("levels=<").push(",");
        for (int i = 1; i <= 6; ++i) {
            if (!this.isLevelIncluded(i)) continue;
            out.append(i).mark();
        }
        out.pop().unmark().append('>').mark();
        out.append(" isHtml=").append(this.isHtml).mark();
        out.append(" isTextOnly=").append(this.isTextOnly).mark();
        out.append(" isNumbered=").append(this.isNumbered).mark();
        out.append(" title=").append('\"').append(this.title).append('\"').mark();
        out.append(" titleLevel=").append(this.titleLevel).mark();
        out.append(" rawTitleLevel=").append(this.rawTitleLevel).mark();
        out.append(" rawTitle=").append('\"').append(this.rawTitle).append('\"').mark();
        out.append("]");
        return out.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TocOptions)) {
            return false;
        }
        TocOptions options = (TocOptions)o;
        if (this.levels != options.levels) {
            return false;
        }
        if (this.isHtml != options.isHtml) {
            return false;
        }
        if (this.isTextOnly != options.isTextOnly) {
            return false;
        }
        if (this.isNumbered != options.isNumbered) {
            return false;
        }
        if (this.titleLevel != options.titleLevel) {
            return false;
        }
        if (this.rawTitleLevel != options.rawTitleLevel) {
            return false;
        }
        if (!this.title.equals(options.title)) {
            return false;
        }
        return this.rawTitle.equals(options.rawTitle);
    }

    public int hashCode() {
        int result = this.levels;
        result = 31 * result + (this.isHtml ? 1 : 0);
        result = 31 * result + (this.isTextOnly ? 1 : 0);
        result = 31 * result + (this.isNumbered ? 1 : 0);
        result = 31 * result + this.titleLevel;
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.rawTitleLevel;
        result = 31 * result + this.rawTitle.hashCode();
        return result;
    }
}

