/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.util.Immutable;
import com.vladsch.flexmark.util.Mutable;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class TocOptions
implements Immutable<TocOptions, AsMutable>,
MutableDataSetter {
    public static final TocOptions DEFAULT = new TocOptions();
    public static final int DEFAULT_LEVELS = 12;
    public static final String DEFAULT_TITLE = "Table of Contents";
    public static final int DEFAULT_TITLE_LEVEL = 1;
    public static final int VALID_LEVELS = 126;
    public static final ListType LIST_TYPE = ListType.HIERARCHY;
    public final int levels;
    public final boolean isTextOnly;
    public final boolean isNumbered;
    public final ListType listType;
    public final boolean isHtml;
    public final int titleLevel;
    public final String title;
    public final int rawTitleLevel;
    public final String rawTitle;
    public final boolean isAstAddOptions;
    public final boolean isBlankLineSpacer;

    public AsMutable toMutable() {
        return new AsMutable(this);
    }

    public TocOptions() {
        this(12, false, false, false, 1, DEFAULT_TITLE, ListType.HIERARCHY, false, true);
    }

    public TocOptions(int levels, boolean isHtml, boolean isTextOnly, boolean isNumbered, ListType listType) {
        this(12, false, false, false, 1, DEFAULT_TITLE, listType, false, true);
    }

    public TocOptions(int levels, boolean isHtml, boolean isTextOnly, boolean isNumbered, int titleLevel, String title, ListType listType) {
        this(levels, isHtml, isTextOnly, isNumbered, titleLevel, title, listType, false, true);
    }

    public TocOptions(AsMutable other) {
        this.levels = other.levels;
        this.isTextOnly = other.isTextOnly;
        this.isNumbered = other.isNumbered;
        this.listType = other.listType;
        this.isHtml = other.isHtml;
        this.titleLevel = other.titleLevel;
        this.title = other.title;
        this.rawTitleLevel = other.rawTitleLevel;
        this.rawTitle = other.rawTitle;
        this.isAstAddOptions = other.isAstAddOptions;
        this.isBlankLineSpacer = other.isBlankLineSpacer;
    }

    public TocOptions(TocOptions other) {
        this.levels = other.levels;
        this.isTextOnly = other.isTextOnly;
        this.isNumbered = other.isNumbered;
        this.listType = other.listType;
        this.isHtml = other.isHtml;
        this.titleLevel = other.titleLevel;
        this.title = other.title;
        this.rawTitleLevel = other.rawTitleLevel;
        this.rawTitle = other.rawTitle;
        this.isAstAddOptions = other.isAstAddOptions;
        this.isBlankLineSpacer = other.isBlankLineSpacer;
    }

    public TocOptions(DataHolder options) {
        this((Integer)TocExtension.LEVELS.getFrom(options), (Boolean)SimTocExtension.IS_HTML.getFrom(options), (Boolean)TocExtension.IS_TEXT_ONLY.getFrom(options), (Boolean)TocExtension.IS_NUMBERED.getFrom(options), (Integer)SimTocExtension.TITLE_LEVEL.getFrom(options), (CharSequence)SimTocExtension.TITLE.getFrom(options), (ListType)((Object)TocExtension.LIST_TYPE.getFrom(options)), (Boolean)SimTocExtension.AST_INCLUDE_OPTIONS.getFrom(options), (Boolean)SimTocExtension.BLANK_LINE_SPACER.getFrom(options));
    }

    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(TocExtension.LEVELS, (Object)this.levels);
        dataHolder.set(TocExtension.IS_TEXT_ONLY, (Object)this.isTextOnly);
        dataHolder.set(TocExtension.IS_NUMBERED, (Object)this.isNumbered);
        dataHolder.set(TocExtension.LIST_TYPE, (Object)this.listType);
        dataHolder.set(SimTocExtension.IS_HTML, (Object)this.isHtml);
        dataHolder.set(SimTocExtension.TITLE_LEVEL, (Object)this.titleLevel);
        dataHolder.set(SimTocExtension.TITLE, (Object)this.title);
        dataHolder.set(SimTocExtension.AST_INCLUDE_OPTIONS, (Object)this.isAstAddOptions);
        dataHolder.set(SimTocExtension.BLANK_LINE_SPACER, (Object)this.isBlankLineSpacer);
        return dataHolder;
    }

    public TocOptions(int levels, boolean isHtml, boolean isTextOnly, boolean isNumbered, int titleLevel, CharSequence title, ListType listType, boolean isAstAddOptions, boolean isBlankLineSpacer) {
        this.levels = 0x7E & levels;
        this.isTextOnly = isTextOnly;
        this.isNumbered = isNumbered;
        this.listType = listType;
        this.isHtml = isHtml;
        this.rawTitle = title == null ? "" : (title instanceof String ? (String)title : String.valueOf(title));
        this.rawTitleLevel = titleLevel;
        if (!this.rawTitle.isEmpty()) {
            int markers = SubSequence.of((CharSequence)this.rawTitle.trim()).countLeading((CharSequence)"#");
            if (markers >= 1 && markers <= 6) {
                titleLevel = markers;
            }
            this.title = this.rawTitle.substring(markers).trim();
        } else {
            this.title = "";
        }
        this.titleLevel = titleLevel <= 1 ? 1 : (titleLevel >= 6 ? 6 : titleLevel);
        this.isAstAddOptions = isAstAddOptions;
        this.isBlankLineSpacer = isBlankLineSpacer;
    }

    public boolean isLevelIncluded(int level) {
        return level >= 1 && level <= 6 && (this.levels & 1 << level) != 0;
    }

    public TocOptions withLevels(int levels) {
        return new TocOptions(levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withIsHtml(boolean isHtml) {
        return new TocOptions(this.levels, isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withIsTextOnly(boolean isTextOnly) {
        return new TocOptions(this.levels, this.isHtml, isTextOnly, this.isNumbered, this.titleLevel, this.title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withIsNumbered(boolean isNumbered) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, isNumbered, this.titleLevel, this.title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withTitleLevel(int titleLevel) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, titleLevel, this.title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withTitle(CharSequence title) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withListType(ListType listType) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withIsAstAddOptions(boolean isAstAddOptions) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.listType, isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withIsBlankLineSpacer(boolean isBlankLineSpacer) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, this.title, this.listType, this.isAstAddOptions, isBlankLineSpacer);
    }

    public TocOptions withRawTitleLevel(int titleLevel) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, titleLevel, this.title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withRawTitle(CharSequence title) {
        return new TocOptions(this.levels, this.isHtml, this.isTextOnly, this.isNumbered, this.titleLevel, title, this.listType, this.isAstAddOptions, this.isBlankLineSpacer);
    }

    public TocOptions withLevelList(int ... levelList) {
        int levels = TocOptions.getLevels(levelList);
        return this.withLevels(levels);
    }

    public static int getLevels(int ... levelList) {
        int levels = 0;
        for (int level : levelList) {
            if (level < 1 || level > 6) {
                throw new IllegalArgumentException("TocOption level out of range [1, 6]");
            }
            levels |= 1 << level;
        }
        return levels;
    }

    public String getTitleHeading() {
        String title = this.title;
        if (!title.isEmpty()) {
            StringBuilder out = new StringBuilder();
            int level = this.titleLevel;
            while (level-- > 0) {
                out.append('#');
            }
            out.append(' ');
            out.append(title);
            return out.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        TocOptions options;
        if (this == o) {
            return true;
        }
        if (!(o instanceof TocOptions) && !(o instanceof AsMutable)) {
            return false;
        }
        TocOptions tocOptions = options = o instanceof TocOptions ? (TocOptions)o : ((AsMutable)o).toImmutable();
        if (this.levels != options.levels) {
            return false;
        }
        if (this.isTextOnly != options.isTextOnly) {
            return false;
        }
        if (this.isNumbered != options.isNumbered) {
            return false;
        }
        if (this.listType != options.listType) {
            return false;
        }
        if (this.isHtml != options.isHtml) {
            return false;
        }
        if (this.titleLevel != options.titleLevel) {
            return false;
        }
        if (!this.title.equals(options.title)) {
            return false;
        }
        if (this.rawTitleLevel != options.rawTitleLevel) {
            return false;
        }
        if (!this.rawTitle.equals(options.rawTitle)) {
            return false;
        }
        if (this.isAstAddOptions != options.isAstAddOptions) {
            return false;
        }
        return this.isBlankLineSpacer == options.isBlankLineSpacer;
    }

    public int hashCode() {
        int result = this.levels;
        result = 31 * result + (this.isTextOnly ? 1 : 0);
        result = 31 * result + (this.isNumbered ? 1 : 0);
        result = 31 * result + this.listType.hashCode();
        result = 31 * result + (this.isHtml ? 1 : 0);
        result = 31 * result + this.titleLevel;
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.rawTitleLevel;
        result = 31 * result + this.rawTitle.hashCode();
        result = 31 * result + (this.isAstAddOptions ? 1 : 0);
        result = 31 * result + (this.isBlankLineSpacer ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TocOptions { levels=" + this.levels + ", isHtml=" + this.isHtml + ", isTextOnly=" + this.isTextOnly + ", isNumbered=" + this.isNumbered + ", titleLevel=" + this.titleLevel + ", title='" + this.title + '\'' + ", rawTitleLevel=" + this.rawTitleLevel + ", listType=" + (Object)((Object)this.listType) + ", rawTitle='" + this.rawTitle + '\'' + " }";
    }

    public static class AsMutable
    implements Mutable<AsMutable, TocOptions>,
    MutableDataSetter {
        public int levels;
        public boolean isTextOnly;
        public boolean isNumbered;
        public ListType listType;
        public boolean isHtml;
        public int titleLevel;
        public String title;
        public int rawTitleLevel;
        public String rawTitle;
        public boolean isAstAddOptions;
        public boolean isBlankLineSpacer;

        protected AsMutable(TocOptions other) {
            this.levels = other.levels;
            this.isTextOnly = other.isTextOnly;
            this.isNumbered = other.isNumbered;
            this.listType = other.listType;
            this.isHtml = other.isHtml;
            this.titleLevel = other.titleLevel;
            this.title = other.title;
            this.rawTitleLevel = other.rawTitleLevel;
            this.rawTitle = other.rawTitle;
            this.isAstAddOptions = other.isAstAddOptions;
            this.isBlankLineSpacer = other.isBlankLineSpacer;
        }

        protected AsMutable(AsMutable other) {
            this.levels = other.levels;
            this.isTextOnly = other.isTextOnly;
            this.isNumbered = other.isNumbered;
            this.listType = other.listType;
            this.isHtml = other.isHtml;
            this.titleLevel = other.titleLevel;
            this.title = other.title;
            this.rawTitleLevel = other.rawTitleLevel;
            this.rawTitle = other.rawTitle;
            this.isAstAddOptions = other.isAstAddOptions;
            this.isBlankLineSpacer = other.isBlankLineSpacer;
        }

        public TocOptions toImmutable() {
            return new TocOptions(this);
        }

        public MutableDataHolder setIn(MutableDataHolder dataHolder) {
            return this.toImmutable().setIn(dataHolder);
        }

        public AsMutable setLevelList(int ... levelList) {
            int levels = 0;
            for (int level : levelList) {
                if (level < 1 || level > 6) {
                    throw new IllegalArgumentException("TocOption level out of range [1, 6]");
                }
                levels |= 1 << level;
            }
            this.levels = levels;
            return this;
        }

        public boolean equals(Object o) {
            AsMutable options;
            if (this == o) {
                return true;
            }
            if (!(o instanceof TocOptions) && !(o instanceof AsMutable)) {
                return false;
            }
            AsMutable asMutable = options = o instanceof AsMutable ? (AsMutable)o : ((TocOptions)o).toMutable();
            if (this.levels != options.levels) {
                return false;
            }
            if (this.isTextOnly != options.isTextOnly) {
                return false;
            }
            if (this.isNumbered != options.isNumbered) {
                return false;
            }
            if (this.listType != options.listType) {
                return false;
            }
            if (this.isHtml != options.isHtml) {
                return false;
            }
            if (this.titleLevel != options.titleLevel) {
                return false;
            }
            if (!this.title.equals(options.title)) {
                return false;
            }
            if (this.rawTitleLevel != options.rawTitleLevel) {
                return false;
            }
            if (!this.rawTitle.equals(options.rawTitle)) {
                return false;
            }
            if (this.isAstAddOptions != options.isAstAddOptions) {
                return false;
            }
            return this.isBlankLineSpacer == options.isBlankLineSpacer;
        }

        public int hashCode() {
            int result = this.levels;
            result = 31 * result + (this.isTextOnly ? 1 : 0);
            result = 31 * result + (this.isNumbered ? 1 : 0);
            result = 31 * result + this.listType.hashCode();
            result = 31 * result + (this.isHtml ? 1 : 0);
            result = 31 * result + this.titleLevel;
            result = 31 * result + this.title.hashCode();
            result = 31 * result + this.rawTitleLevel;
            result = 31 * result + this.rawTitle.hashCode();
            result = 31 * result + (this.isAstAddOptions ? 1 : 0);
            result = 31 * result + (this.isBlankLineSpacer ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TocOptions { levels=" + this.levels + ", isHtml=" + this.isHtml + ", isTextOnly=" + this.isTextOnly + ", isNumbered=" + this.isNumbered + ", titleLevel=" + this.titleLevel + ", title='" + this.title + '\'' + ", rawTitleLevel=" + this.rawTitleLevel + ", listType=" + (Object)((Object)this.listType) + ", rawTitle='" + this.rawTitle + '\'' + " }";
        }
    }

    public static enum ListType {
        HIERARCHY,
        FLAT,
        FLAT_REVERSED,
        SORTED,
        SORTED_REVERSED;

    }
}

