/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.spec.example.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.spec.example.SpecExampleBlock;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleOptions;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecExampleNodeFormatter
implements NodeFormatter {
    private final SpecExampleOptions formatOptions;
    private final String[] mySections = new String[7];
    private String mySection = "";
    private int myFlexMarkExampleCount = 0;

    public SpecExampleNodeFormatter(DataHolder options) {
        this.formatOptions = new SpecExampleOptions(options);
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeFormattingHandler(SpecExampleBlock.class, this::render));
        set.add(new NodeFormattingHandler(Heading.class, this::render));
        return set;
    }

    void render(Heading node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!context.isTransformingText() && node.isAtxHeading()) {
            Pair pair = TestUtils.addSpecSection((String)node.getChars().toString(), (String)node.getText().toString(), (String[])this.mySections);
            this.mySection = (String)pair.getFirst();
            this.myFlexMarkExampleCount = 0;
        }
        context.delegateRender();
    }

    void render(SpecExampleBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!context.isTransformingText()) {
            markdown.blankLine();
            BasedSequence optionsSet = node.getOptions();
            @NotNull List optionsList = optionsSet.splitList((CharSequence)",", 0, 14, CharPredicate.SPACE_TAB);
            SequenceBuilder builder = node.getChars().getBuilder();
            if (optionsList.isEmpty()) {
                optionsSet = BasedSequence.NULL;
            } else {
                for (BasedSequence option : optionsList) {
                    builder.append((CharSequence)option);
                    if (!option.equals(",")) continue;
                    builder.append(' ');
                }
                optionsSet = builder.toSequence();
            }
            MarkdownWriter out = new MarkdownWriter((Appendable)builder.getBuilder(), markdown.getOptions());
            ((MarkdownWriter)out.openPreFormatted(false)).removeOptions(LineAppendable.F_WHITESPACE_REMOVAL);
            String exampleNumber = Integer.toString(++this.myFlexMarkExampleCount);
            TestUtils.addSpecExample((CharSequence)(node.getOpeningMarker().equals(this.formatOptions.exampleBreak) ? node.getOpeningMarker() : this.formatOptions.exampleBreak), (CharSequence)(node.getHtmlSeparator().equals(this.formatOptions.sectionBreak + "\n") ? node.getHtmlSeparator() : this.formatOptions.sectionBreak), (CharSequence)(node.getAstSeparator().equals(this.formatOptions.sectionBreak + "\n") ? node.getAstSeparator() : this.formatOptions.sectionBreak), (CharSequence)(node.getClosingMarker().equals(this.formatOptions.exampleBreak) ? node.getClosingMarker() : this.formatOptions.exampleBreak), (boolean)true, (boolean)false, (Appendable)out, (CharSequence)node.getSource(), (CharSequence)node.getHtml(), (CharSequence)node.getAst(), (CharSequence)optionsSet, (boolean)true, (CharSequence)(node.getSection().equals(this.mySection) ? node.getSection() : ((SequenceBuilder)((SequenceBuilder)((SequenceBuilder)builder.getBuilder().append((CharSequence)node.getSection().getEmptyPrefix())).append((CharSequence)this.mySection)).append((CharSequence)node.getSection().getEmptySuffix())).toSequence()), (CharSequence)(node.getNumber().equals(exampleNumber) ? node.getNumber() : ((SequenceBuilder)((SequenceBuilder)((SequenceBuilder)builder.getBuilder().append((CharSequence)node.getNumber().getEmptyPrefix())).append((CharSequence)exampleNumber)).append((CharSequence)node.getNumber().getEmptySuffix())).toSequence()), (CharSequence)node.getExampleKeyword(), (CharSequence)(node.getOptionsKeyword().equals("options") ? node.getOptionsKeyword() : "options"));
            ((MarkdownWriter)out.line()).closePreFormatted();
            BasedSequence result = BasedSequence.of((CharSequence)out.toSequence(Integer.MAX_VALUE, Integer.MAX_VALUE));
            ((MarkdownWriter)((MarkdownWriter)markdown.pushOptions()).openPreFormatted(false)).removeOptions(LineAppendable.F_WHITESPACE_REMOVAL).append((CharSequence)result).line().closePreFormatted().blankLine(2).popOptions();
        } else {
            context.delegateRender();
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new SpecExampleNodeFormatter(options);
        }
    }
}

