/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.spec.example.internal;

import com.vladsch.flexmark.ext.spec.example.SpecExampleAst;
import com.vladsch.flexmark.ext.spec.example.SpecExampleBlock;
import com.vladsch.flexmark.ext.spec.example.SpecExampleHtml;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOption;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionsList;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSource;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleOptions;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecExampleBlockParser
extends AbstractBlockParser {
    private static final Pattern OPTIONS_PATTERN = Pattern.compile("^\\s*(\\()?([^:()]*)(?:(:)\\s*([^\\s()]+)\\s*?)?(\\))?(?:\\s+(options)\\s*(\\()?([^()\\n\\r]*)(\\))?)?\\s*$");
    private static final int GROUP_COORD_OPEN = 1;
    private static final int GROUP_SECTION = 2;
    private static final int GROUP_NUMBER_SEPARATOR = 3;
    private static final int GROUP_NUMBER = 4;
    private static final int GROUP_COORD_CLOSE = 5;
    private static final int GROUP_OPTION_KEYWORD = 6;
    private static final int GROUP_OPTIONS_OPEN = 7;
    private static final int GROUP_OPTIONS = 8;
    private static final int GROUP_OPTIONS_CLOSE = 9;
    final SpecExampleBlock block = new SpecExampleBlock();
    private BlockContent content = new BlockContent();
    private final SpecExampleOptions myOptions;

    public SpecExampleBlockParser(DataHolder options) {
        this.myOptions = new SpecExampleOptions(options);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        BasedSequence line = state.getLine();
        if (line.startsWith((CharSequence)this.myOptions.exampleBreak)) {
            this.block.setClosingMarker(line.subSequence(0, this.myOptions.exampleBreak.length()));
            return BlockContinue.finished();
        }
        return BlockContinue.atIndex((int)0);
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, 0);
    }

    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    public void closeBlock(ParserState state) {
        List lines = this.content.getLines();
        if (lines.size() > 0) {
            BasedSequence info = (BasedSequence)lines.get(0);
            int exampleKeyWordStart = this.myOptions.exampleBreak.length() + 1;
            int exampleKeyWordEnd = exampleKeyWordStart + "example".length();
            BasedSequence exampleKeyword = info.subSequence(exampleKeyWordStart, exampleKeyWordEnd);
            BasedSequence optionsChars = (BasedSequence)info.subSequence(exampleKeyWordEnd);
            Matcher options = OPTIONS_PATTERN.matcher(optionsChars.toString().replace('\u00a0', ' '));
            this.block.setOpeningMarker(info.subSequence(0, this.myOptions.exampleBreak.length()));
            this.block.setExampleKeyword(exampleKeyword);
            if (options.matches()) {
                BasedSequence coordOpeningMarker = BasedSequence.NULL;
                BasedSequence section = BasedSequence.NULL;
                BasedSequence numberSeparator = BasedSequence.NULL;
                BasedSequence number = BasedSequence.NULL;
                BasedSequence coordClosingMarker = BasedSequence.NULL;
                BasedSequence optionsKeyword = BasedSequence.NULL;
                BasedSequence optionsOpeningMarker = BasedSequence.NULL;
                BasedSequence optionsText = BasedSequence.NULL;
                BasedSequence optionsClosingMarker = BasedSequence.NULL;
                if (options.group(1) != null && !options.group(1).trim().isEmpty()) {
                    coordOpeningMarker = (BasedSequence)optionsChars.subSequence(options.start(1), options.end(1)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(2) != null && !options.group(2).trim().isEmpty()) {
                    section = (BasedSequence)optionsChars.subSequence(options.start(2), options.end(2)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(3) != null && !options.group(3).trim().isEmpty()) {
                    numberSeparator = (BasedSequence)optionsChars.subSequence(options.start(3), options.end(3)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(4) != null && !options.group(4).trim().isEmpty()) {
                    number = (BasedSequence)optionsChars.subSequence(options.start(4), options.end(4)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(5) != null && !options.group(5).trim().isEmpty()) {
                    coordClosingMarker = (BasedSequence)optionsChars.subSequence(options.start(5), options.end(5)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(6) != null && !options.group(6).trim().isEmpty()) {
                    optionsKeyword = (BasedSequence)optionsChars.subSequence(options.start(6), options.end(6)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(7) != null && !options.group(7).trim().isEmpty()) {
                    optionsOpeningMarker = (BasedSequence)optionsChars.subSequence(options.start(7), options.end(7)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (options.group(8) != null) {
                    optionsText = optionsChars.subSequence(options.start(8), options.end(8));
                }
                if (options.group(9) != null && !options.group(9).trim().isEmpty()) {
                    optionsClosingMarker = (BasedSequence)optionsChars.subSequence(options.start(9), options.end(9)).trim(CharPredicate.WHITESPACE_NBSP);
                }
                if (section.isNotNull() && optionsKeyword.isNull() && numberSeparator.isNull() && coordOpeningMarker.isNull() && section.matchChars((CharSequence)"options")) {
                    int pos = section.indexOfAny(CharPredicate.SPACE_TAB_NBSP);
                    if (pos < 0) {
                        optionsKeyword = section;
                    } else {
                        optionsKeyword = section.subSequence(0, pos);
                        optionsText = (BasedSequence)section.subSequence(pos + 1);
                    }
                    optionsClosingMarker = coordClosingMarker;
                    section = BasedSequence.NULL;
                    coordClosingMarker = BasedSequence.NULL;
                }
                if (optionsText.isNull()) {
                    if (optionsClosingMarker.isNotNull()) {
                        optionsText = optionsClosingMarker.subSequence(0, 0);
                    } else if (optionsOpeningMarker.isNotNull()) {
                        optionsText = optionsOpeningMarker.subSequence(1, 1);
                    } else if (optionsKeyword.isNotNull()) {
                        optionsText = optionsKeyword.subSequence(optionsKeyword.length(), optionsKeyword.length());
                    }
                }
                this.block.setCoordOpeningMarker(coordOpeningMarker);
                this.block.setSection(section);
                this.block.setNumberSeparator(numberSeparator);
                this.block.setNumber(number);
                this.block.setCoordClosingMarker(coordClosingMarker);
                this.block.setOptionsKeyword(optionsKeyword);
                this.block.setOptionsOpeningMarker(optionsOpeningMarker);
                this.block.setOptions(optionsText);
                this.block.setOptionsClosingMarker(optionsClosingMarker);
            }
            if (this.myOptions.optionNodes && this.block.getOptionsKeyword().isNotNull()) {
                SpecExampleOptionsList optionsList = new SpecExampleOptionsList(this.block.getOptions());
                this.block.appendChild(optionsList);
                BasedSequence trimmedOptionsList = (BasedSequence)this.block.getOptions().trim(CharPredicate.WHITESPACE_NBSP);
                if (!trimmedOptionsList.isEmpty()) {
                    BasedSequence list;
                    for (BasedSequence item : list = (BasedSequence)trimmedOptionsList.split((CharSequence)",", 0, 8)) {
                        Object optionNode;
                        BasedSequence option = (BasedSequence)item.trim(CharPredicate.WHITESPACE_NBSP);
                        if (option.isEmpty()) continue;
                        if (option.matches((CharSequence)",")) {
                            optionNode = new SpecExampleOptionSeparator(option);
                            optionsList.appendChild((Node)optionNode);
                            continue;
                        }
                        optionNode = new SpecExampleOption(option);
                        optionsList.appendChild((Node)optionNode);
                    }
                }
            }
            BasedSequence chars = this.content.getSpanningChars();
            BasedSequence spanningChars = chars.baseSubSequence(chars.getStartOffset(), ((BasedSequence)lines.get(0)).getEndOffset());
            if (lines.size() > 1) {
                Node node;
                this.block.setContent(spanningChars, lines.subList(1, lines.size()));
                boolean inSource = true;
                boolean inHtml = false;
                int sectionStart = -1;
                BasedSequence lastLine = (BasedSequence)lines.get(lines.size() - 1);
                String typeBreak = this.myOptions.sectionBreak;
                int typeBreakLength = typeBreak.length();
                for (BasedSequence line : lines.subList(1, lines.size())) {
                    if (line.length() == typeBreakLength + line.countTrailing(CharPredicate.ANY_EOL) && line.matchChars((CharSequence)typeBreak)) {
                        if (inSource) {
                            inSource = false;
                            if (sectionStart != -1) {
                                this.block.setSource(line.baseSubSequence(sectionStart, line.getStartOffset()));
                            } else {
                                this.block.setSource(line.subSequence(0, 0));
                            }
                            this.block.setHtmlSeparator(line);
                            inHtml = true;
                            sectionStart = -1;
                        } else if (inHtml) {
                            inHtml = false;
                            if (sectionStart != -1) {
                                this.block.setHtml(line.baseSubSequence(sectionStart, line.getStartOffset()));
                            } else {
                                this.block.setHtml(line.subSequence(0, 0));
                            }
                            this.block.setAstSeparator(line);
                            sectionStart = -1;
                        } else if (sectionStart == -1) {
                            sectionStart = line.getStartOffset();
                        }
                    } else if (sectionStart == -1) {
                        sectionStart = line.getStartOffset();
                    }
                    if (line != lastLine) continue;
                    if (inSource) {
                        if (sectionStart != -1) {
                            this.block.setSource(line.baseSubSequence(sectionStart, line.getEndOffset()));
                            break;
                        }
                        this.block.setSource(line.subSequence(line.length(), line.length()));
                        break;
                    }
                    if (inHtml) {
                        if (sectionStart != -1) {
                            this.block.setHtml(line.baseSubSequence(sectionStart, line.getEndOffset()));
                            break;
                        }
                        this.block.setHtml(line.subSequence(line.length(), line.length()));
                        break;
                    }
                    if (sectionStart != -1) {
                        this.block.setAst(line.baseSubSequence(sectionStart, line.getEndOffset()));
                        break;
                    }
                    this.block.setAst(line.subSequence(line.length(), line.length()));
                    break;
                }
                if (this.block.getSource().isNotNull()) {
                    node = new SpecExampleSource(this.block.getSource());
                    this.block.appendChild(node);
                }
                if (this.block.getHtmlSeparator().isNotNull()) {
                    node = new SpecExampleSeparator(this.block.getHtmlSeparator());
                    this.block.appendChild(node);
                    if (this.block.getHtml().isNotNull()) {
                        node = new SpecExampleHtml(this.block.getHtml());
                        this.block.appendChild(node);
                    }
                    if (this.block.getAstSeparator().isNotNull()) {
                        node = new SpecExampleSeparator(this.block.getAstSeparator());
                        this.block.appendChild(node);
                        if (this.block.getAst().isNotNull()) {
                            node = new SpecExampleAst(this.block.getAst());
                            this.block.appendChild(node);
                        }
                    }
                }
            } else {
                SpecExampleSource node = new SpecExampleSource(this.block.getClosingMarker().subSequence(0, 0));
                this.block.appendChild(node);
                this.block.setContent(spanningChars, BasedSequence.EMPTY_LIST);
            }
        } else {
            SpecExampleSource node = new SpecExampleSource(this.block.getClosingMarker().subSequence(0, 0));
            this.block.appendChild(node);
            this.block.setContent(this.content);
        }
        this.block.setCharsFromContent();
        this.content = null;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final SpecExampleOptions myOptions;

        BlockFactory(DataHolder options) {
            super(options);
            this.myOptions = new SpecExampleOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line = state.getLine();
            if (state.getIndex() == 0) {
                int breakLength = this.myOptions.exampleBreak.length();
                if (line.length() >= breakLength + 1 + "example".length() && line.startsWith((CharSequence)this.myOptions.exampleBreak) && line.matchChars((CharSequence)"example", breakLength + 1) && " \t\u00a0".contains(String.valueOf(line.charAt(breakLength)))) {
                    SpecExampleBlockParser blockParser = new SpecExampleBlockParser((DataHolder)state.getProperties());
                    blockParser.block.setOpeningMarker(line.subSequence(0, breakLength));
                    return BlockStart.of((BlockParser[])new BlockParser[]{blockParser}).atIndex(-1);
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return new HashSet(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class));
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return new HashSet(Arrays.asList(FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

