/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.util.ast.DoNotCollectText;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequenceBuilder;

public class EnumRefTextCollectingVisitor {
    private SegmentedSequenceBuilder out;
    private final NodeVisitor visitor;
    private Runnable ordinalRunnable;

    public EnumRefTextCollectingVisitor() {
        this(-1);
    }

    public EnumRefTextCollectingVisitor(final int ordinal) {
        this.ordinalRunnable = ordinal < 0 ? null : new Runnable(){

            @Override
            public void run() {
                EnumRefTextCollectingVisitor.this.out.append(String.valueOf(ordinal));
            }
        };
        this.visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, (Visitor)new Visitor<Text>(){

            public void visit(Text node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        }), new VisitHandler(TextBase.class, (Visitor)new Visitor<TextBase>(){

            public void visit(TextBase node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        }), new VisitHandler(HtmlEntity.class, (Visitor)new Visitor<HtmlEntity>(){

            public void visit(HtmlEntity node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        }), new VisitHandler(SoftLineBreak.class, (Visitor)new Visitor<SoftLineBreak>(){

            public void visit(SoftLineBreak node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        }), new VisitHandler(HardLineBreak.class, (Visitor)new Visitor<HardLineBreak>(){

            public void visit(HardLineBreak node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        }), new VisitHandler(EnumeratedReferenceText.class, (Visitor)new Visitor<EnumeratedReferenceText>(){

            public void visit(EnumeratedReferenceText node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        }), new VisitHandler(EnumeratedReferenceLink.class, (Visitor)new Visitor<EnumeratedReferenceLink>(){

            public void visit(EnumeratedReferenceLink node) {
                EnumRefTextCollectingVisitor.this.visit(node);
            }
        })});
    }

    public String getText() {
        return this.out.toString();
    }

    @Deprecated
    public void collect(Node node) {
        this.out = new SegmentedSequenceBuilder(node.getChars());
        this.visitor.visit(node);
    }

    @Deprecated
    public String collectAndGetText(Node node) {
        this.collect(node);
        return this.out.toString();
    }

    @Deprecated
    public BasedSequence[] collectAndGetSegments(Node node) {
        this.collect(node);
        return this.out.toSegments();
    }

    @Deprecated
    public BasedSequence collectAndGetSequence(Node node) {
        this.collect(node);
        return this.out.toBasedSequence();
    }

    public void collect(BasedSequence basedSequence, EnumeratedReferenceRendering[] renderings, String defaultFormat) {
        this.out = new SegmentedSequenceBuilder(basedSequence);
        EnumeratedReferences.renderReferenceOrdinals(renderings, new OrdinalRenderer(this));
    }

    public String collectAndGetText(BasedSequence basedSequence, EnumeratedReferenceRendering[] renderings, String defaultFormat) {
        this.collect(basedSequence, renderings, defaultFormat);
        return this.out.toString();
    }

    public BasedSequence[] collectAndGetSegments(BasedSequence basedSequence, EnumeratedReferenceRendering[] renderings, String defaultFormat) {
        this.collect(basedSequence, renderings, defaultFormat);
        return this.out.toSegments();
    }

    public BasedSequence collectAndGetSequence(BasedSequence basedSequence, EnumeratedReferenceRendering[] renderings, String defaultFormat) {
        this.collect(basedSequence, renderings, defaultFormat);
        return this.out.toBasedSequence();
    }

    private void visit(EnumeratedReferenceText node) {
        String text = node.getText().toString();
        if (text.isEmpty() && this.ordinalRunnable != null) {
            this.ordinalRunnable.run();
        }
    }

    private void visit(EnumeratedReferenceLink node) {
        String text = node.getText().toString();
        if (text.isEmpty() && this.ordinalRunnable != null) {
            this.ordinalRunnable.run();
        }
    }

    private void visit(SoftLineBreak node) {
        this.out.append(node.getChars());
    }

    private void visit(HardLineBreak node) {
        BasedSequence chars = node.getChars();
        this.out.append((BasedSequence)chars.subSequence(chars.length() - 1, chars.length()));
    }

    private void visit(HtmlEntity node) {
        this.out.append(node.getChars().unescape());
    }

    private void visit(Text node) {
        if (!node.isOrDescendantOfType(new Class[]{DoNotCollectText.class})) {
            this.out.append(node.getChars());
        }
    }

    private void visit(TextBase node) {
        this.out.append(node.getChars());
    }

    private static class OrdinalRenderer
    implements EnumeratedOrdinalRenderer {
        final EnumRefTextCollectingVisitor renderer;

        public OrdinalRenderer(EnumRefTextCollectingVisitor renderer) {
            this.renderer = renderer;
        }

        @Override
        public void startRendering(EnumeratedReferenceRendering[] renderings) {
        }

        @Override
        public void setEnumOrdinalRunnable(Runnable runnable) {
            this.renderer.ordinalRunnable = runnable;
        }

        @Override
        public Runnable getEnumOrdinalRunnable() {
            return this.renderer.ordinalRunnable;
        }

        @Override
        public void render(final int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, final boolean needSeparator) {
            final Runnable compoundRunnable = this.renderer.ordinalRunnable;
            if (referenceFormat != null) {
                this.renderer.ordinalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (compoundRunnable != null) {
                            compoundRunnable.run();
                        }
                        renderer.out.append(String.valueOf(referenceOrdinal));
                        if (needSeparator) {
                            renderer.out.append(".");
                        }
                    }
                };
                this.renderer.visitor.visitChildren((Node)referenceFormat);
            } else {
                this.renderer.out.append(defaultText + " ");
                if (compoundRunnable != null) {
                    compoundRunnable.run();
                }
                this.renderer.out.append(String.valueOf(referenceOrdinal));
                if (needSeparator) {
                    this.renderer.out.append(".");
                }
            }
        }

        @Override
        public void endRendering() {
        }
    }
}

