/*
 * Decompiled with CFR 0.152.
 */
package com.vistrav.ask;

import android.app.Activity;
import android.app.Fragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.vistrav.ask.AskActivity;
import com.vistrav.ask.annotations.AskDenied;
import com.vistrav.ask.annotations.AskGranted;
import com.vistrav.ask.annotations.AskGrantedAll;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Ask {
    private String[] permissions;
    private String[] rationalMessages;
    private static final String TAG = Ask.class.getSimpleName();
    private static final String ALL_PERMISSIONS = "All";
    private static Permission permissionObj;
    private static Fragment fragment;
    private static Activity activity;
    private static int id;
    private static Map<String, Method> permissionMethodMap;
    private static boolean debug;

    private Ask() {
        permissionMethodMap = new HashMap<String, Method>();
        debug = false;
        permissionObj = null;
        Random rand = new Random();
        id = rand.nextInt();
    }

    public static Ask on(Activity lActivity) {
        if (lActivity == null) {
            throw new IllegalArgumentException("Null Fragment Reference");
        }
        activity = lActivity;
        return new Ask();
    }

    public static Ask on(Fragment lFragment) {
        if (lFragment == null) {
            throw new IllegalArgumentException("Null Fragment Reference");
        }
        fragment = lFragment;
        activity = lFragment.getActivity();
        return new Ask();
    }

    public Ask forPermissions(String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("The permissions to request are missing");
        }
        this.permissions = permissions;
        return this;
    }

    public Ask withRationales(String ... rationalMessages) {
        if (rationalMessages == null || rationalMessages.length == 0) {
            throw new IllegalArgumentException("The Rationale Messages are missing");
        }
        this.rationalMessages = rationalMessages;
        return this;
    }

    public Ask debug(boolean lDebug) {
        debug = lDebug;
        return this;
    }

    public Ask id(int lId) {
        id = lId;
        return this;
    }

    public void go() {
        if (debug) {
            Log.d((String)TAG, (String)("request id :: " + id));
        }
        Ask.getAnnotatedMethod();
        if (Build.VERSION.SDK_INT < 23) {
            if (permissionObj != null) {
                permissionObj.granted(Arrays.asList(this.permissions));
                permissionObj.denied(new ArrayList<String>());
            }
            for (String permission : this.permissions) {
                Ask.invokeMethod(permission, true);
            }
        } else {
            Intent intent = new Intent((Context)activity, AskActivity.class);
            intent.putExtra("__permissions__", this.permissions);
            intent.putExtra("__rational_messages__", this.rationalMessages);
            intent.putExtra("__request_id__", id);
            activity.startActivity(intent);
        }
    }

    public Ask when(@Nullable Permission permission) {
        permissionObj = permission;
        return this;
    }

    private static void getAnnotatedMethod() {
        Method[] methods;
        permissionMethodMap.clear();
        for (Method method : methods = fragment != null ? fragment.getClass().getMethods() : activity.getClass().getMethods()) {
            int lId;
            AskDenied askDenied = method.getAnnotation(AskDenied.class);
            AskGranted askGranted = method.getAnnotation(AskGranted.class);
            AskGrantedAll askGrantedAll = method.getAnnotation(AskGrantedAll.class);
            if (askDenied != null) {
                lId = askDenied.id() != -1 ? askDenied.id() : id;
                permissionMethodMap.put("false_" + askDenied.value() + "_" + id, method);
            }
            if (askGranted != null) {
                lId = askGranted.id() != -1 ? askGranted.id() : id;
                permissionMethodMap.put("true_" + askGranted.value() + "_" + id, method);
            }
            if (askGrantedAll == null) continue;
            lId = askGrantedAll.id() != -1 ? askGrantedAll.id() : id;
            permissionMethodMap.put("true_" + askGrantedAll.value() + "_" + id, method);
        }
        if (debug) {
            Log.d((String)TAG, (String)("annotated methods map :: " + permissionMethodMap));
        }
    }

    private static void invokeMethod(String permission, boolean isGranted) {
        block6: {
            String key = isGranted + "_" + permission + "_" + id;
            String val = isGranted ? "Granted" : "Denied";
            try {
                if (debug) {
                    Log.d((String)TAG, (String)("invoke method for key :: " + key));
                }
                if (permissionMethodMap.containsKey(key)) {
                    permissionMethodMap.get(key).invoke(fragment != null ? fragment : activity, new Object[0]);
                } else if (debug) {
                    Log.w((String)TAG, (String)("No method found to handle the " + permission + " " + val + " case. Please check for the detail here https://github.com/00ec454/Ask"));
                }
            }
            catch (Exception e) {
                if (!debug) break block6;
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        debug = false;
    }

    public static class Receiver
    extends BroadcastReceiver {
        public void onReceive(Context lContext, Intent intent) {
            boolean grantedAll = true;
            int requestId = intent.getIntExtra("__request_id__", 0);
            if (debug) {
                Log.d((String)TAG, (String)("request id :: " + id + ",  received request id :: " + requestId));
            }
            if (id != requestId) {
                return;
            }
            String[] permissions = intent.getStringArrayExtra("__permissions__");
            int[] grantResults = intent.getIntArrayExtra("__grant_results__");
            ArrayList<String> grantedPermissions = new ArrayList<String>();
            ArrayList<String> deniedPermissions = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                boolean isGranted = grantResults[i] == 0;
                Ask.invokeMethod(permissions[i], isGranted);
                if (isGranted) {
                    grantedPermissions.add(permissions[i]);
                    continue;
                }
                deniedPermissions.add(permissions[i]);
                grantedAll = false;
            }
            if (grantedAll) {
                Ask.invokeMethod(Ask.ALL_PERMISSIONS, true);
            }
            if (permissionObj != null) {
                permissionObj.denied(deniedPermissions);
                permissionObj.granted(grantedPermissions);
                if (deniedPermissions.size() == 0) {
                    permissionObj.grantedAll();
                }
            }
        }
    }

    public static interface Permission {
        public void granted(List<String> var1);

        public void denied(List<String> var1);

        public void grantedAll();
    }
}

