/*
 * Decompiled with CFR 0.152.
 */
package com.vistrav.ask;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import com.vistrav.pop.Pop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AskActivity
extends AppCompatActivity {
    private static final int PERMISSION_REQUEST = 100;
    private static final String TAG = AskActivity.class.getSimpleName();
    private String[] permissions;
    private String[] rationaleMessages;
    private int requestId;
    private static final String NEEDED_PERMISSIONS = "needed_permissions";
    private static final String SHOW_RATIONAL_FOR = "show_rational_for";
    private static final String RATIONALE_MESSAGES_TO_SHOW = "rational_messages";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(16);
        this.init(savedInstanceState);
        this.getPermissions();
    }

    private void init(Bundle state) {
        if (state != null) {
            this.permissions = state.getStringArray("__permissions__");
            this.rationaleMessages = state.getStringArray("__rational_messages__");
            this.requestId = state.getInt("__request_id__");
        } else {
            Intent intent = this.getIntent();
            this.permissions = intent.getStringArrayExtra("__permissions__");
            this.requestId = intent.getExtras().getInt("__request_id__", 0);
        }
    }

    public void onSaveInstanceState(Bundle state) {
        state.putStringArray("__permissions__", this.permissions);
        state.putStringArray("__rational_messages__", this.rationaleMessages);
        state.putInt("__request_id__", this.requestId);
    }

    private void getPermissions() {
        Map<String, List<String>> map = this.separatePermissions(this.permissions, this.rationaleMessages);
        List<String> neededPermissions = map.get(NEEDED_PERMISSIONS);
        final List<String> showRationaleFor = map.get(SHOW_RATIONAL_FOR);
        List<String> rationalMessagesToShow = map.get(RATIONALE_MESSAGES_TO_SHOW);
        if (showRationaleFor.size() > 0 && rationalMessagesToShow != null && rationalMessagesToShow.size() > 0) {
            Pop.on((Activity)this).cancelable(false).body((CharSequence)this.buildRationalMessage(rationalMessagesToShow)).when(new Pop.Yah(){

                public void clicked(DialogInterface dialog, @Nullable View view) {
                    ActivityCompat.requestPermissions((Activity)AskActivity.this, (String[])showRationaleFor.toArray(new String[showRationaleFor.size()]), (int)100);
                    dialog.dismiss();
                }
            }).show();
        } else if (neededPermissions.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])neededPermissions.toArray(new String[showRationaleFor.size()]), (int)100);
        } else {
            int[] result = new int[this.permissions.length];
            Arrays.fill(result, 0);
            this.broadcast(this.permissions, result);
            this.finish();
        }
    }

    private Map<String, List<String>> separatePermissions(String[] permissions, String[] rationalMessages) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> neededPermissions = new ArrayList<String>();
        ArrayList<String> showRationalsFor = new ArrayList<String>();
        ArrayList<String> neededRationalMessages = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission) != 0) {
                neededPermissions.add(permission);
            }
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission)) continue;
            showRationalsFor.add(permission);
            if (rationalMessages == null || rationalMessages.length != permissions.length) continue;
            neededRationalMessages.add(rationalMessages[i]);
        }
        if (rationalMessages != null && rationalMessages.length == 1) {
            neededRationalMessages.add(rationalMessages[0]);
        }
        map.put(NEEDED_PERMISSIONS, neededPermissions);
        map.put(SHOW_RATIONAL_FOR, showRationalsFor);
        map.put(RATIONALE_MESSAGES_TO_SHOW, neededRationalMessages);
        return map;
    }

    @NonNull
    private String buildRationalMessage(@NonNull List<String> messages) {
        StringBuilder sb = new StringBuilder();
        for (String msg : messages) {
            sb.append("\u2022").append("\t").append(msg).append("\n");
        }
        return sb.toString();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 100: {
                this.broadcast(permissions, grantResults);
                this.finish();
            }
        }
    }

    private void broadcast(String[] permissions, int[] grantResults) {
        if (grantResults.length > 0) {
            Intent intent = new Intent();
            intent.setAction("com.vistrav.ask.PERMISSION_RESULT_INTENT");
            intent.putExtra("__permissions__", permissions);
            intent.putExtra("__grant_results__", grantResults);
            intent.putExtra("__request_id__", this.requestId);
            this.sendBroadcast(intent);
        }
    }
}

