/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.highlevel;

import com.virgilsecurity.sdk.client.RequestSigner;
import com.virgilsecurity.sdk.client.exceptions.VirgilException;
import com.virgilsecurity.sdk.client.exceptions.VirgilKeyIsAlreadyExistsException;
import com.virgilsecurity.sdk.client.exceptions.VirgilKeyIsNotFoundException;
import com.virgilsecurity.sdk.client.requests.CreateCardRequest;
import com.virgilsecurity.sdk.client.requests.SignedRequest;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.KeyEntry;
import com.virgilsecurity.sdk.crypto.KeyPair;
import com.virgilsecurity.sdk.crypto.KeyStorage;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.exceptions.EmptyArgumentException;
import com.virgilsecurity.sdk.crypto.exceptions.NullArgumentException;
import com.virgilsecurity.sdk.highlevel.VirgilCard;
import com.virgilsecurity.sdk.highlevel.VirgilConfig;
import com.virgilsecurity.sdk.keystorage.VirgilKeyEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VirgilKey {
    private KeyPair keyPair;
    private String keyName;

    private VirgilKey() {
    }

    private VirgilKey(String keyName, KeyPair keyPair) {
        this.keyName = keyName;
        this.keyPair = keyPair;
    }

    public static VirgilKey create(String keyName, KeyPair keyPair) {
        return VirgilKey.create(keyName, keyPair, null);
    }

    public static VirgilKey create(String keyName, KeyPair keyPair, String password) {
        if (StringUtils.isBlank(keyName)) {
            throw new EmptyArgumentException("keyName");
        }
        if (keyPair == null) {
            throw new NullArgumentException("keyPair");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        KeyStorage storage = VirgilConfig.getService(KeyStorage.class);
        if (storage.exists(keyName)) {
            throw new VirgilKeyIsAlreadyExistsException();
        }
        VirgilKey virgilKey = new VirgilKey(keyName, keyPair);
        byte[] exportedPrivateKey = crypto.exportPrivateKey(virgilKey.getKeyPair().getPrivateKey(), password);
        storage.store(new VirgilKeyEntry(keyName, exportedPrivateKey));
        return virgilKey;
    }

    public static VirgilKey create(String keyName) {
        return VirgilKey.create(keyName, (String)null);
    }

    public static VirgilKey create(String keyName, String password) {
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        KeyPair keyPair = crypto.generateKeys();
        return VirgilKey.create(keyName, keyPair, password);
    }

    public static VirgilKey load(String keyName) {
        return VirgilKey.load(keyName, null);
    }

    public static VirgilKey load(String keyName, String password) {
        if (StringUtils.isBlank(keyName)) {
            throw new EmptyArgumentException("keyName");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        KeyStorage storage = VirgilConfig.getService(KeyStorage.class);
        if (!storage.exists(keyName)) {
            throw new VirgilKeyIsNotFoundException();
        }
        KeyEntry entry = storage.load(keyName);
        PrivateKey privateKey = crypto.importPrivateKey(entry.getValue(), password);
        PublicKey publicKey = crypto.extractPublicKey(privateKey);
        VirgilKey virgilKey = new VirgilKey(keyName, new KeyPair(publicKey, privateKey));
        return virgilKey;
    }

    public byte[] export() {
        return this.export();
    }

    public byte[] export(String password) {
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        return crypto.exportPrivateKey(this.getKeyPair().getPrivateKey(), password);
    }

    public byte[] sign(byte[] data) {
        if (data == null) {
            throw new NullArgumentException("data");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        byte[] signature = crypto.sign(data, this.getKeyPair().getPrivateKey());
        return signature;
    }

    public byte[] decrypt(byte[] cipherData) {
        if (cipherData == null) {
            throw new NullArgumentException("cipherData");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        byte[] data = crypto.decrypt(cipherData, this.getKeyPair().getPrivateKey());
        return data;
    }

    public byte[] signThenEncrypt(byte[] data, List<VirgilCard> recipients) {
        if (recipients == null) {
            throw new NullArgumentException("recipients");
        }
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        ArrayList<PublicKey> publicKeys = new ArrayList<PublicKey>();
        for (VirgilCard recipient : recipients) {
            publicKeys.add(crypto.importPublicKey(recipient.getPublicKey()));
        }
        byte[] cipherdata = crypto.signThenEncrypt(data, this.getKeyPair().getPrivateKey(), publicKeys.toArray(new PublicKey[0]));
        return cipherdata;
    }

    public byte[] decryptThenVerify(byte[] cipherData, VirgilCard signer) {
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        PublicKey publicKey = crypto.importPublicKey(signer.getPublicKey());
        byte[] cipherdata = crypto.decryptThenVerify(cipherData, this.getKeyPair().getPrivateKey(), publicKey);
        return cipherdata;
    }

    public CreateCardRequest buildCardRequest(String identity, String type) {
        return this.buildCardRequest(identity, type, null);
    }

    public CreateCardRequest buildCardRequest(String identity, String type, Map<String, String> data) {
        Crypto crypto = VirgilConfig.getService(Crypto.class);
        RequestSigner signer = VirgilConfig.getService(RequestSigner.class);
        byte[] exportedPublicKey = crypto.exportPublicKey(this.getKeyPair().getPublicKey());
        CreateCardRequest request = new CreateCardRequest(identity, type, exportedPublicKey, data);
        signer.selfSign(request, this.getKeyPair().getPrivateKey());
        return request;
    }

    public void signRequest(SignedRequest request, String appId) {
        if (StringUtils.isBlank(appId)) {
            throw new EmptyArgumentException("appId");
        }
        RequestSigner signer = VirgilConfig.getService(RequestSigner.class);
        signer.authoritySign(request, appId, this.getKeyPair().getPrivateKey());
    }

    public void destroy() {
        if (StringUtils.isBlank(this.keyName)) {
            throw new VirgilException("Operation is not supported");
        }
        KeyStorage storage = VirgilConfig.getService(KeyStorage.class);
        storage.delete(this.getKeyName());
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }
}

