/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.sdk.crypto.Fingerprint;
import com.virgilsecurity.sdk.crypto.HashAlgorithm;
import com.virgilsecurity.sdk.crypto.KeyPair;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;
import java.io.InputStream;
import java.io.OutputStream;

public interface Crypto {
    public Fingerprint calculateFingerprint(byte[] var1);

    public byte[] computeHash(byte[] var1, HashAlgorithm var2);

    public byte[] decrypt(byte[] var1, PrivateKey var2);

    public void decrypt(InputStream var1, OutputStream var2, PrivateKey var3);

    public byte[] encrypt(byte[] var1, PublicKey var2);

    public byte[] encrypt(byte[] var1, PublicKey[] var2);

    public void encrypt(InputStream var1, OutputStream var2, PublicKey var3);

    public void encrypt(InputStream var1, OutputStream var2, PublicKey[] var3);

    public byte[] exportPrivateKey(PrivateKey var1);

    public byte[] exportPrivateKey(PrivateKey var1, String var2);

    public byte[] exportPublicKey(PublicKey var1);

    public PublicKey extractPublicKey(PrivateKey var1);

    public KeyPair generateKeys();

    public PrivateKey importPrivateKey(byte[] var1);

    public PrivateKey importPrivateKey(byte[] var1, String var2);

    public PublicKey importPublicKey(byte[] var1);

    public byte[] sign(byte[] var1, PrivateKey var2);

    public byte[] sign(InputStream var1, PrivateKey var2);

    public boolean verify(byte[] var1, byte[] var2, PublicKey var3);

    public boolean verify(InputStream var1, byte[] var2, PublicKey var3);

    public byte[] signThenEncrypt(byte[] var1, PrivateKey var2, PublicKey var3);

    public byte[] signThenEncrypt(byte[] var1, PrivateKey var2, PublicKey[] var3);

    public byte[] decryptThenVerify(byte[] var1, PrivateKey var2, PublicKey var3);
}

