/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.model.dto;

import com.virgilsecurity.sdk.client.model.CardScope;
import com.virgilsecurity.sdk.client.model.GlobalIdentityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SearchCriteria {
    private Collection<String> identities = new HashSet<String>();
    private String identityType;
    private CardScope scope;

    public static SearchCriteria byIdentities(Collection<String> identities) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.identities = identities;
        criteria.scope = CardScope.APPLICATION;
        return criteria;
    }

    public static SearchCriteria byIdentity(String identity) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.identities = Arrays.asList(identity);
        criteria.scope = CardScope.APPLICATION;
        return criteria;
    }

    public static SearchCriteria byAppBundle(String bundle) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.identities = Arrays.asList(bundle);
        criteria.identityType = GlobalIdentityType.APPLICATION.getValue();
        criteria.scope = CardScope.GLOBAL;
        return criteria;
    }

    public Collection<String> getIdentities() {
        return Collections.unmodifiableCollection(this.identities);
    }

    public void addIdentities(Collection<String> identities) {
        if (identities != null) {
            this.identities.addAll(identities);
        }
    }

    public void addIdentity(String identity) {
        this.identities.add(identity);
    }

    public String getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public CardScope getScope() {
        return this.scope;
    }

    public void setScope(CardScope scope) {
        this.scope = scope;
    }
}

