/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto;

import com.virgilsecurity.sdk.crypto.Base64;
import com.virgilsecurity.sdk.crypto.Cipher;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.Recipient;
import com.virgilsecurity.sdk.crypto.Signer;
import java.util.Map;

public class CryptoHelper {
    public static String encrypt(String text, String password) throws Exception {
        try (Cipher cipher = new Cipher();){
            cipher.addPasswordRecipient(new Password(password));
            byte[] encrypted = cipher.encrypt(text.getBytes(), true);
            String string = Base64.encode(encrypted);
            return string;
        }
    }

    public static String encrypt(String text, String recipientId, PublicKey publicKey) throws Exception {
        try (Cipher cipher = new Cipher();){
            cipher.addKeyRecipient(new Recipient(recipientId), publicKey);
            byte[] encrypted = cipher.encrypt(text.getBytes(), true);
            String string = Base64.encode(encrypted);
            return string;
        }
    }

    public static String encrypt(String text, Map<String, String> recipients) throws Exception {
        try (Cipher cipher = new Cipher();){
            for (Map.Entry<String, String> entry : recipients.entrySet()) {
                cipher.addKeyRecipient(new Recipient(entry.getKey()), new PublicKey(entry.getValue()));
            }
            byte[] encrypted = cipher.encrypt(text.getBytes(), true);
            String string = Base64.encode(encrypted);
            return string;
        }
    }

    public static String decrypt(String base64Text, String password) throws Exception {
        try (Cipher cipher = new Cipher();){
            cipher.addPasswordRecipient(new Password(password));
            byte[] decrypted = cipher.decryptWithPassword(Base64.decode(base64Text), new Password(password));
            String string = new String(decrypted);
            return string;
        }
    }

    public static String decrypt(String base64Text, String recipientId, PrivateKey privateKey) throws Exception {
        try (Cipher cipher = new Cipher();){
            byte[] decrypted = cipher.decryptWithKey(Base64.decode(base64Text), new Recipient(recipientId), privateKey);
            String string = new String(decrypted);
            return string;
        }
    }

    public static String decrypt(String base64Text, String recipientId, PrivateKey privateKey, Password password) throws Exception {
        try (Cipher cipher = new Cipher();){
            byte[] decrypted = cipher.decryptWithKey(Base64.decode(base64Text), new Recipient(recipientId), privateKey, password);
            String string = new String(decrypted);
            return string;
        }
    }

    public static String sign(String text, PrivateKey privateKey) throws Exception {
        try (Signer signer = new Signer();){
            byte[] signature = signer.sign(text.getBytes(), privateKey);
            String string = Base64.encode(signature);
            return string;
        }
    }

    public static String sign(String text, PrivateKey privateKey, Password password) throws Exception {
        try (Signer signer = new Signer();){
            byte[] signature = signer.sign(text.getBytes(), privateKey, password);
            String string = Base64.encode(signature);
            return string;
        }
    }

    public static boolean verify(String text, String signature, PublicKey publicKey) throws Exception {
        try (Signer signer = new Signer();){
            boolean bl = signer.verify(text.getBytes(), Base64.decode(signature), publicKey);
            return bl;
        }
    }
}

