/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.model.publickey;

import com.google.gson.annotations.SerializedName;
import com.virgilsecurity.sdk.client.model.IdentityType;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SearchCriteria {
    @SerializedName(value="value")
    private String value;
    @SerializedName(value="type")
    private IdentityType type;
    @SerializedName(value="relations")
    private List<String> relations;
    @SerializedName(value="include_unconfirmed")
    private Boolean includeUnconfirmed;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public IdentityType getType() {
        return this.type;
    }

    public void setType(IdentityType type) {
        this.type = type;
    }

    public List<String> getRelations() {
        return this.relations;
    }

    public void setRelations(List<String> relations) {
        this.relations = relations;
    }

    public Boolean getIncludeUnconfirmed() {
        return this.includeUnconfirmed;
    }

    public void setIncludeUnconfirmed(Boolean includeUnconfirmed) {
        this.includeUnconfirmed = includeUnconfirmed;
    }

    public static class Builder {
        private IdentityType type = IdentityType.EMAIL;
        private String value;
        private List<String> relations = new ArrayList<String>();
        private Boolean includeUnconfirmed;

        public Builder setType(IdentityType type) {
            this.type = type;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder addRelation(String relation) {
            this.relations.add(relation);
            return this;
        }

        public Builder setIncludeUnconfirmed(Boolean includeUnconfirmed) {
            this.includeUnconfirmed = includeUnconfirmed;
            return this;
        }

        public SearchCriteria build() {
            if (StringUtils.isBlank(this.value)) {
                throw new IllegalArgumentException("Value is not set");
            }
            SearchCriteria request = new SearchCriteria();
            request.setType(this.type);
            request.setValue(this.value);
            if (this.includeUnconfirmed != null) {
                request.setIncludeUnconfirmed(this.includeUnconfirmed);
            }
            if (!this.relations.isEmpty()) {
                request.setRelations(this.relations);
            }
            return request;
        }
    }
}

