/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Connector;

public class Gateway {
    private long objPtr;
    private IConnect Connect;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native boolean connectNative(long var1, String var3, String var4, String var5, String var6);

    private native long constructCopyNative(long var1);

    private native void destructNative(long var1);

    private native void disconnectNative(long var1);

    public Gateway(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void onDisconnected(GatewayDisconnectReason reason) {
        if (this.Connect != null) {
            this.Connect.onDisconnected(reason);
        }
    }

    public void onFailure(GatewayFailReason reason) {
        if (this.Connect != null) {
            this.Connect.onFailure(reason);
        }
    }

    public void onSuccess() {
        if (this.Connect != null) {
            this.Connect.onSuccess();
        }
    }

    public boolean connect(String host, String token, String displayName, String resourceId, IConnect Connect) {
        this.Connect = Connect;
        return this.connectNative(this.objPtr, host, token, displayName, resourceId);
    }

    public void disconnect() {
        this.disconnectNative(this.objPtr);
    }

    public static interface IConnect {
        public void onSuccess();

        public void onFailure(GatewayFailReason var1);

        public void onDisconnected(GatewayDisconnectReason var1);
    }

    public static enum GatewayState {
        VIDYO_GATEWAYSTATE_Idle,
        VIDYO_GATEWAYSTATE_EstablishingConnection,
        VIDYO_GATEWAYSTATE_FindingResource,
        VIDYO_GATEWAYSTATE_ConnectingToResource,
        VIDYO_GATEWAYSTATE_EnablingMedia,
        VIDYO_GATEWAYSTATE_Connected;

    }

    public static enum GatewayFailReason {
        VIDYO_GATEWAYFAILREASON_ConnectionFailed,
        VIDYO_GATEWAYFAILREASON_ConnectionLost,
        VIDYO_GATEWAYFAILREASON_ConnectionTimeout,
        VIDYO_GATEWAYFAILREASON_NoResponse,
        VIDYO_GATEWAYFAILREASON_Terminated,
        VIDYO_GATEWAYFAILREASON_InvalidToken,
        VIDYO_GATEWAYFAILREASON_UnableToCreateResource,
        VIDYO_GATEWAYFAILREASON_NoResponseFromResource,
        VIDYO_GATEWAYFAILREASON_InvalidResourceId,
        VIDYO_GATEWAYFAILREASON_ResourceFull,
        VIDYO_GATEWAYFAILREASON_NotMember,
        VIDYO_GATEWAYFAILREASON_Banned,
        VIDYO_GATEWAYFAILREASON_MediaNotEnabled,
        VIDYO_GATEWAYFAILREASON_MediaFailed,
        VIDYO_GATEWAYFAILREASON_MiscLocalError,
        VIDYO_GATEWAYFAILREASON_MiscRemoteError,
        VIDYO_GATEWAYFAILREASON_MiscError;

    }

    public static enum GatewayDisconnectReason {
        VIDYO_GATEWAYDISCONNECTREASON_Disconnected,
        VIDYO_GATEWAYDISCONNECTREASON_ConnectionLost,
        VIDYO_GATEWAYDISCONNECTREASON_ConnectionTimeout,
        VIDYO_GATEWAYDISCONNECTREASON_NoResponse,
        VIDYO_GATEWAYDISCONNECTREASON_Terminated,
        VIDYO_GATEWAYDISCONNECTREASON_MiscLocalError,
        VIDYO_GATEWAYDISCONNECTREASON_MiscRemoteError,
        VIDYO_GATEWAYDISCONNECTREASON_MiscError;

    }
}

