/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import java.util.concurrent.TimeUnit;

public class LmiVideoCapturerCapability {
    int width;
    int height;
    String format;
    RateInfo rate;

    public LmiVideoCapturerCapability() {
        this.width = 0;
        this.height = 0;
        this.rate = new IntervalRateInfo(0L, 0L);
        this.format = "";
    }

    public LmiVideoCapturerCapability(int width, int height, int minFrameRate, int maxFrameRate, String format) {
        this.width = width;
        this.height = height;
        this.rate = new FrameRateInfo(minFrameRate, maxFrameRate);
        this.format = format;
    }

    public LmiVideoCapturerCapability(int width, int height, long maxInterval, long minInterval, String format) {
        this.width = width;
        this.height = height;
        this.rate = new IntervalRateInfo(maxInterval, minInterval);
        this.format = format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static long toInterval(int framerate) {
        if (framerate == 0) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.SECONDS.toNanos(1000L) / (long)framerate;
    }

    private static int toFrameRate(long interval) {
        if (interval == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)(TimeUnit.SECONDS.toNanos(1000L) / interval);
    }

    public long getMaxFrameInterval() {
        return this.rate.getMaxFrameInterval();
    }

    public long getMinFrameInterval() {
        return this.rate.getMinFrameInterval();
    }

    public int getMinFrameRate() {
        return this.rate.getMinFrameRate();
    }

    public int getMaxFrameRate() {
        return this.rate.getMaxFrameRate();
    }

    public String getFormat() {
        return this.format;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    private class IntervalRateInfo
    implements RateInfo {
        private long maxInterval;
        private long minInterval;

        IntervalRateInfo(long max, long min) {
            this.maxInterval = max;
            this.minInterval = min;
        }

        @Override
        public long getMaxFrameInterval() {
            return this.maxInterval;
        }

        @Override
        public long getMinFrameInterval() {
            return this.minInterval;
        }

        @Override
        public int getMinFrameRate() {
            return LmiVideoCapturerCapability.toFrameRate(this.maxInterval);
        }

        @Override
        public int getMaxFrameRate() {
            return LmiVideoCapturerCapability.toFrameRate(this.minInterval);
        }
    }

    private class FrameRateInfo
    implements RateInfo {
        private int minFrameRate;
        private int maxFrameRate;

        FrameRateInfo(int min, int max) {
            this.minFrameRate = min;
            this.maxFrameRate = max;
        }

        @Override
        public long getMaxFrameInterval() {
            return LmiVideoCapturerCapability.toInterval(this.minFrameRate);
        }

        @Override
        public long getMinFrameInterval() {
            return LmiVideoCapturerCapability.toInterval(this.maxFrameRate);
        }

        @Override
        public int getMinFrameRate() {
            return this.minFrameRate;
        }

        @Override
        public int getMaxFrameRate() {
            return this.maxFrameRate;
        }
    }

    private static interface RateInfo {
        public long getMaxFrameInterval();

        public long getMinFrameInterval();

        public int getMinFrameRate();

        public int getMaxFrameRate();
    }
}

