/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerManager;

@TargetApi(value=21)
class LmiVideoCapturerManagerCamera2
extends LmiVideoCapturerManager {
    private static CameraManager manager;
    private AvailabilityCallback callback;
    private static HandlerThread handlerThread;
    private static Handler handler;

    LmiVideoCapturerManagerCamera2(Context context, long nativeP) {
        super(nativeP);
        Log.i((String)"LmiVideoCapturerManager", (String)"constructing Camera2 capturer manager");
        LmiVideoCapturerManagerCamera2.getManager(context);
    }

    @Override
    void enumerateDevices() throws Exception {
        this.devicesArray = manager.getCameraIdList();
    }

    static synchronized CameraManager getManager(Context context) {
        if (manager == null) {
            manager = (CameraManager)context.getApplicationContext().getSystemService("camera");
        }
        return manager;
    }

    static synchronized Handler getHandler() {
        if (handler == null) {
            handlerThread = new HandlerThread("Camera Manager handler");
            handlerThread.start();
            handler = new Handler(handlerThread.getLooper());
        }
        return handler;
    }

    static synchronized void stopHandler() {
        if (handler != null) {
            try {
                handlerThread.quitSafely();
                handlerThread.join();
            }
            catch (Exception e) {
                Log.e((String)"LmiVideoCapturerManager", (String)"Unable to stop Camera Manager handler thread", (Throwable)e);
            }
            handler = null;
            handlerThread = null;
        }
    }

    @Override
    public boolean startDeviceDetector() {
        try {
            this.callback = new AvailabilityCallback();
            manager.registerAvailabilityCallback((CameraManager.AvailabilityCallback)this.callback, LmiVideoCapturerManagerCamera2.getHandler());
            this.enumerateDevices();
            return true;
        }
        catch (Exception ex) {
            Log.e((String)"LmiVideoCapturerManager", (String)"Failed to enumerate cameras", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean stopDeviceDetector() {
        if (this.callback == null) {
            return true;
        }
        this.callback.stop();
        manager.unregisterAvailabilityCallback((CameraManager.AvailabilityCallback)this.callback);
        LmiVideoCapturerManagerCamera2.stopHandler();
        this.callback = null;
        return true;
    }

    private class AvailabilityCallback
    extends CameraManager.AvailabilityCallback {
        boolean stopped = false;

        private AvailabilityCallback() {
        }

        synchronized void stop() {
            this.stopped = true;
        }

        private synchronized boolean isStopped() {
            return this.stopped;
        }

        public void onCameraAvailable(String cameraId) {
            if (this.isStopped()) {
                return;
            }
            Log.i((String)"LmiVideoCapturerManager", (String)("Camera " + cameraId + " marked available"));
            try {
                LmiVideoCapturerManagerCamera2.this.enumerateDevices();
            }
            catch (Exception ex) {
                Log.e((String)"LmiVideoCapturerManager", (String)"Failed to enumerate cameras", (Throwable)ex);
            }
            LmiVideoCapturerManagerCamera2.this.processDeviceChange();
            LmiVideoCapturerManagerCamera2.this.processAvailable(cameraId, true);
        }

        public void onCameraUnavailable(String cameraId) {
            if (this.isStopped()) {
                return;
            }
            Log.i((String)"LmiVideoCapturerManager", (String)("Camera " + cameraId + " marked unavailable"));
            try {
                LmiVideoCapturerManagerCamera2.this.enumerateDevices();
            }
            catch (Exception ex) {
                Log.e((String)"LmiVideoCapturerManager", (String)"Failed to enumerate cameras", (Throwable)ex);
            }
            LmiVideoCapturerManagerCamera2.this.processDeviceChange();
            LmiVideoCapturerManagerCamera2.this.processAvailable(cameraId, false);
        }
    }
}

