/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Endpoint;

import com.vidyo.VidyoClient.Device.LocalCamera;
import com.vidyo.VidyoClient.Device.LocalMicrophone;
import com.vidyo.VidyoClient.Device.LocalMonitor;
import com.vidyo.VidyoClient.Device.LocalRenderer;
import com.vidyo.VidyoClient.Device.LocalSpeaker;
import com.vidyo.VidyoClient.Device.LocalWindowShare;
import com.vidyo.VidyoClient.Endpoint.ChatMessage;
import com.vidyo.VidyoClient.Endpoint.Participant;
import com.vidyo.VidyoClient.Endpoint.User;
import com.vidyo.VidyoClient.EventSchedule;
import com.vidyo.VidyoClient.Stats.RoomStats;
import java.util.ArrayList;

public class Room {
    private long objPtr;
    public String id;
    public RoomType type;
    private IAcceptIncoming AcceptIncoming;
    private IAcquireMediaRoute AcquireMediaRoute;
    private IDelete Delete;
    private IEnableMedia EnableMedia;
    private IEnter Enter;
    private IGetHistory GetHistory;
    private IGetRoomProperties GetRoomProperties;
    private IInvite Invite;
    private IMessageSearch MessageSearch;
    private IRegisterMessageEventListener RegisterMessageEventListener;
    private IRegisterParticipantEventListener RegisterParticipantEventListener;
    private IRegisterPipEventListener RegisterPipEventListener;
    private IRegisterRecorderInCallEventListener RegisterRecorderInCallEventListener;
    private IRegisterResourceManagerEventListener RegisterResourceManagerEventListener;
    private IRegisterRoomPropertiesEventListener RegisterRoomPropertiesEventListener;
    private IRegisterSubjectEventListener RegisterSubjectEventListener;
    private IRegisterUnprocessedAudioEventListener RegisterUnprocessedAudioEventListener;
    private ISetFavorite SetFavorite;
    private ISetRoomProperties SetRoomProperties;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native boolean acceptIncomingNative(long var1);

    private native boolean acquireMediaRouteNative(long var1);

    private native void addLocalCameraNative(long var1, LocalCamera var3, boolean var4);

    private native void addLocalMicrophoneNative(long var1, LocalMicrophone var3, boolean var4, boolean var5);

    private native void addLocalMonitorNative(long var1, LocalMonitor var3, boolean var4);

    private native void addLocalRendererNative(long var1, LocalRenderer var3, boolean var4);

    private native void addLocalSpeakerNative(long var1, LocalSpeaker var3, boolean var4, boolean var5);

    private native void addLocalWindowShareNative(long var1, LocalWindowShare var3, boolean var4);

    private native boolean bootAllParticipantsNative(long var1, String var3);

    private native boolean bootParticipantNative(long var1, String var3, String var4);

    private native boolean cancelInviteNative(long var1, String var3);

    private native long constructCopyNative(long var1);

    private native void deleteNative(long var1);

    private native void destructNative(long var1);

    private native boolean disableMediaNative(long var1);

    private native boolean enableMediaNative(long var1);

    private native boolean enterNative(long var1, String var3);

    private native boolean getHistoryNative(long var1, int var3);

    private native boolean getHistoryByIdNative(long var1, long var3, int var5, int var6);

    private native boolean getHistoryByTimeNative(long var1, long var3, int var5, int var6);

    private native String getIdNative(long var1);

    private native boolean getRoomPropertiesNative(long var1);

    private native void getSelectedLocalCamerasNative(long var1, ArrayList<LocalCamera> var3);

    private native void getSelectedLocalMicrophonesNative(long var1, ArrayList<LocalMicrophone> var3);

    private native void getSelectedLocalMonitorsNative(long var1, ArrayList<LocalMonitor> var3);

    private native void getSelectedLocalRenderersNative(long var1, ArrayList<LocalRenderer> var3);

    private native void getSelectedLocalSpeakersNative(long var1, ArrayList<LocalSpeaker> var3);

    private native void getSelectedLocalWindowSharesNative(long var1, ArrayList<LocalWindowShare> var3);

    private native boolean getStatsNative(long var1, RoomStats var3);

    private native RoomType getTypeNative(long var1);

    private native User getUserNative(long var1);

    private native void hideStatisticsDialogNative(long var1);

    private native boolean inviteNative(long var1, String var3, String var4);

    private native boolean inviteAllNative(long var1, String var3);

    private native boolean inviteNNative(long var1, ArrayList<String> var3, String var4);

    private native boolean leaveNative(long var1);

    private native boolean messageSearchNative(long var1, String var3, int var4, int var5);

    private native boolean registerMessageEventListenerNative(long var1);

    private native boolean registerParticipantEventListenerNative(long var1);

    private native boolean registerPipEventListenerNative(long var1);

    private native boolean registerRecorderInCallEventListenerNative(long var1);

    private native boolean registerResourceManagerEventListenerNative(long var1);

    private native boolean registerRoomPropertiesEventListenerNative(long var1);

    private native boolean registerSubjectEventListenerNative(long var1);

    private native boolean registerUnprocessedAudioEventListenerNative(long var1);

    private native boolean rejectIncomingNative(long var1);

    private native void removeLocalCameraNative(long var1, LocalCamera var3);

    private native void removeLocalMicrophoneNative(long var1, LocalMicrophone var3);

    private native void removeLocalMonitorNative(long var1, LocalMonitor var3);

    private native void removeLocalRendererNative(long var1, LocalRenderer var3);

    private native void removeLocalSpeakerNative(long var1, LocalSpeaker var3);

    private native void removeLocalWindowShareNative(long var1, LocalWindowShare var3);

    private native boolean reportLocalParticipantOnJoinedNative(long var1, boolean var3);

    private native void resizeStatisticsDialogNative(long var1, int var3, int var4);

    private native boolean sendMessageNative(long var1, String var3);

    private native boolean sendMessageAcknowledgedNative(long var1, long var3);

    private native boolean sendMessageTypingIndicationNative(long var1, ChatMessage.ChatMessageTypingIndication var3);

    private native boolean setDynamicGenerationPositionNative(long var1, int var3, int var4, int var5, int var6, int var7, long var8);

    private native boolean setDynamicLocalRendererNative(long var1, LocalRenderer var3);

    private native void setFavoriteNative(long var1, boolean var3);

    private native boolean setMaxAudioSourcesNative(long var1, int var3);

    private native void setMaxBitRateNative(long var1, int var3);

    private native boolean setMaxVideoSourcesNative(long var1, int var3);

    private native boolean setRoomPropertiesNative(long var1, RoomProperties var3);

    private native boolean setSubjectNative(long var1, String var3);

    private native void showStatisticsDialogNative(long var1);

    private native boolean unregisterMessageEventListenerNative(long var1);

    private native boolean unregisterParticipantEventListenerNative(long var1);

    private native boolean unregisterPipEventListenerNative(long var1);

    private native boolean unregisterRecorderInCallEventListenerNative(long var1);

    private native boolean unregisterResourceManagerEventListenerNative(long var1);

    private native boolean unregisterRoomPropertiesEventListenerNative(long var1);

    private native boolean unregisterSubjectEventListenerNative(long var1);

    private native boolean unregisterUnprocessedAudioEventListenerNative(long var1);

    public Room(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void onAvailableResourcesChanged(int cpuEncode, int cpuDecode, int bandwidthSend, int bandwidthReceive) {
        if (this.RegisterResourceManagerEventListener != null) {
            this.RegisterResourceManagerEventListener.onAvailableResourcesChanged(cpuEncode, cpuDecode, bandwidthSend, bandwidthReceive);
        }
    }

    public void onDeleteResult(RoomDeleteResult result) {
        if (this.Delete != null) {
            this.Delete.onDeleteResult(result);
        }
    }

    public void onDynamicParticipantChanged(ArrayList<Participant> selectedParticipants) {
        if (this.RegisterParticipantEventListener != null) {
            this.RegisterParticipantEventListener.onDynamicParticipantChanged(selectedParticipants);
        }
    }

    public void onEntered(RoomEnterResult result) {
        if (this.Enter != null) {
            this.Enter.onEntered(result);
        }
    }

    public void onExited(RoomExitReason reason) {
        if (this.Enter != null) {
            this.Enter.onExited(reason);
        }
    }

    public void onGetHistoryResults(ArrayList<ChatMessage> records, long historySize, RoomSearchResult result) {
        if (this.GetHistory != null) {
            this.GetHistory.onGetHistoryResults(records, historySize, result);
        }
    }

    public void onGetRoomPropertiesResult(RoomGetPropertiesResult result, RoomProperties roomProperties) {
        if (this.GetRoomProperties != null) {
            this.GetRoomProperties.onGetRoomPropertiesResult(result, roomProperties);
        }
    }

    public void onIncomingEntered(RoomEnterResult result) {
        if (this.AcceptIncoming != null) {
            this.AcceptIncoming.onIncomingEntered(result);
        }
    }

    public void onIncomingExited(RoomExitReason reason) {
        if (this.AcceptIncoming != null) {
            this.AcceptIncoming.onIncomingExited(reason);
        }
    }

    public void onInviteResult(String inviteeId, RoomInviteResult result) {
        if (this.Invite != null) {
            this.Invite.onInviteResult(inviteeId, result);
        }
    }

    public void onLoudestParticipantChanged(Participant participant, boolean isAudioOnly, boolean isStatic) {
        if (this.RegisterParticipantEventListener != null) {
            this.RegisterParticipantEventListener.onLoudestParticipantChanged(participant, isAudioOnly, isStatic);
        }
    }

    public void onMaxRemoteSourcesChanged(int maxRemoteSources) {
        if (this.RegisterResourceManagerEventListener != null) {
            this.RegisterResourceManagerEventListener.onMaxRemoteSourcesChanged(maxRemoteSources);
        }
    }

    public void onMediaDisabled(RoomMediaDisableReason reason) {
        if (this.EnableMedia != null) {
            this.EnableMedia.onMediaDisabled(reason);
        }
    }

    public void onMediaEnabled() {
        if (this.EnableMedia != null) {
            this.EnableMedia.onMediaEnabled();
        }
    }

    public void onMediaFailed(RoomMediaFailReason reason) {
        if (this.EnableMedia != null) {
            this.EnableMedia.onMediaFailed(reason);
        }
    }

    public void onMediaRouteAcquireFailed(RoomMediaFailReason reason) {
        if (this.AcquireMediaRoute != null) {
            this.AcquireMediaRoute.onMediaRouteAcquireFailed(reason);
        }
    }

    public void onMediaRouteAcquired() {
        if (this.AcquireMediaRoute != null) {
            this.AcquireMediaRoute.onMediaRouteAcquired();
        }
    }

    public void onMessageAcknowledged(ChatMessage chatMessage) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageAcknowledged(chatMessage);
        }
    }

    public void onMessageRead(Participant participant, long messageId) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageRead(participant, messageId);
        }
    }

    public void onMessageReceived(Participant participant, ChatMessage chatMessage) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageReceived(participant, chatMessage);
        }
    }

    public void onMessageSearchResults(String searchText, ArrayList<ChatMessage> records, RoomSearchResult result) {
        if (this.MessageSearch != null) {
            this.MessageSearch.onMessageSearchResults(searchText, records, result);
        }
    }

    public void onMessageTypingIndication(Participant participant, ChatMessage.ChatMessageTypingIndication typingIndication) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageTypingIndication(participant, typingIndication);
        }
    }

    public void onParticipantJoined(Participant participant) {
        if (this.RegisterParticipantEventListener != null) {
            this.RegisterParticipantEventListener.onParticipantJoined(participant);
        }
    }

    public void onParticipantLeft(Participant participant) {
        if (this.RegisterParticipantEventListener != null) {
            this.RegisterParticipantEventListener.onParticipantLeft(participant);
        }
    }

    public void onPipLocationChanged(int x, int y, int width, int height, boolean isExpanded) {
        if (this.RegisterPipEventListener != null) {
            this.RegisterPipEventListener.onPipLocationChanged(x, y, width, height, isExpanded);
        }
    }

    public void onRoomPropertiesChanged(RoomProperties roomProperties) {
        if (this.RegisterRoomPropertiesEventListener != null) {
            this.RegisterRoomPropertiesEventListener.onRoomPropertiesChanged(roomProperties);
        }
    }

    public void onSetFavoriteResult(boolean isFavorite, RoomSetFavoriteResult result) {
        if (this.SetFavorite != null) {
            this.SetFavorite.onSetFavoriteResult(isFavorite, result);
        }
    }

    public void onSetRoomPropertiesResult(RoomSetPropertiesResult result) {
        if (this.SetRoomProperties != null) {
            this.SetRoomProperties.onSetRoomPropertiesResult(result);
        }
    }

    public void onSetSubject(String subject) {
        if (this.RegisterSubjectEventListener != null) {
            this.RegisterSubjectEventListener.onSetSubject(subject);
        }
    }

    public void onUnprocessedAudioStarted(boolean started) {
        if (this.RegisterUnprocessedAudioEventListener != null) {
            this.RegisterUnprocessedAudioEventListener.onUnprocessedAudioStarted(started);
        }
    }

    public void onUnprocessedAudioSupportChanged(boolean supported) {
        if (this.RegisterUnprocessedAudioEventListener != null) {
            this.RegisterUnprocessedAudioEventListener.onUnprocessedAudioSupportChanged(supported);
        }
    }

    public void recorderInCall(boolean recorderInCall) {
        if (this.RegisterRecorderInCallEventListener != null) {
            this.RegisterRecorderInCallEventListener.recorderInCall(recorderInCall);
        }
    }

    public boolean acceptIncoming(IAcceptIncoming AcceptIncoming) {
        this.AcceptIncoming = AcceptIncoming;
        return this.acceptIncomingNative(this.objPtr);
    }

    public boolean acquireMediaRoute(IAcquireMediaRoute AcquireMediaRoute) {
        this.AcquireMediaRoute = AcquireMediaRoute;
        return this.acquireMediaRouteNative(this.objPtr);
    }

    public void addLocalCamera(LocalCamera localCamera, boolean removeOthers) {
        this.addLocalCameraNative(this.objPtr, localCamera, removeOthers);
    }

    public void addLocalMicrophone(LocalMicrophone localMicrophone, boolean removeOthers, boolean isAES) {
        this.addLocalMicrophoneNative(this.objPtr, localMicrophone, removeOthers, isAES);
    }

    public void addLocalMonitor(LocalMonitor localMonitor, boolean removeOthers) {
        this.addLocalMonitorNative(this.objPtr, localMonitor, removeOthers);
    }

    public void addLocalRenderer(LocalRenderer localRenderer, boolean removeOthers) {
        this.addLocalRendererNative(this.objPtr, localRenderer, removeOthers);
    }

    public void addLocalSpeaker(LocalSpeaker localSpeaker, boolean removeOthers, boolean isAES) {
        this.addLocalSpeakerNative(this.objPtr, localSpeaker, removeOthers, isAES);
    }

    public void addLocalWindowShare(LocalWindowShare localWindowShare, boolean removeOthers) {
        this.addLocalWindowShareNative(this.objPtr, localWindowShare, removeOthers);
    }

    public boolean bootAllParticipants(String reason) {
        return this.bootAllParticipantsNative(this.objPtr, reason);
    }

    public boolean bootParticipant(String userId, String reason) {
        return this.bootParticipantNative(this.objPtr, userId, reason);
    }

    public boolean cancelInvite(String inviteeId) {
        return this.cancelInviteNative(this.objPtr, inviteeId);
    }

    public void delete(IDelete Delete) {
        this.Delete = Delete;
        this.deleteNative(this.objPtr);
    }

    public boolean disableMedia() {
        return this.disableMediaNative(this.objPtr);
    }

    public boolean enableMedia(IEnableMedia EnableMedia) {
        this.EnableMedia = EnableMedia;
        return this.enableMediaNative(this.objPtr);
    }

    public boolean enter(String password, IEnter Enter) {
        this.Enter = Enter;
        return this.enterNative(this.objPtr, password);
    }

    public boolean getHistory(int numMessages, IGetHistory GetHistory) {
        this.GetHistory = GetHistory;
        return this.getHistoryNative(this.objPtr, numMessages);
    }

    public boolean getHistoryById(long messageId, int numMessagesBefore, int numMessagesAfter, IGetHistory GetHistory) {
        this.GetHistory = GetHistory;
        return this.getHistoryByIdNative(this.objPtr, messageId, numMessagesBefore, numMessagesAfter);
    }

    public boolean getHistoryByTime(long time, int numMessagesBefore, int numMessagesAfter, IGetHistory GetHistory) {
        this.GetHistory = GetHistory;
        return this.getHistoryByTimeNative(this.objPtr, time, numMessagesBefore, numMessagesAfter);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public boolean getRoomProperties(IGetRoomProperties GetRoomProperties) {
        this.GetRoomProperties = GetRoomProperties;
        return this.getRoomPropertiesNative(this.objPtr);
    }

    public void getSelectedLocalCameras(ArrayList<LocalCamera> cameras) {
        this.getSelectedLocalCamerasNative(this.objPtr, cameras);
    }

    public void getSelectedLocalMicrophones(ArrayList<LocalMicrophone> mics) {
        this.getSelectedLocalMicrophonesNative(this.objPtr, mics);
    }

    public void getSelectedLocalMonitors(ArrayList<LocalMonitor> monitors) {
        this.getSelectedLocalMonitorsNative(this.objPtr, monitors);
    }

    public void getSelectedLocalRenderers(ArrayList<LocalRenderer> renderers) {
        this.getSelectedLocalRenderersNative(this.objPtr, renderers);
    }

    public void getSelectedLocalSpeakers(ArrayList<LocalSpeaker> speakers) {
        this.getSelectedLocalSpeakersNative(this.objPtr, speakers);
    }

    public void getSelectedLocalWindowShares(ArrayList<LocalWindowShare> windowShares) {
        this.getSelectedLocalWindowSharesNative(this.objPtr, windowShares);
    }

    public boolean getStats(RoomStats stats) {
        return this.getStatsNative(this.objPtr, stats);
    }

    public RoomType getType() {
        return this.getTypeNative(this.objPtr);
    }

    public User getUser() {
        return this.getUserNative(this.objPtr);
    }

    public void hideStatisticsDialog() {
        this.hideStatisticsDialogNative(this.objPtr);
    }

    public boolean invite(String userId, String message, IInvite Invite) {
        this.Invite = Invite;
        return this.inviteNative(this.objPtr, userId, message);
    }

    public boolean inviteAll(String message, IInvite Invite) {
        this.Invite = Invite;
        return this.inviteAllNative(this.objPtr, message);
    }

    public boolean inviteN(ArrayList<String> userIds, String message, IInvite Invite) {
        this.Invite = Invite;
        return this.inviteNNative(this.objPtr, userIds, message);
    }

    public boolean leave() {
        return this.leaveNative(this.objPtr);
    }

    public boolean messageSearch(String searchText, int index, int pageSize, IMessageSearch MessageSearch) {
        this.MessageSearch = MessageSearch;
        return this.messageSearchNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean registerMessageEventListener(IRegisterMessageEventListener RegisterMessageEventListener) {
        this.RegisterMessageEventListener = RegisterMessageEventListener;
        return this.registerMessageEventListenerNative(this.objPtr);
    }

    public boolean registerParticipantEventListener(IRegisterParticipantEventListener RegisterParticipantEventListener) {
        this.RegisterParticipantEventListener = RegisterParticipantEventListener;
        return this.registerParticipantEventListenerNative(this.objPtr);
    }

    public boolean registerPipEventListener(IRegisterPipEventListener RegisterPipEventListener) {
        this.RegisterPipEventListener = RegisterPipEventListener;
        return this.registerPipEventListenerNative(this.objPtr);
    }

    public boolean registerRecorderInCallEventListener(IRegisterRecorderInCallEventListener RegisterRecorderInCallEventListener) {
        this.RegisterRecorderInCallEventListener = RegisterRecorderInCallEventListener;
        return this.registerRecorderInCallEventListenerNative(this.objPtr);
    }

    public boolean registerResourceManagerEventListener(IRegisterResourceManagerEventListener RegisterResourceManagerEventListener) {
        this.RegisterResourceManagerEventListener = RegisterResourceManagerEventListener;
        return this.registerResourceManagerEventListenerNative(this.objPtr);
    }

    public boolean registerRoomPropertiesEventListener(IRegisterRoomPropertiesEventListener RegisterRoomPropertiesEventListener) {
        this.RegisterRoomPropertiesEventListener = RegisterRoomPropertiesEventListener;
        return this.registerRoomPropertiesEventListenerNative(this.objPtr);
    }

    public boolean registerSubjectEventListener(IRegisterSubjectEventListener RegisterSubjectEventListener) {
        this.RegisterSubjectEventListener = RegisterSubjectEventListener;
        return this.registerSubjectEventListenerNative(this.objPtr);
    }

    public boolean registerUnprocessedAudioEventListener(IRegisterUnprocessedAudioEventListener RegisterUnprocessedAudioEventListener) {
        this.RegisterUnprocessedAudioEventListener = RegisterUnprocessedAudioEventListener;
        return this.registerUnprocessedAudioEventListenerNative(this.objPtr);
    }

    public boolean rejectIncoming() {
        return this.rejectIncomingNative(this.objPtr);
    }

    public void removeLocalCamera(LocalCamera localCamera) {
        this.removeLocalCameraNative(this.objPtr, localCamera);
    }

    public void removeLocalMicrophone(LocalMicrophone localMicrophone) {
        this.removeLocalMicrophoneNative(this.objPtr, localMicrophone);
    }

    public void removeLocalMonitor(LocalMonitor localMonitor) {
        this.removeLocalMonitorNative(this.objPtr, localMonitor);
    }

    public void removeLocalRenderer(LocalRenderer localRenderer) {
        this.removeLocalRendererNative(this.objPtr, localRenderer);
    }

    public void removeLocalSpeaker(LocalSpeaker localSpeaker) {
        this.removeLocalSpeakerNative(this.objPtr, localSpeaker);
    }

    public void removeLocalWindowShare(LocalWindowShare localWindowShare) {
        this.removeLocalWindowShareNative(this.objPtr, localWindowShare);
    }

    public boolean reportLocalParticipantOnJoined(boolean reportLocalParticipant) {
        return this.reportLocalParticipantOnJoinedNative(this.objPtr, reportLocalParticipant);
    }

    public void resizeStatisticsDialog(int width, int height) {
        this.resizeStatisticsDialogNative(this.objPtr, width, height);
    }

    public boolean sendMessage(String message) {
        return this.sendMessageNative(this.objPtr, message);
    }

    public boolean sendMessageAcknowledged(long messageId) {
        return this.sendMessageAcknowledgedNative(this.objPtr, messageId);
    }

    public boolean sendMessageTypingIndication(ChatMessage.ChatMessageTypingIndication typingIndication) {
        return this.sendMessageTypingIndicationNative(this.objPtr, typingIndication);
    }

    public boolean setDynamicGenerationPosition(int generation, int x, int y, int width, int height, long frameInterval) {
        return this.setDynamicGenerationPositionNative(this.objPtr, generation, x, y, width, height, frameInterval);
    }

    public boolean setDynamicLocalRenderer(LocalRenderer renderer) {
        return this.setDynamicLocalRendererNative(this.objPtr, renderer);
    }

    public void setFavorite(boolean isFavorite, ISetFavorite SetFavorite) {
        this.SetFavorite = SetFavorite;
        this.setFavoriteNative(this.objPtr, isFavorite);
    }

    public boolean setMaxAudioSources(int count) {
        return this.setMaxAudioSourcesNative(this.objPtr, count);
    }

    public void setMaxBitRate(int bitRate) {
        this.setMaxBitRateNative(this.objPtr, bitRate);
    }

    public boolean setMaxVideoSources(int count) {
        return this.setMaxVideoSourcesNative(this.objPtr, count);
    }

    public boolean setRoomProperties(RoomProperties roomProperties, ISetRoomProperties SetRoomProperties) {
        this.SetRoomProperties = SetRoomProperties;
        return this.setRoomPropertiesNative(this.objPtr, roomProperties);
    }

    public boolean setSubject(String subject) {
        return this.setSubjectNative(this.objPtr, subject);
    }

    public void showStatisticsDialog() {
        this.showStatisticsDialogNative(this.objPtr);
    }

    public boolean unregisterMessageEventListener() {
        return this.unregisterMessageEventListenerNative(this.objPtr);
    }

    public boolean unregisterParticipantEventListener() {
        return this.unregisterParticipantEventListenerNative(this.objPtr);
    }

    public boolean unregisterPipEventListener() {
        return this.unregisterPipEventListenerNative(this.objPtr);
    }

    public boolean unregisterRecorderInCallEventListener() {
        return this.unregisterRecorderInCallEventListenerNative(this.objPtr);
    }

    public boolean unregisterResourceManagerEventListener() {
        return this.unregisterResourceManagerEventListenerNative(this.objPtr);
    }

    public boolean unregisterRoomPropertiesEventListener() {
        return this.unregisterRoomPropertiesEventListenerNative(this.objPtr);
    }

    public boolean unregisterSubjectEventListener() {
        return this.unregisterSubjectEventListenerNative(this.objPtr);
    }

    public boolean unregisterUnprocessedAudioEventListener() {
        return this.unregisterUnprocessedAudioEventListenerNative(this.objPtr);
    }

    public class RoomProperties {
        public ArrayList<String> administrators;
        public String calendarInviteBody;
        public String calendarInviteHTMLBody;
        public String calendarInviteSubject;
        public long creationTime;
        public RoomParticipantProfile defaultProfile;
        public String description;
        public String designatedPresenter;
        public boolean hasCalendarInviteText;
        public boolean hasPassword;
        public boolean isBroadcastingEnabled;
        public boolean isLoggingEnabled;
        public boolean isLoggingPaused;
        public boolean isLoggingSupported;
        public boolean isMembersOnly;
        public boolean isModerated;
        public boolean isPasswordProtected;
        public boolean isPublic;
        public boolean isSecure;
        public boolean isWaitingRoomEnabled;
        public String language;
        public String loggingLocation;
        public int maxParticipants;
        public ArrayList<String> members;
        public String moderatorUrl;
        public ArrayList<String> moderators;
        public String name;
        public ArrayList<String> outcasts;
        public ArrayList<String> owners;
        public ArrayList<RoomParticipantProfile> participantProfiles;
        public String password;
        public EventSchedule schedule;
        public String webLink;

        public boolean equals(Object obj) {
            if (obj instanceof RoomProperties) {
                RoomProperties object = (RoomProperties)obj;
                return this.administrators.equals(object.administrators) && this.calendarInviteBody.equals(object.calendarInviteBody) && this.calendarInviteHTMLBody.equals(object.calendarInviteHTMLBody) && this.calendarInviteSubject.equals(object.calendarInviteSubject) && this.creationTime == object.creationTime && this.defaultProfile.equals(object.defaultProfile) && this.description.equals(object.description) && this.designatedPresenter.equals(object.designatedPresenter) && this.hasCalendarInviteText == object.hasCalendarInviteText && this.hasPassword == object.hasPassword && this.isBroadcastingEnabled == object.isBroadcastingEnabled && this.isLoggingEnabled == object.isLoggingEnabled && this.isLoggingPaused == object.isLoggingPaused && this.isLoggingSupported == object.isLoggingSupported && this.isMembersOnly == object.isMembersOnly && this.isModerated == object.isModerated && this.isPasswordProtected == object.isPasswordProtected && this.isPublic == object.isPublic && this.isSecure == object.isSecure && this.isWaitingRoomEnabled == object.isWaitingRoomEnabled && this.language.equals(object.language) && this.loggingLocation.equals(object.loggingLocation) && this.maxParticipants == object.maxParticipants && this.members.equals(object.members) && this.moderatorUrl.equals(object.moderatorUrl) && this.moderators.equals(object.moderators) && this.name.equals(object.name) && this.outcasts.equals(object.outcasts) && this.owners.equals(object.owners) && this.participantProfiles.equals(object.participantProfiles) && this.password.equals(object.password) && this.schedule.equals(object.schedule) && this.webLink.equals(object.webLink);
            }
            return false;
        }

        public class RoomParticipantProfile {
            public RoomProfileControlMode camera;
            public RoomProfileControlMode chat;
            public RoomProfileControlMode microphone;
            public String userId;
            public RoomProfileControlMode windowShare;

            public boolean equals(Object obj) {
                if (obj instanceof RoomParticipantProfile) {
                    RoomParticipantProfile object = (RoomParticipantProfile)obj;
                    return this.camera == object.camera && this.chat == object.chat && this.microphone == object.microphone && this.userId.equals(object.userId) && this.windowShare == object.windowShare;
                }
                return false;
            }
        }
    }

    public class GenerationDiff {
        public int newIndex;
        public int oldIndex;
        public Participant participant;

        public boolean equals(Object obj) {
            if (obj instanceof GenerationDiff) {
                GenerationDiff object = (GenerationDiff)obj;
                return this.newIndex == object.newIndex && this.oldIndex == object.oldIndex && this.participant.equals(object.participant);
            }
            return false;
        }
    }

    public static interface ISetRoomProperties {
        public void onSetRoomPropertiesResult(RoomSetPropertiesResult var1);
    }

    public static interface ISetFavorite {
        public void onSetFavoriteResult(boolean var1, RoomSetFavoriteResult var2);
    }

    public static interface IRegisterUnprocessedAudioEventListener {
        public void onUnprocessedAudioSupportChanged(boolean var1);

        public void onUnprocessedAudioStarted(boolean var1);
    }

    public static interface IRegisterSubjectEventListener {
        public void onSetSubject(String var1);
    }

    public static interface IRegisterRoomPropertiesEventListener {
        public void onRoomPropertiesChanged(RoomProperties var1);
    }

    public static interface IRegisterResourceManagerEventListener {
        public void onAvailableResourcesChanged(int var1, int var2, int var3, int var4);

        public void onMaxRemoteSourcesChanged(int var1);
    }

    public static interface IRegisterRecorderInCallEventListener {
        public void recorderInCall(boolean var1);
    }

    public static interface IRegisterPipEventListener {
        public void onPipLocationChanged(int var1, int var2, int var3, int var4, boolean var5);
    }

    public static interface IRegisterParticipantEventListener {
        public void onParticipantJoined(Participant var1);

        public void onParticipantLeft(Participant var1);

        public void onDynamicParticipantChanged(ArrayList<Participant> var1);

        public void onLoudestParticipantChanged(Participant var1, boolean var2, boolean var3);
    }

    public static interface IRegisterMessageEventListener {
        public void onMessageReceived(Participant var1, ChatMessage var2);

        public void onMessageAcknowledged(ChatMessage var1);

        public void onMessageRead(Participant var1, long var2);

        public void onMessageTypingIndication(Participant var1, ChatMessage.ChatMessageTypingIndication var2);
    }

    public static interface IMessageSearch {
        public void onMessageSearchResults(String var1, ArrayList<ChatMessage> var2, RoomSearchResult var3);
    }

    public static interface IInvite {
        public void onInviteResult(String var1, RoomInviteResult var2);
    }

    public static interface IGetRoomProperties {
        public void onGetRoomPropertiesResult(RoomGetPropertiesResult var1, RoomProperties var2);
    }

    public static interface IGetHistory {
        public void onGetHistoryResults(ArrayList<ChatMessage> var1, long var2, RoomSearchResult var4);
    }

    public static interface IEnter {
        public void onEntered(RoomEnterResult var1);

        public void onExited(RoomExitReason var1);
    }

    public static interface IEnableMedia {
        public void onMediaEnabled();

        public void onMediaFailed(RoomMediaFailReason var1);

        public void onMediaDisabled(RoomMediaDisableReason var1);
    }

    public static interface IDelete {
        public void onDeleteResult(RoomDeleteResult var1);
    }

    public static interface IAcquireMediaRoute {
        public void onMediaRouteAcquired();

        public void onMediaRouteAcquireFailed(RoomMediaFailReason var1);
    }

    public static interface IAcceptIncoming {
        public void onIncomingEntered(RoomEnterResult var1);

        public void onIncomingExited(RoomExitReason var1);
    }

    public static enum RoomType {
        VIDYO_ROOMTYPE_Unknown,
        VIDYO_ROOMTYPE_Conversation,
        VIDYO_ROOMTYPE_Topic,
        VIDYO_ROOMTYPE_Scheduled,
        VIDYO_ROOMTYPE_Personal,
        VIDYO_ROOMTYPE_TestCall,
        VIDYO_ROOMTYPE_Legacy;

    }

    public static enum RoomState {
        VIDYO_ROOMSTATE_Creating,
        VIDYO_ROOMSTATE_Created,
        VIDYO_ROOMSTATE_Entering,
        VIDYO_ROOMSTATE_Entered,
        VIDYO_ROOMSTATE_MediaRouteAcquiring,
        VIDYO_ROOMSTATE_MediaRouteAcquired,
        VIDYO_ROOMSTATE_MediaEnabling,
        VIDYO_ROOMSTATE_MediaEnabled,
        VIDYO_ROOMSTATE_MediaDisabling,
        VIDYO_ROOMSTATE_MediaDisabled,
        VIDYO_ROOMSTATE_Exiting,
        VIDYO_ROOMSTATE_Exited;

    }

    public static enum RoomSetPropertiesResult {
        VIDYO_ROOMSETPROPERTIESRESULT_OK,
        VIDYO_ROOMSETPROPERTIESRESULT_NoResponse,
        VIDYO_ROOMSETPROPERTIESRESULT_Conflict,
        VIDYO_ROOMSETPROPERTIESRESULT_Unauthorized,
        VIDYO_ROOMSETPROPERTIESRESULT_NotAcceptable,
        VIDYO_ROOMSETPROPERTIESRESULT_NotAllowed,
        VIDYO_ROOMSETPROPERTIESRESULT_MiscLocalError,
        VIDYO_ROOMSETPROPERTIESRESULT_MiscRemoteError;

    }

    public static enum RoomSetFavoriteResult {
        VIDYO_ROOMSETFAVORITERESULT_OK,
        VIDYO_ROOMSETFAVORITERESULT_NoResponse,
        VIDYO_ROOMSETFAVORITERESULT_Conflict,
        VIDYO_ROOMSETFAVORITERESULT_Unauthorized,
        VIDYO_ROOMSETFAVORITERESULT_NotAcceptable,
        VIDYO_ROOMSETFAVORITERESULT_NotAllowed,
        VIDYO_ROOMSETFAVORITERESULT_MiscLocalError,
        VIDYO_ROOMSETFAVORITERESULT_MiscRemoteError;

    }

    public static enum RoomSearchResult {
        VIDYO_ROOMSEARCHRESULT_OK,
        VIDYO_ROOMSEARCHRESULT_NoRecords,
        VIDYO_ROOMSEARCHRESULT_NoResponse,
        VIDYO_ROOMSEARCHRESULT_Unauthorized,
        VIDYO_ROOMSEARCHRESULT_MiscLocalError,
        VIDYO_ROOMSEARCHRESULT_MiscRemoteError;

    }

    public static enum RoomProfileControlMode {
        VIDYO_ROOMPROFILECONTROLMODE_AlwaysOn,
        VIDYO_ROOMPROFILECONTROLMODE_AlwaysOff,
        VIDYO_ROOMPROFILECONTROLMODE_Default;

    }

    public static enum RoomMediaFailReason {
        VIDYO_ROOMMEDIAFAILREASON_Cancelled,
        VIDYO_ROOMMEDIAFAILREASON_NoConference,
        VIDYO_ROOMMEDIAFAILREASON_SignalingConnectionLost,
        VIDYO_ROOMMEDIAFAILREASON_MediaConnectionLost,
        VIDYO_ROOMMEDIAFAILREASON_NoResponse,
        VIDYO_ROOMMEDIAFAILREASON_InvalidPassword,
        VIDYO_ROOMMEDIAFAILREASON_RoomIsFull,
        VIDYO_ROOMMEDIAFAILREASON_InvalidRoomKey,
        VIDYO_ROOMMEDIAFAILREASON_RoomDisabled,
        VIDYO_ROOMMEDIAFAILREASON_AllLinesInUse,
        VIDYO_ROOMMEDIAFAILREASON_ConnectionError,
        VIDYO_ROOMMEDIAFAILREASON_InvalidRoom,
        VIDYO_ROOMMEDIAFAILREASON_ConferenceLocked,
        VIDYO_ROOMMEDIAFAILREASON_SeatLicenseExpired,
        VIDYO_ROOMMEDIAFAILREASON_NotLicensed,
        VIDYO_ROOMMEDIAFAILREASON_Rejected,
        VIDYO_ROOMMEDIAFAILREASON_UnknownError,
        VIDYO_ROOMMEDIAFAILREASON_MiscLocalError,
        VIDYO_ROOMMEDIAFAILREASON_MiscRemoteError;

    }

    public static enum RoomMediaDisableReason {
        VIDYO_ROOMMEDIADISABLEREASON_Disabled,
        VIDYO_ROOMMEDIADISABLEREASON_SignalingConnectionLost,
        VIDYO_ROOMMEDIADISABLEREASON_MediaConnectionLost,
        VIDYO_ROOMMEDIADISABLEREASON_Booted,
        VIDYO_ROOMMEDIADISABLEREASON_SessionTerminated,
        VIDYO_ROOMMEDIADISABLEREASON_ServerShuttingDown,
        VIDYO_ROOMMEDIADISABLEREASON_ConferenceDestroyed,
        VIDYO_ROOMMEDIADISABLEREASON_MiscLocalError,
        VIDYO_ROOMMEDIADISABLEREASON_MiscRemoteError;

    }

    public static enum RoomInviteResult {
        VIDYO_ROOMINVITERESULT_OK,
        VIDYO_ROOMINVITERESULT_NoResponse,
        VIDYO_ROOMINVITERESULT_Unauthorized,
        VIDYO_ROOMINVITERESULT_OutOfResources,
        VIDYO_ROOMINVITERESULT_MiscError,
        VIDYO_ROOMINVITERESULT_UserIsOffline,
        VIDYO_ROOMINVITERESULT_ServerError;

    }

    public static enum RoomGetPropertiesResult {
        VIDYO_ROOMGETPROPERTIESRESULT_OK,
        VIDYO_ROOMGETPROPERTIESRESULT_NoResponse,
        VIDYO_ROOMGETPROPERTIESRESULT_Unauthorized,
        VIDYO_ROOMGETPROPERTIESRESULT_MiscLocalError,
        VIDYO_ROOMGETPROPERTIESRESULT_MiscRemoteError;

    }

    public static enum RoomExitReason {
        VIDYO_ROOMEXITREASON_Left,
        VIDYO_ROOMEXITREASON_ConnectionLost,
        VIDYO_ROOMEXITREASON_SessionConnectionLost,
        VIDYO_ROOMEXITREASON_MembershipConnectionLost,
        VIDYO_ROOMEXITREASON_NoResponse,
        VIDYO_ROOMEXITREASON_ProtocolViolation,
        VIDYO_ROOMEXITREASON_Booted,
        VIDYO_ROOMEXITREASON_ShuttingDown,
        VIDYO_ROOMEXITREASON_MiscLocalError,
        VIDYO_ROOMEXITREASON_MiscRemoteError;

    }

    public static enum RoomEnterResult {
        VIDYO_ROOMENTERRESULT_OK,
        VIDYO_ROOMENTERRESULT_Cancelled,
        VIDYO_ROOMENTERRESULT_NoResponse,
        VIDYO_ROOMENTERRESULT_InvalidPassword,
        VIDYO_ROOMENTERRESULT_UnknownRoom,
        VIDYO_ROOMENTERRESULT_RoomFull,
        VIDYO_ROOMENTERRESULT_NotMember,
        VIDYO_ROOMENTERRESULT_Banned,
        VIDYO_ROOMENTERRESULT_MiscLocalError,
        VIDYO_ROOMENTERRESULT_MiscRemoteError;

    }

    public static enum RoomDeleteResult {
        VIDYO_ROOMDELETERESULT_OK,
        VIDYO_ROOMDELETERESULT_NoResponse,
        VIDYO_ROOMDELETERESULT_Unauthorized,
        VIDYO_ROOMDELETERESULT_OutOfResources,
        VIDYO_ROOMDELETERESULT_MiscError;

    }
}

