/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.NetworkService;

import com.vidyo.VidyoClient.NetworkService.NetworkServiceCAInfo;

public class NetworkService {
    private long objPtr;
    private IHttpRequestASync HttpRequestASync;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native long constructNative(NetworkServiceCAInfo var1);

    private native long constructCopyNative(long var1);

    private native void destructNative(long var1);

    private native NetworkServiceErrorCode httpRequestASyncNative(long var1, NetworkServiceRequestHeader var3, long var4);

    public NetworkService(NetworkServiceCAInfo caInfo) {
        this.objPtr = this.constructNative(caInfo);
    }

    public NetworkService(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void responseCB(NetworkServiceResponseHeader httpResponseHeader, long userData) {
        if (this.HttpRequestASync != null) {
            this.HttpRequestASync.responseCB(httpResponseHeader, userData);
        }
    }

    public NetworkServiceErrorCode httpRequestASync(NetworkServiceRequestHeader data, IHttpRequestASync HttpRequestASync, long userData) {
        this.HttpRequestASync = HttpRequestASync;
        return this.httpRequestASyncNative(this.objPtr, data, userData);
    }

    public class NetworkServiceResponseHeader {
        public NetworkServiceErrorCode errorCode = NetworkServiceErrorCode.values()[0];
        public String httpResponseContent = new String();
        public int httpResponseContentSize;
        public String httpResponseContentType = new String();
        public int httpStatusCode;
        public String requestNumber = new String();
        public String webProxyIPAddress = new String();
        public int webProxyIPPort;

        public boolean equals(Object obj) {
            if (obj instanceof NetworkServiceResponseHeader) {
                NetworkServiceResponseHeader object = (NetworkServiceResponseHeader)obj;
                return this.errorCode == object.errorCode && this.httpResponseContent.equals(object.httpResponseContent) && this.httpResponseContentSize == object.httpResponseContentSize && this.httpResponseContentType.equals(object.httpResponseContentType) && this.httpStatusCode == object.httpStatusCode && this.requestNumber.equals(object.requestNumber) && this.webProxyIPAddress.equals(object.webProxyIPAddress) && this.webProxyIPPort == object.webProxyIPPort;
            }
            return false;
        }
    }

    public class NetworkServiceRequestHeader {
        public String requestContentType = new String();
        public String requestMethod = new String();
        public String requestNumber = new String();
        public String requestPayload = new String();
        public String requestUrl = new String();
        public String userAuthToken = new String();
        public String userAuthUserName = new String();
        public String userAuthUserPassword = new String();
        public String webProxyUserName = new String();
        public String webProxyUserPassword = new String();

        public boolean equals(Object obj) {
            if (obj instanceof NetworkServiceRequestHeader) {
                NetworkServiceRequestHeader object = (NetworkServiceRequestHeader)obj;
                return this.requestContentType.equals(object.requestContentType) && this.requestMethod.equals(object.requestMethod) && this.requestNumber.equals(object.requestNumber) && this.requestPayload.equals(object.requestPayload) && this.requestUrl.equals(object.requestUrl) && this.userAuthToken.equals(object.userAuthToken) && this.userAuthUserName.equals(object.userAuthUserName) && this.userAuthUserPassword.equals(object.userAuthUserPassword) && this.webProxyUserName.equals(object.webProxyUserName) && this.webProxyUserPassword.equals(object.webProxyUserPassword);
            }
            return false;
        }
    }

    public static interface IHttpRequestASync {
        public void responseCB(NetworkServiceResponseHeader var1, long var2);
    }

    public static enum NetworkServiceErrorCode {
        VIDYO_NETWORKSERVICE_ERRORCODE_Ok,
        VIDYO_NETWORKSERVICE_ERRORCODE_Error,
        VIDYO_NETWORKSERVICE_ERRORCODE_MandatoryParamsMissing,
        VIDYO_NETWORKSERVICE_ERRORCODE_BadRequest,
        VIDYO_NETWORKSERVICE_ERRORCODE_MaxSimultaneousRequestsReached,
        VIDYO_NETWORKSERVICE_ERRORCODE_HttpRequestTimeOut;

    }
}

