/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.content.Context;
import android.util.Log;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerCamera2;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerCapability;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerInternal;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerManager;
import com.vidyo.LmiDeviceManager.LmiVideoFrame;

public abstract class LmiVideoCapturer {
    static String TAG = "LmiVideoCapturer";
    private long nativePtr;
    private boolean cameraStarted = false;
    public final int LMI_VIDEOCAPTURER_TORCHMODE_Off = 0;
    public final int LMI_VIDEOCAPTURER_TORCHMODE_On = 1;
    public final int LMI_VIDEOCAPTURER_TORCHMODE_Auto = 2;
    public final int LMI_VIDEOCAPTURER_POSITION_Front = 0;
    public final int LMI_VIDEOCAPTURER_POSITION_Back = 1;

    public static LmiVideoCapturer GetCapturer(Context context, String id, long nativePtr) {
        try {
            if (LmiVideoCapturerManager.useCamera2()) {
                try {
                    return new LmiVideoCapturerCamera2(context, id, nativePtr);
                }
                catch (CameraNotSupportedException e) {
                    return new LmiVideoCapturerInternal(context, id, nativePtr);
                }
            }
            return new LmiVideoCapturerInternal(context, id, nativePtr);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception constructing LmiVideoCapturer", (Throwable)e);
            return null;
        }
    }

    LmiVideoCapturer(long nativeP) {
        this.nativePtr = nativeP;
    }

    public abstract LmiVideoCapturerCapability[] getCapabilities();

    public abstract LmiVideoCapturerCapability[] getCapabilitiesCapture();

    public LmiVideoCapturerCapability[] getCapabilities(boolean picFormat) {
        Log.i((String)TAG, (String)("getCapabilities(" + (picFormat ? "picture" : "video") + ")"));
        if (!picFormat) {
            return this.getCapabilities();
        }
        return this.getCapabilitiesCapture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(String format, int width, int height, long frameInterval, boolean startVideo, boolean startVideoWhileInPictureCapture, int pictureWidth, int pictureHeight, int maxNumberOfPictures) {
        Log.i((String)TAG, (String)("start format: " + format + " width: " + width + " height: " + height + " frameinterval: " + frameInterval));
        LmiVideoCapturer lmiVideoCapturer = this;
        synchronized (lmiVideoCapturer) {
            if (!startVideoWhileInPictureCapture && this.cameraStarted) {
                return true;
            }
            this.cameraStarted = this.startInternal(format, width, height, frameInterval, startVideo, pictureWidth, pictureHeight, maxNumberOfPictures);
        }
        if (!this.cameraStarted) {
            Log.i((String)TAG, (String)"Failed to start camera");
        }
        return this.cameraStarted;
    }

    public abstract boolean startInternal(String var1, int var2, int var3, long var4, boolean var6, int var7, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean stopPictureAndVideo) {
        Log.i((String)TAG, (String)"Stop");
        LmiVideoCapturer lmiVideoCapturer = this;
        synchronized (lmiVideoCapturer) {
            if (!this.cameraStarted) {
                return;
            }
            this.stopInternal(stopPictureAndVideo);
            if (stopPictureAndVideo) {
                this.cameraStarted = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTorch() {
        boolean r;
        Log.i((String)TAG, (String)"hasTorch");
        LmiVideoCapturer lmiVideoCapturer = this;
        synchronized (lmiVideoCapturer) {
            r = this.hasTorchInternal();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTorchModeSupported(int mode) {
        boolean r;
        Log.i((String)TAG, (String)"isTorchModeSupported");
        LmiVideoCapturer lmiVideoCapturer = this;
        synchronized (lmiVideoCapturer) {
            r = this.isTorchModeSupportedInternal(mode);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTorchMode() {
        int mode;
        Log.i((String)TAG, (String)"getTorchMode");
        LmiVideoCapturer lmiVideoCapturer = this;
        synchronized (lmiVideoCapturer) {
            mode = this.getTorchModeInternal();
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTorchMode(int mode) {
        Log.i((String)TAG, (String)"setTorchMode");
        LmiVideoCapturer lmiVideoCapturer = this;
        synchronized (lmiVideoCapturer) {
            this.setTorchModeInternal(mode);
        }
    }

    public abstract void stopInternal(boolean var1);

    public abstract boolean hasTorchInternal();

    public abstract boolean isTorchModeSupportedInternal(int var1);

    public abstract int getTorchModeInternal();

    public abstract void setTorchModeInternal(int var1);

    public abstract int getOrientation();

    public abstract int getFacing();

    public abstract boolean getMirrored();

    public abstract String getName();

    public abstract void releaseFrame(LmiVideoFrame var1);

    void frameReceived(LmiVideoFrame frame) {
        if (this.nativePtr != 0L) {
            this.nativeFrameReceived(this.nativePtr, frame);
        }
    }

    native void nativeFrameReceived(long var1, LmiVideoFrame var3);

    void notifyDisconnected() {
        if (this.nativePtr != 0L) {
            this.nativeNotifyDisconnected(this.nativePtr);
        }
    }

    native void nativeNotifyDisconnected(long var1);

    void notifyError(String desc) {
        if (this.nativePtr != 0L) {
            this.nativeNotifyError(this.nativePtr, desc);
        }
    }

    native void nativeNotifyError(long var1, String var3);

    public boolean capturePicture(int picQuality, int picFlashMode) {
        boolean output = false;
        Log.i((String)TAG, (String)"capturePicture");
        output = this.CapturePicture(picQuality, picFlashMode);
        return output;
    }

    public abstract boolean CapturePicture(int var1, int var2);

    void pictureReceived(LmiVideoFrame frame) {
        Log.i((String)TAG, (String)"pictureReceived");
        if (this.nativePtr != 0L) {
            this.nativePictureReceived(this.nativePtr, frame);
        }
    }

    native void nativePictureReceived(long var1, LmiVideoFrame var3);

    void pictureReceivedStop() {
        Log.i((String)TAG, (String)"pictureReceivedStop");
        if (this.nativePtr != 0L) {
            this.nativePictureReceivedStop(this.nativePtr);
        }
    }

    native void nativePictureReceivedStop(long var1);

    static class CameraNotSupportedException
    extends Exception {
        CameraNotSupportedException() {
        }
    }
}

