/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Endpoint;

import com.vidyo.VidyoClient.Endpoint.ChatMessage;
import com.vidyo.VidyoClient.Endpoint.Participant;
import com.vidyo.VidyoClient.Endpoint.User;

public class Call {
    private long objPtr;
    public String id = new String();
    private IAccept Accept;
    private IRegisterMessageEventListener RegisterMessageEventListener;
    private IRegisterSubjectEventListener RegisterSubjectEventListener;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native boolean acceptNative(long var1);

    private native long constructCopyNative(long var1);

    private native void destructNative(long var1);

    private native String getIdNative(long var1);

    private native String getSubjectNative(long var1);

    private native User getUserNative(long var1);

    private native void hangUpNative(long var1);

    private native boolean initiateNative(long var1);

    private native boolean registerMessageEventListenerNative(long var1);

    private native boolean registerSubjectEventListenerNative(long var1);

    private native void rejectNative(long var1);

    private native boolean sendMessageNative(long var1, String var3);

    private native boolean setSubjectNative(long var1, String var3);

    public Call(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void onEnded(Participant p, CallEndReason reason) {
        if (this.Accept != null) {
            this.Accept.onEnded(p, reason);
        }
    }

    public void onInitiated(CallInitiatedResult result, Participant p) {
        if (this.Accept != null) {
            this.Accept.onInitiated(result, p);
        }
    }

    public void onMessageAcknowledged(ChatMessage chatMessage) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageAcknowledged(chatMessage);
        }
    }

    public void onMessageRead(Participant participant, long messageId) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageRead(participant, messageId);
        }
    }

    public void onMessageReceived(Participant participant, ChatMessage chatMessage) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageReceived(participant, chatMessage);
        }
    }

    public void onMessageTypingIndication(Participant participant, ChatMessage.ChatMessageTypingIndication typingIndication) {
        if (this.RegisterMessageEventListener != null) {
            this.RegisterMessageEventListener.onMessageTypingIndication(participant, typingIndication);
        }
    }

    public void onSetSubject(String subject) {
        if (this.RegisterSubjectEventListener != null) {
            this.RegisterSubjectEventListener.onSetSubject(subject);
        }
    }

    public boolean accept(IAccept Accept) {
        this.Accept = Accept;
        return this.acceptNative(this.objPtr);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public String getSubject() {
        return this.getSubjectNative(this.objPtr);
    }

    public User getUser() {
        return this.getUserNative(this.objPtr);
    }

    public void hangUp() {
        this.hangUpNative(this.objPtr);
    }

    public boolean initiate(IAccept Accept) {
        this.Accept = Accept;
        return this.initiateNative(this.objPtr);
    }

    public boolean registerMessageEventListener(IRegisterMessageEventListener RegisterMessageEventListener) {
        this.RegisterMessageEventListener = RegisterMessageEventListener;
        return this.registerMessageEventListenerNative(this.objPtr);
    }

    public boolean registerSubjectEventListener(IRegisterSubjectEventListener RegisterSubjectEventListener) {
        this.RegisterSubjectEventListener = RegisterSubjectEventListener;
        return this.registerSubjectEventListenerNative(this.objPtr);
    }

    public void reject() {
        this.rejectNative(this.objPtr);
    }

    public boolean sendMessage(String message) {
        return this.sendMessageNative(this.objPtr, message);
    }

    public boolean setSubject(String subject) {
        return this.setSubjectNative(this.objPtr, subject);
    }

    public static interface IRegisterSubjectEventListener {
        public void onSetSubject(String var1);
    }

    public static interface IRegisterMessageEventListener {
        public void onMessageReceived(Participant var1, ChatMessage var2);

        public void onMessageAcknowledged(ChatMessage var1);

        public void onMessageRead(Participant var1, long var2);

        public void onMessageTypingIndication(Participant var1, ChatMessage.ChatMessageTypingIndication var2);
    }

    public static interface IAccept {
        public void onInitiated(CallInitiatedResult var1, Participant var2);

        public void onEnded(Participant var1, CallEndReason var2);
    }

    public static enum CallInitiatedResult {
        VIDYO_CALLINITIATEDRESULT_OK,
        VIDYO_CALLINITIATEDRESULT_Cancelled,
        VIDYO_CALLINITIATEDRESULT_NoResponse,
        VIDYO_CALLINITIATEDRESULT_UnknownParticipant,
        VIDYO_CALLINITIATEDRESULT_MiscLocalError,
        VIDYO_CALLINITIATEDRESULT_MiscRemoteError;

    }

    public static enum CallEndReason {
        VIDYO_CALLENDREASON_Ended,
        VIDYO_CALLENDREASON_ConnectionFailed,
        VIDYO_CALLENDREASON_ConnectionLost,
        VIDYO_CALLENDREASON_ParticipantBusy,
        VIDYO_CALLENDREASON_ParticipantRejected,
        VIDYO_CALLENDREASON_ParticipantEnded,
        VIDYO_CALLENDREASON_MiscError;

    }
}

