/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Display;
import com.vidyo.LmiDeviceManager.LmiScreenManager;
import java.nio.ByteBuffer;

public class LmiScreenManagerJellybeanListener {
    private static final String TAG = "LmiScreenManagerListenerJava";

    public static LmiScreenManager.LmiScreenManagerListener newInstance(Context context, ByteBuffer pointerwrapper, LmiScreenManager mgr) {
        LmiJellyBeanMR1Listener listener = null;
        listener = new LmiJellyBeanMR1Listener(context, pointerwrapper, mgr);
        return listener;
    }

    @TargetApi(value=17)
    private static class LmiJellyBeanMR1Listener
    implements DisplayManager.DisplayListener,
    LmiScreenManager.LmiScreenManagerListener {
        private ByteBuffer pointerwrapper;
        private LmiScreenManager mgr;
        private DisplayManager displayManager;
        private Handler messageHandler;

        public LmiJellyBeanMR1Listener(Context context, ByteBuffer pointerwrapper, LmiScreenManager mgr) {
            this.pointerwrapper = pointerwrapper;
            this.mgr = mgr;
            this.displayManager = (DisplayManager)context.getApplicationContext().getSystemService("display");
            if (this.displayManager == null) {
                throw new NullPointerException("DISPLAY_SERVICE not found");
            }
            Log.d((String)LmiScreenManagerJellybeanListener.TAG, (String)"LmiJellyBeanMR1Listener constructed in java");
        }

        public void onDisplayAdded(int arg0) {
            Log.d((String)LmiScreenManagerJellybeanListener.TAG, (String)"LmiScreenManager display added in java");
            this.mgr.getDisplays();
            this.mgr.displayAdded(arg0, this.pointerwrapper);
        }

        public void onDisplayChanged(int arg0) {
            Log.d((String)LmiScreenManagerJellybeanListener.TAG, (String)"LmiScreenManager display changed in java");
            this.mgr.getDisplays();
            this.mgr.displayChanged(arg0, this.pointerwrapper);
        }

        public void onDisplayRemoved(int arg0) {
            Log.d((String)LmiScreenManagerJellybeanListener.TAG, (String)"LmiScreenManager display removed in java");
            this.mgr.getDisplays();
            this.mgr.displayRemoved(arg0, this.pointerwrapper);
        }

        @Override
        @TargetApi(value=17)
        public boolean start() {
            if (Looper.myLooper() == null && this.messageHandler == null) {
                this.messageHandler = new Handler(Looper.getMainLooper());
            }
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, this.messageHandler);
            return true;
        }

        @Override
        @TargetApi(value=17)
        public void stop() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        @Override
        @TargetApi(value=17)
        public Display[] getDisplays() {
            Display[] displays = this.displayManager.getDisplays();
            return displays;
        }

        @Override
        @TargetApi(value=17)
        public int getRealWidth(int displayId) {
            Display d = this.mgr.getDisplay(displayId);
            if (d == null) {
                return 0;
            }
            Point p = new Point();
            d.getRealSize(p);
            return p.x;
        }

        @Override
        @TargetApi(value=17)
        public String getName(int displayId) {
            Display d = this.mgr.getDisplay(displayId);
            if (d == null) {
                return new String("Null Screen");
            }
            return d.getName();
        }

        @Override
        @TargetApi(value=17)
        public int getRealHeight(int displayId) {
            Display d = this.mgr.getDisplay(displayId);
            if (d == null) {
                return 0;
            }
            Point p = new Point();
            d.getRealSize(p);
            return p.y;
        }
    }
}

