/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.VidyoClient.Endpoint;

import com.vidyo.VidyoClient.Endpoint.Call;
import com.vidyo.VidyoClient.Endpoint.Contact;
import com.vidyo.VidyoClient.Endpoint.ContactInfo;
import com.vidyo.VidyoClient.Endpoint.Endpoint;
import com.vidyo.VidyoClient.Endpoint.Property;
import com.vidyo.VidyoClient.Endpoint.Room;
import com.vidyo.VidyoClient.Endpoint.RoomInfo;
import com.vidyo.VidyoClient.EventSchedule;
import com.vidyo.VidyoClient.Stats.UserStats;
import java.util.ArrayList;

public class User {
    private long objPtr;
    private IAdvancedSearchRooms AdvancedSearchRooms;
    private IAdvancedSearchUsers AdvancedSearchUsers;
    private ICreateCall CreateCall;
    private ICreateRoomFromId CreateRoomFromId;
    private IGetAuthTypes GetAuthTypes;
    private IGetContact GetContact;
    private IGetFavoriteRooms GetFavoriteRooms;
    private IGetPasswordResetUrl GetPasswordResetUrl;
    private IGetRecentRooms GetRecentRooms;
    private ILogin Login;
    private IRegisterCallEventListener RegisterCallEventListener;
    private IRegisterContactEventListener RegisterContactEventListener;
    private IRegisterLicenseEventListener RegisterLicenseEventListener;
    private IRegisterRoomEventListener RegisterRoomEventListener;

    public long GetObjectPtr() {
        return this.objPtr;
    }

    private native boolean addRosterContactNative(long var1, String var3);

    private native boolean advancedSearchRoomsNative(long var1, ArrayList<RoomSearchField> var3, ArrayList<RoomSearchFieldRelation> var4, ArrayList<String> var5, String var6, int var7, int var8);

    private native boolean advancedSearchUsersNative(long var1, ArrayList<UserSearchField> var3, ArrayList<String> var4, String var5, int var6, int var7);

    private native boolean allowSubscriberNative(long var1, String var3);

    private native boolean blockSubscriberNative(long var1, String var3);

    private native long constructNative(Endpoint var1);

    private native long constructCopyNative(long var1);

    private native boolean createCallNative(long var1, String var3, String var4);

    private native boolean createRoomFromIdNative(long var1, String var3, String var4);

    private native boolean createRoomFromKeyNative(long var1, String var3, String var4);

    private native boolean createRoomWithIdNative(long var1, String var3, String var4);

    private native boolean createScheduledRoomNative(long var1, EventSchedule var3, String var4);

    private native boolean createTestCallRoomNative(long var1, String var3);

    private native boolean createTopicRoomNative(long var1, String var3, String var4, String var5);

    private native void destructNative(long var1);

    private native boolean getAuthTypesNative(long var1, String var3, int var4, String var5);

    private native boolean getContactNative(long var1, String var3);

    private native boolean getConversationRoomNative(long var1, ArrayList<String> var3, String var4);

    private native boolean getCurrentRosterNative(long var1, ArrayList<Contact> var3);

    private native Endpoint getEndpointNative(long var1);

    private native boolean getFavoriteRoomsNative(long var1, int var3, int var4);

    private native String getIdNative(long var1);

    private native boolean getPasswordResetUrlNative(long var1);

    private native boolean getRecentRoomsNative(long var1, int var3, int var4);

    private native boolean getStatsNative(long var1, UserStats var3);

    private native String getWebProxyAddressNative(long var1);

    private native boolean invalidateTokenOnLogoutNative(long var1, boolean var3);

    private native boolean loginNative(long var1, String var3, String var4, String var5, int var6, String var7);

    private native boolean loginAsGuestNative(long var1, String var3, String var4, String var5, int var6, String var7);

    private native boolean loginWithAccessTokenNative(long var1, String var3, String var4, int var5, String var6);

    private native boolean loginWithCACNative(long var1, String var3, String var4, int var5, String var6);

    private native boolean loginWithRefreshTokenNative(long var1, String var3, String var4, int var5, String var6);

    private native boolean loginWithSAMLNative(long var1, String var3, String var4, int var5, String var6);

    private native boolean loginWithTenantTokenNative(long var1, String var3, String var4, int var5, String var6);

    private native boolean logoutNative(long var1);

    private native boolean pauseUpdateNotificationNative(long var1, boolean var3);

    private native boolean registerCallEventListenerNative(long var1);

    private native boolean registerContactEventListenerNative(long var1);

    private native boolean registerLicenseEventListenerNative(long var1);

    private native boolean registerRoomEventListenerNative(long var1);

    private native boolean removeRosterContactNative(long var1, String var3);

    private native boolean searchConversationRoomsNative(long var1, String var3, int var4, int var5);

    private native boolean searchRoomsNative(long var1, String var3, int var4, int var5);

    private native boolean searchRoomsWithNameNative(long var1, String var3, int var4, int var5);

    private native boolean searchRoomsWithOwnerNative(long var1, String var3, int var4, int var5);

    private native boolean searchRoomsWithSubjectNative(long var1, String var3, int var4, int var5);

    private native boolean searchTopicRoomsNative(long var1, String var3, int var4, int var5);

    private native boolean searchUsersNative(long var1, String var3, int var4, int var5);

    private native void setCANative(long var1, String var3, String var4, String var5);

    private native boolean setDisplayNameNative(long var1, String var3);

    private native void setTCPTransportNative(long var1, boolean var3);

    private native void setUDPTransportNative(long var1, boolean var3);

    private native void setWebProxyAddressCredentialsNative(long var1, String var3, String var4, String var5);

    private native void setWebProxyTransportNative(long var1, boolean var3);

    private native void setWebProxyTransportAddressNative(long var1, String var3, int var4);

    private native boolean unregisterCallEventListenerNative(long var1);

    private native boolean unregisterContactEventListenerNative(long var1);

    private native boolean unregisterLicenseEventListenerNative(long var1);

    private native boolean unregisterRoomEventListenerNative(long var1);

    private native boolean updatePresenceNative(long var1, Contact.ContactPresenceState var3, String var4);

    public User(Endpoint endpoint) {
        this.objPtr = this.constructNative(endpoint);
    }

    public User(long rPtr) {
        this.objPtr = this.constructCopyNative(rPtr);
    }

    protected void dispose() {
        if (this.objPtr != 0L) {
            this.destructNative(this.objPtr);
        }
        this.objPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void onAuthTypes(UserGetAuthTypesResult result, ArrayList<UserAuthenticationInfo> authTypes) {
        if (this.GetAuthTypes != null) {
            this.GetAuthTypes.onAuthTypes(result, authTypes);
        }
    }

    public void onAuthTypesWebProxyCredentialsRequest(String webProxyAddress) {
        if (this.GetAuthTypes != null) {
            this.GetAuthTypes.onAuthTypesWebProxyCredentialsRequest(webProxyAddress);
        }
    }

    public void onCallCreated(Call call, UserCallCreateResult result, String createToken) {
        if (this.CreateCall != null) {
            this.CreateCall.onCallCreated(call, result, createToken);
        }
    }

    public void onCallCreatedByInvite(Call call, Contact inviter) {
        if (this.RegisterCallEventListener != null) {
            this.RegisterCallEventListener.onCallCreatedByInvite(call, inviter);
        }
    }

    public void onConnectionStatusChanged(UserConnectionStatusChangedReason reason) {
        if (this.Login != null) {
            this.Login.onConnectionStatusChanged(reason);
        }
    }

    public void onFavoriteRoomResults(UserSearchResult searchResult, ArrayList<RoomInfo> roomInfo) {
        if (this.GetFavoriteRooms != null) {
            this.GetFavoriteRooms.onFavoriteRoomResults(searchResult, roomInfo);
        }
    }

    public void onGetContactResult(Contact contact, UserGetContactResult result) {
        if (this.GetContact != null) {
            this.GetContact.onGetContactResult(contact, result);
        }
    }

    public void onGetLicenseKey(String licenseKey) {
        if (this.RegisterLicenseEventListener != null) {
            this.RegisterLicenseEventListener.onGetLicenseKey(licenseKey);
        }
    }

    public void onLicenseReceived(String licenseKey) {
        if (this.RegisterLicenseEventListener != null) {
            this.RegisterLicenseEventListener.onLicenseReceived(licenseKey);
        }
    }

    public void onLoggedOut(UserLogoutReason reason) {
        if (this.Login != null) {
            this.Login.onLoggedOut(reason);
        }
    }

    public void onLoginComplete(UserLoginResult result, boolean secure, TenantCapabilities capabilities) {
        if (this.Login != null) {
            this.Login.onLoginComplete(result, secure, capabilities);
        }
    }

    public void onPasswordResetUrl(String passwordResetUrl) {
        if (this.GetPasswordResetUrl != null) {
            this.GetPasswordResetUrl.onPasswordResetUrl(passwordResetUrl);
        }
    }

    public void onRecentRoomResults(UserSearchResult searchResult, ArrayList<RoomInfo> roomInfo) {
        if (this.GetRecentRooms != null) {
            this.GetRecentRooms.onRecentRoomResults(searchResult, roomInfo);
        }
    }

    public void onRemoveRosterContact(String uri) {
        if (this.RegisterContactEventListener != null) {
            this.RegisterContactEventListener.onRemoveRosterContact(uri);
        }
    }

    public void onRoomCreated(Room room, UserRoomCreateResult result, String createToken) {
        if (this.CreateRoomFromId != null) {
            this.CreateRoomFromId.onRoomCreated(room, result, createToken);
        }
    }

    public void onRoomCreatedByInvite(Room room, Contact inviter, String message) {
        if (this.RegisterRoomEventListener != null) {
            this.RegisterRoomEventListener.onRoomCreatedByInvite(room, inviter, message);
        }
    }

    public void onRoomInviteCancelled(RoomInfo roomInfo, String message) {
        if (this.RegisterRoomEventListener != null) {
            this.RegisterRoomEventListener.onRoomInviteCancelled(roomInfo, message);
        }
    }

    public void onRoomSearchResults(String searchText, UserSearchResult searchResult, ArrayList<RoomInfo> roomInfo, long numRecords) {
        if (this.AdvancedSearchRooms != null) {
            this.AdvancedSearchRooms.onRoomSearchResults(searchText, searchResult, roomInfo, numRecords);
        }
    }

    public void onTokenReceived(String token, UserTokenType tokenType) {
        if (this.Login != null) {
            this.Login.onTokenReceived(token, tokenType);
        }
    }

    public void onUpdateRosterContact(Contact contact) {
        if (this.RegisterContactEventListener != null) {
            this.RegisterContactEventListener.onUpdateRosterContact(contact);
        }
    }

    public void onUpdateSelf(Contact contact) {
        if (this.RegisterContactEventListener != null) {
            this.RegisterContactEventListener.onUpdateSelf(contact);
        }
    }

    public void onUserSearchResults(String searchText, UserSearchResult searchResult, ArrayList<ContactInfo> contacts, long numRecords) {
        if (this.AdvancedSearchUsers != null) {
            this.AdvancedSearchUsers.onUserSearchResults(searchText, searchResult, contacts, numRecords);
        }
    }

    public void onWebProxyCredentialsRequest(String webProxyAddress) {
        if (this.Login != null) {
            this.Login.onWebProxyCredentialsRequest(webProxyAddress);
        }
    }

    public boolean addRosterContact(String userId) {
        return this.addRosterContactNative(this.objPtr, userId);
    }

    public boolean advancedSearchRooms(ArrayList<RoomSearchField> fieldSet, ArrayList<RoomSearchFieldRelation> fieldRelations, ArrayList<String> fieldValues, String searchToken, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.advancedSearchRoomsNative(this.objPtr, fieldSet, fieldRelations, fieldValues, searchToken, index, pageSize);
    }

    public boolean advancedSearchUsers(ArrayList<UserSearchField> fieldSet, ArrayList<String> fieldValues, String searchToken, int index, int pageSize, IAdvancedSearchUsers AdvancedSearchUsers) {
        this.AdvancedSearchUsers = AdvancedSearchUsers;
        return this.advancedSearchUsersNative(this.objPtr, fieldSet, fieldValues, searchToken, index, pageSize);
    }

    public boolean allowSubscriber(String userId) {
        return this.allowSubscriberNative(this.objPtr, userId);
    }

    public boolean blockSubscriber(String userId) {
        return this.blockSubscriberNative(this.objPtr, userId);
    }

    public boolean createCall(String userId, String createToken, ICreateCall CreateCall) {
        this.CreateCall = CreateCall;
        return this.createCallNative(this.objPtr, userId, createToken);
    }

    public boolean createRoomFromId(String id, String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.createRoomFromIdNative(this.objPtr, id, createToken);
    }

    public boolean createRoomFromKey(String roomKey, String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.createRoomFromKeyNative(this.objPtr, roomKey, createToken);
    }

    public boolean createRoomWithId(String id, String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.createRoomWithIdNative(this.objPtr, id, createToken);
    }

    public boolean createScheduledRoom(EventSchedule schedule, String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.createScheduledRoomNative(this.objPtr, schedule, createToken);
    }

    public boolean createTestCallRoom(String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.createTestCallRoomNative(this.objPtr, createToken);
    }

    public boolean createTopicRoom(String name, String description, String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.createTopicRoomNative(this.objPtr, name, description, createToken);
    }

    public boolean getAuthTypes(String host, int port, String serviceType, IGetAuthTypes GetAuthTypes) {
        this.GetAuthTypes = GetAuthTypes;
        return this.getAuthTypesNative(this.objPtr, host, port, serviceType);
    }

    public boolean getContact(String userId, IGetContact GetContact) {
        this.GetContact = GetContact;
        return this.getContactNative(this.objPtr, userId);
    }

    public boolean getConversationRoom(ArrayList<String> userIds, String createToken, ICreateRoomFromId CreateRoomFromId) {
        this.CreateRoomFromId = CreateRoomFromId;
        return this.getConversationRoomNative(this.objPtr, userIds, createToken);
    }

    public boolean getCurrentRoster(ArrayList<Contact> roster) {
        return this.getCurrentRosterNative(this.objPtr, roster);
    }

    public Endpoint getEndpoint() {
        return this.getEndpointNative(this.objPtr);
    }

    public boolean getFavoriteRooms(int index, int pageSize, IGetFavoriteRooms GetFavoriteRooms) {
        this.GetFavoriteRooms = GetFavoriteRooms;
        return this.getFavoriteRoomsNative(this.objPtr, index, pageSize);
    }

    public String getId() {
        return this.getIdNative(this.objPtr);
    }

    public boolean getPasswordResetUrl(IGetPasswordResetUrl GetPasswordResetUrl) {
        this.GetPasswordResetUrl = GetPasswordResetUrl;
        return this.getPasswordResetUrlNative(this.objPtr);
    }

    public boolean getRecentRooms(int index, int pageSize, IGetRecentRooms GetRecentRooms) {
        this.GetRecentRooms = GetRecentRooms;
        return this.getRecentRoomsNative(this.objPtr, index, pageSize);
    }

    public boolean getStats(UserStats stats) {
        return this.getStatsNative(this.objPtr, stats);
    }

    public String getWebProxyAddress() {
        return this.getWebProxyAddressNative(this.objPtr);
    }

    public boolean invalidateTokenOnLogout(boolean invalidate) {
        return this.invalidateTokenOnLogoutNative(this.objPtr, invalidate);
    }

    public boolean login(String username, String password, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginNative(this.objPtr, username, password, host, port, serviceType);
    }

    public boolean loginAsGuest(String displayName, String roomKey, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginAsGuestNative(this.objPtr, displayName, roomKey, host, port, serviceType);
    }

    public boolean loginWithAccessToken(String accessToken, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginWithAccessTokenNative(this.objPtr, accessToken, host, port, serviceType);
    }

    public boolean loginWithCAC(String certificate, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginWithCACNative(this.objPtr, certificate, host, port, serviceType);
    }

    public boolean loginWithRefreshToken(String refreshToken, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginWithRefreshTokenNative(this.objPtr, refreshToken, host, port, serviceType);
    }

    public boolean loginWithSAML(String key, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginWithSAMLNative(this.objPtr, key, host, port, serviceType);
    }

    public boolean loginWithTenantToken(String provisionToken, String host, int port, String serviceType, ILogin Login) {
        this.Login = Login;
        return this.loginWithTenantTokenNative(this.objPtr, provisionToken, host, port, serviceType);
    }

    public boolean logout() {
        return this.logoutNative(this.objPtr);
    }

    public boolean pauseUpdateNotification(boolean pauseUpdateNotification) {
        return this.pauseUpdateNotificationNative(this.objPtr, pauseUpdateNotification);
    }

    public boolean registerCallEventListener(IRegisterCallEventListener RegisterCallEventListener) {
        this.RegisterCallEventListener = RegisterCallEventListener;
        return this.registerCallEventListenerNative(this.objPtr);
    }

    public boolean registerContactEventListener(IRegisterContactEventListener RegisterContactEventListener) {
        this.RegisterContactEventListener = RegisterContactEventListener;
        return this.registerContactEventListenerNative(this.objPtr);
    }

    public boolean registerLicenseEventListener(IRegisterLicenseEventListener RegisterLicenseEventListener) {
        this.RegisterLicenseEventListener = RegisterLicenseEventListener;
        return this.registerLicenseEventListenerNative(this.objPtr);
    }

    public boolean registerRoomEventListener(IRegisterRoomEventListener RegisterRoomEventListener) {
        this.RegisterRoomEventListener = RegisterRoomEventListener;
        return this.registerRoomEventListenerNative(this.objPtr);
    }

    public boolean removeRosterContact(String userId) {
        return this.removeRosterContactNative(this.objPtr, userId);
    }

    public boolean searchConversationRooms(String searchText, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.searchConversationRoomsNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean searchRooms(String searchText, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.searchRoomsNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean searchRoomsWithName(String searchText, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.searchRoomsWithNameNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean searchRoomsWithOwner(String searchText, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.searchRoomsWithOwnerNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean searchRoomsWithSubject(String searchText, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.searchRoomsWithSubjectNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean searchTopicRooms(String searchText, int index, int pageSize, IAdvancedSearchRooms AdvancedSearchRooms) {
        this.AdvancedSearchRooms = AdvancedSearchRooms;
        return this.searchTopicRoomsNative(this.objPtr, searchText, index, pageSize);
    }

    public boolean searchUsers(String searchText, int index, int pageSize, IAdvancedSearchUsers AdvancedSearchUsers) {
        this.AdvancedSearchUsers = AdvancedSearchUsers;
        return this.searchUsersNative(this.objPtr, searchText, index, pageSize);
    }

    public void setCA(String ca, String caFilePath, String caDir) {
        this.setCANative(this.objPtr, ca, caFilePath, caDir);
    }

    public boolean setDisplayName(String displayName) {
        return this.setDisplayNameNative(this.objPtr, displayName);
    }

    public void setTCPTransport(boolean enable) {
        this.setTCPTransportNative(this.objPtr, enable);
    }

    public void setUDPTransport(boolean enable) {
        this.setUDPTransportNative(this.objPtr, enable);
    }

    public void setWebProxyAddressCredentials(String proxyAddress, String username, String password) {
        this.setWebProxyAddressCredentialsNative(this.objPtr, proxyAddress, username, password);
    }

    public void setWebProxyTransport(boolean enable) {
        this.setWebProxyTransportNative(this.objPtr, enable);
    }

    public void setWebProxyTransportAddress(String name, int port) {
        this.setWebProxyTransportAddressNative(this.objPtr, name, port);
    }

    public boolean unregisterCallEventListener() {
        return this.unregisterCallEventListenerNative(this.objPtr);
    }

    public boolean unregisterContactEventListener() {
        return this.unregisterContactEventListenerNative(this.objPtr);
    }

    public boolean unregisterLicenseEventListener() {
        return this.unregisterLicenseEventListenerNative(this.objPtr);
    }

    public boolean unregisterRoomEventListener() {
        return this.unregisterRoomEventListenerNative(this.objPtr);
    }

    public boolean updatePresence(Contact.ContactPresenceState state, String status) {
        return this.updatePresenceNative(this.objPtr, state, status);
    }

    public class UserLoginInfo {
        public String result = new String();
        public String sourceIp = new String();
        public String timestamp = new String();

        public boolean equals(Object obj) {
            if (obj instanceof UserLoginInfo) {
                UserLoginInfo object = (UserLoginInfo)obj;
                return this.result.equals(object.result) && this.sourceIp.equals(object.sourceIp) && this.timestamp.equals(object.timestamp);
            }
            return false;
        }
    }

    public class UserAuthenticationInfo {
        public UserAuthType authType = UserAuthType.values()[0];
        public Property property = new Property();

        public boolean equals(Object obj) {
            if (obj instanceof UserAuthenticationInfo) {
                UserAuthenticationInfo object = (UserAuthenticationInfo)obj;
                return this.authType == object.authType && this.property.equals(object.property);
            }
            return false;
        }
    }

    public class TenantCapabilities {
        public ArrayList<UserLoginInfo> LoginAttemptInfo = new ArrayList();
        public String WSGMicroserviceAddress = new String();
        public String changePasswordUrl = new String();
        public ArrayList<Property> endpointBehavior = new ArrayList();
        public boolean isClientSideRoomModerationEnabled;
        public boolean isCreatePublicRoomEnabled;
        public boolean isGuestEnabled;
        public boolean isLoginBannerEnabled;
        public boolean isOpusAudioEnabled;
        public boolean isPersonalRoomEnabled;
        public boolean isPrivateChatEnabled;
        public boolean isPublicChatEnabled;
        public boolean isRoomModerationEnabled;
        public boolean isScheduledRoomEnabled;
        public boolean isSdk220Enabled;
        public boolean isTestCallEnabled;
        public boolean isTytoCareEnabled;
        public boolean isWSGMicroserviceEnabled;
        public boolean isWelcomeBannerEnabled;
        public String loginBannerData = new String();
        public int maximumRoomPinLength;
        public int minimumRoomPinLength;
        public String welcomeBannerData = new String();

        public boolean equals(Object obj) {
            if (obj instanceof TenantCapabilities) {
                TenantCapabilities object = (TenantCapabilities)obj;
                return this.LoginAttemptInfo.equals(object.LoginAttemptInfo) && this.WSGMicroserviceAddress.equals(object.WSGMicroserviceAddress) && this.changePasswordUrl.equals(object.changePasswordUrl) && this.endpointBehavior.equals(object.endpointBehavior) && this.isClientSideRoomModerationEnabled == object.isClientSideRoomModerationEnabled && this.isCreatePublicRoomEnabled == object.isCreatePublicRoomEnabled && this.isGuestEnabled == object.isGuestEnabled && this.isLoginBannerEnabled == object.isLoginBannerEnabled && this.isOpusAudioEnabled == object.isOpusAudioEnabled && this.isPersonalRoomEnabled == object.isPersonalRoomEnabled && this.isPrivateChatEnabled == object.isPrivateChatEnabled && this.isPublicChatEnabled == object.isPublicChatEnabled && this.isRoomModerationEnabled == object.isRoomModerationEnabled && this.isScheduledRoomEnabled == object.isScheduledRoomEnabled && this.isSdk220Enabled == object.isSdk220Enabled && this.isTestCallEnabled == object.isTestCallEnabled && this.isTytoCareEnabled == object.isTytoCareEnabled && this.isWSGMicroserviceEnabled == object.isWSGMicroserviceEnabled && this.isWelcomeBannerEnabled == object.isWelcomeBannerEnabled && this.loginBannerData.equals(object.loginBannerData) && this.maximumRoomPinLength == object.maximumRoomPinLength && this.minimumRoomPinLength == object.minimumRoomPinLength && this.welcomeBannerData.equals(object.welcomeBannerData);
            }
            return false;
        }
    }

    public static interface IRegisterRoomEventListener {
        public void onRoomCreatedByInvite(Room var1, Contact var2, String var3);

        public void onRoomInviteCancelled(RoomInfo var1, String var2);
    }

    public static interface IRegisterLicenseEventListener {
        public void onLicenseReceived(String var1);

        public void onGetLicenseKey(String var1);
    }

    public static interface IRegisterContactEventListener {
        public void onUpdateSelf(Contact var1);

        public void onUpdateRosterContact(Contact var1);

        public void onRemoveRosterContact(String var1);
    }

    public static interface IRegisterCallEventListener {
        public void onCallCreatedByInvite(Call var1, Contact var2);
    }

    public static interface ILogin {
        public void onLoginComplete(UserLoginResult var1, boolean var2, TenantCapabilities var3);

        public void onLoggedOut(UserLogoutReason var1);

        public void onConnectionStatusChanged(UserConnectionStatusChangedReason var1);

        public void onTokenReceived(String var1, UserTokenType var2);

        public void onWebProxyCredentialsRequest(String var1);
    }

    public static interface IGetRecentRooms {
        public void onRecentRoomResults(UserSearchResult var1, ArrayList<RoomInfo> var2);
    }

    public static interface IGetPasswordResetUrl {
        public void onPasswordResetUrl(String var1);
    }

    public static interface IGetFavoriteRooms {
        public void onFavoriteRoomResults(UserSearchResult var1, ArrayList<RoomInfo> var2);
    }

    public static interface IGetContact {
        public void onGetContactResult(Contact var1, UserGetContactResult var2);
    }

    public static interface IGetAuthTypes {
        public void onAuthTypes(UserGetAuthTypesResult var1, ArrayList<UserAuthenticationInfo> var2);

        public void onAuthTypesWebProxyCredentialsRequest(String var1);
    }

    public static interface ICreateRoomFromId {
        public void onRoomCreated(Room var1, UserRoomCreateResult var2, String var3);
    }

    public static interface ICreateCall {
        public void onCallCreated(Call var1, UserCallCreateResult var2, String var3);
    }

    public static interface IAdvancedSearchUsers {
        public void onUserSearchResults(String var1, UserSearchResult var2, ArrayList<ContactInfo> var3, long var4);
    }

    public static interface IAdvancedSearchRooms {
        public void onRoomSearchResults(String var1, UserSearchResult var2, ArrayList<RoomInfo> var3, long var4);
    }

    public static enum UserTokenType {
        VIDYO_USERTOKENTYPE_RefreshToken,
        VIDYO_USERTOKENTYPE_AccessToken;

    }

    public static enum UserState {
        VIDYO_USERSTATE_Idle,
        VIDYO_USERSTATE_LoggingIn,
        VIDYO_USERSTATE_LoggedIn,
        VIDYO_USERSTATE_Reconnecting,
        VIDYO_USERSTATE_RequestingAuthenticationTypes;

    }

    public static enum UserSearchResult {
        VIDYO_USERSEARCHRESULT_OK,
        VIDYO_USERSEARCHRESULT_NoRecords,
        VIDYO_USERSEARCHRESULT_NoResponse,
        VIDYO_USERSEARCHRESULT_MiscLocalError,
        VIDYO_USERSEARCHRESULT_MiscRemoteError;

    }

    public static enum UserSearchField {
        VIDYO_USERSEARCHFIELD_UID,
        VIDYO_USERSEARCHFIELD_EMAIL,
        VIDYO_USERSEARCHFIELD_NAME,
        VIDYO_USERSEARCHFIELD_TELNO;

    }

    public static enum UserRoomCreateResult {
        VIDYO_USERROOMCREATERESULT_OK,
        VIDYO_USERROOMCREATERESULT_NoResponse,
        VIDYO_USERROOMCREATERESULT_NotFound,
        VIDYO_USERROOMCREATERESULT_Unauthorized,
        VIDYO_USERROOMCREATERESULT_MiscLocalError,
        VIDYO_USERROOMCREATERESULT_MiscRemoteError,
        VIDYO_USERROOMCREATERESULT_DuplicateName,
        VIDYO_USERROOMCREATERESULT_LimitReached,
        VIDYO_USERROOMCREATERESULT_NotSupported;

    }

    public static enum UserLogoutReason {
        VIDYO_USERLOGOUTREASON_LoggedOut,
        VIDYO_USERLOGOUTREASON_ConnectionLost,
        VIDYO_USERLOGOUTREASON_ConnectionTimeout,
        VIDYO_USERLOGOUTREASON_NoResponse,
        VIDYO_USERLOGOUTREASON_Terminated,
        VIDYO_USERLOGOUTREASON_MiscError,
        VIDYO_USERLOGOUTREASON_LoggedInElsewhere,
        VIDYO_USERLOGOUTREASON_NetworkInterfaceChanged,
        VIDYO_USERLOGOUTREASON_OutOfLicenses,
        VIDYO_USERLOGOUTREASON_EpClientBadConnection,
        VIDYO_USERLOGOUTREASON_EpClientBadVersion,
        VIDYO_USERLOGOUTREASON_EpClientBadSessionId,
        VIDYO_USERLOGOUTREASON_EpClientBadComms,
        VIDYO_USERLOGOUTREASON_EpClientRebootRequested,
        VIDYO_USERLOGOUTREASON_EpClientShutdownRequested,
        VIDYO_USERLOGOUTREASON_EpClientRestartRequested,
        VIDYO_USERLOGOUTREASON_EpClientInternalError,
        VIDYO_USERLOGOUTREASON_EndpointNotBound,
        VIDYO_USERLOGOUTREASON_InvalidAuth,
        VIDYO_USERLOGOUTREASON_EpClientStartFailure;

    }

    public static enum UserLoginResult {
        VIDYO_USERLOGINRESULT_OK,
        VIDYO_USERLOGINRESULT_ConnectionFailed,
        VIDYO_USERLOGINRESULT_ConnectionLost,
        VIDYO_USERLOGINRESULT_ConnectionTimeout,
        VIDYO_USERLOGINRESULT_NoResponse,
        VIDYO_USERLOGINRESULT_Terminated,
        VIDYO_USERLOGINRESULT_InvalidUser,
        VIDYO_USERLOGINRESULT_InvalidPassword,
        VIDYO_USERLOGINRESULT_MiscAuthError,
        VIDYO_USERLOGINRESULT_Cancelled,
        VIDYO_USERLOGINRESULT_MiscError,
        VIDYO_USERLOGINRESULT_WebProxyAuthenticationRequired,
        VIDYO_USERLOGINRESULT_ServiceUnavailable,
        VIDYO_USERLOGINRESULT_RoomIsFull,
        VIDYO_USERLOGINRESULT_RoomIsDisabled,
        VIDYO_USERLOGINRESULT_TlsFailed,
        VIDYO_USERLOGINRESULT_CertificateVerificationFailed,
        VIDYO_USERLOGINRESULT_UnsupportedTenantVersion,
        VIDYO_USERLOGINRESULT_NoValidNetworkInterface;

    }

    public static enum UserGetContactResult {
        VIDYO_USERGETCONTACTRESULT_OK,
        VIDYO_USERGETCONTACTRESULT_NoResponse,
        VIDYO_USERGETCONTACTRESULT_Unauthorized,
        VIDYO_USERGETCONTACTRESULT_MiscLocalError,
        VIDYO_USERGETCONTACTRESULT_MiscRemoteError;

    }

    public static enum UserGetAuthTypesResult {
        VIDYO_USERGETAUTHTYPESRESULT_OK,
        VIDYO_USERGETAUTHTYPESRESULT_ConnectionFailed,
        VIDYO_USERGETAUTHTYPESRESULT_ConnectionLost,
        VIDYO_USERGETAUTHTYPESRESULT_ConnectionTimeout,
        VIDYO_USERGETAUTHTYPESRESULT_NoResponse,
        VIDYO_USERGETAUTHTYPESRESULT_WebProxyAuthenticationFailed,
        VIDYO_USERGETAUTHTYPESRESULT_TlsFailed,
        VIDYO_USERGETAUTHTYPESRESULT_ServiceUnavailable,
        VIDYO_USERGETAUTHTYPESRESULT_MiscLocalError,
        VIDYO_USERGETAUTHTYPESRESULT_MiscRemoteError,
        VIDYO_USERGETAUTHTYPESRESULT_UnSupportedTenantVersion,
        VIDYO_USERGETAUTHTYPESRESULT_NoValidNetworkInterface;

    }

    public static enum UserConnectionStatusChangedReason {
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_OK,
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_LostContactWithServer,
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_NoCommunicationWithServer,
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_NoValidNetworkInterfaces,
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_NetworkInterfaceChanged,
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_MiscNetworkError,
        VIDYO_USERCONNECTIONSTATUSCHANGEDREASON_ConnectionError;

    }

    public static enum UserCallCreateResult {
        VIDYO_USERCALLCREATERESULT_OK,
        VIDYO_USERCALLCREATERESULT_NoResponse,
        VIDYO_USERCALLCREATERESULT_NotAllowed,
        VIDYO_USERCALLCREATERESULT_MiscLocalError,
        VIDYO_USERCALLCREATERESULT_MiscRemoteError;

    }

    public static enum UserAuthType {
        VIDYO_USERAUTHTYPE_Guest,
        VIDYO_USERAUTHTYPE_Password,
        VIDYO_USERAUTHTYPE_AccessToken,
        VIDYO_USERAUTHTYPE_RefreshToken,
        VIDYO_USERAUTHTYPE_ProvisionToken,
        VIDYO_USERAUTHTYPE_Facebook,
        VIDYO_USERAUTHTYPE_Saml,
        VIDYO_USERAUTHTYPE_Cac;

    }

    public static enum RoomSearchFieldRelation {
        VIDYO_ROOMSEARCHFIELDRELATION_AND,
        VIDYO_ROOMSEARCHFIELDRELATION_OR;

    }

    public static enum RoomSearchField {
        VIDYO_ROOMSEARCHFIELD_Owner,
        VIDYO_ROOMSEARCHFIELD_Admin,
        VIDYO_ROOMSEARCHFIELD_Moderator,
        VIDYO_ROOMSEARCHFIELD_Member,
        VIDYO_ROOMSEARCHFIELD_User,
        VIDYO_ROOMSEARCHFIELD_Name,
        VIDYO_ROOMSEARCHFIELD_Subject,
        VIDYO_ROOMSEARCHFIELD_Type,
        VIDYO_ROOMSEARCHFIELD_Public,
        VIDYO_ROOMSEARCHFIELD_NonMembers;

    }
}

