/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.media.MediaActionSound;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.WindowManager;
import com.vidyo.LmiDeviceManager.LmiVideoCapturer;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerCapability;
import com.vidyo.LmiDeviceManager.LmiVideoCapturerManagerCamera2;
import com.vidyo.LmiDeviceManager.LmiVideoFrame;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
class LmiVideoCapturerCamera2
extends LmiVideoCapturer
implements ImageReader.OnImageAvailableListener {
    private LmiVideoCapturerCapability[] capabilityArray = null;
    private LmiVideoCapturerCapability[] capabilityArrayCapture = null;
    private String deviceId;
    private Context context;
    private CameraManager manager;
    private boolean stopping = false;
    private long frameInterval = 33333333L;
    private int torchMode = 0;
    private int cameraRotation = 0;
    private boolean mirrored = false;
    private CameraCharacteristics cameraCharacteristics;
    private int facing = 0;
    private String name = null;
    private OrientationEventListener rotationNotifier;
    private Integer mDeviceRotation = Integer.MAX_VALUE;
    private Integer mAppUiRotation = Integer.MAX_VALUE;
    private int capturePictureFlashMode = 0;
    private String capturePictureFormat = "JPEG";
    private byte capturePictureQuality = 0;
    private Semaphore openComplete = null;
    private Semaphore createCaptureComplete = null;
    private boolean startSuccess = false;
    private CameraDevice cameraDevice = null;
    private ImageReader imagereader = null;
    private ImageReaderWrapper imageReaderWrapper = null;
    private CameraCaptureSession captureSession = null;
    private ImageReader imagereadercapture = null;
    private ImageReaderWrapper imageReaderCaptureWrapper = null;
    private final int NUM_IMAGES = 8;
    private CaptureThreadRunnable captureThreadRunnable = null;
    private boolean captureThreadRunnableActive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncAppUiRotation() {
        int appUiRotation = 0;
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display defaultDisplay = windowManager.getDefaultDisplay();
        int displayRotation = defaultDisplay.getRotation();
        switch (displayRotation) {
            case 0: {
                appUiRotation = 0;
                break;
            }
            case 1: {
                appUiRotation = 270;
                break;
            }
            case 2: {
                appUiRotation = 180;
                break;
            }
            case 3: {
                appUiRotation = 90;
                break;
            }
            default: {
                Log.i((String)TAG, (String)String.format("UNEXPECTED enum value %d from Display.getRotation().", displayRotation));
            }
        }
        Integer n = this.mAppUiRotation;
        synchronized (n) {
            if (this.mAppUiRotation != appUiRotation) {
                Log.i((String)TAG, (String)String.format("App's UI rotation changed from %d to %d (camera \"%s\", facing %s)", this.mAppUiRotation, appUiRotation, this.name, this.facing == 0 ? "Front" : "Back"));
                this.mAppUiRotation = appUiRotation;
            }
        }
        return appUiRotation;
    }

    public LmiVideoCapturerCamera2(Context context, String id, long nativePtr) throws CameraAccessException, LmiVideoCapturer.CameraNotSupportedException {
        super(nativePtr);
        Log.i((String)TAG, (String)("constructing Camera2 capturer for camera " + id));
        this.deviceId = id;
        this.context = context.getApplicationContext();
        this.manager = LmiVideoCapturerManagerCamera2.getManager(context);
        this.cameraCharacteristics = this.manager.getCameraCharacteristics(this.deviceId);
        this.facing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1 ? 1 : 0;
        this.cameraRotation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.name = this.facing == 1 && this.deviceId.equals("0") ? "Back" : (this.facing == 0 && this.deviceId.equals("1") ? "Front" : String.format("Camera %s", this.deviceId));
        this.checkForKnownCameraBugs();
        this.rotationNotifier = new OrientationEventListener(context){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOrientationChanged(int orientation) {
                LmiVideoCapturerCamera2.this.syncAppUiRotation();
                if (orientation == -1) {
                    return;
                }
                int roundedOrientation = (orientation + 45) / 90 * 90 % 360;
                Integer n = LmiVideoCapturerCamera2.this.mDeviceRotation;
                synchronized (n) {
                    if (LmiVideoCapturerCamera2.this.mDeviceRotation != roundedOrientation) {
                        Log.i((String)LmiVideoCapturer.TAG, (String)String.format("Camera \"%s\" device rotation changed, new value %d (camera rotation %d, facing %s)", LmiVideoCapturerCamera2.this.name, roundedOrientation, LmiVideoCapturerCamera2.this.cameraRotation, LmiVideoCapturerCamera2.this.facing == 0 ? "Front" : "Back"));
                        LmiVideoCapturerCamera2.this.mDeviceRotation = roundedOrientation;
                    }
                }
            }
        };
        Log.i((String)TAG, (String)"constructor exit");
    }

    private void checkForKnownCameraBugs() throws LmiVideoCapturer.CameraNotSupportedException {
        try {
            Object[] aeRanges = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            boolean ok = false;
            for (Range range : aeRanges) {
                if ((Integer)range.getLower() >= 1000) continue;
                ok = true;
                break;
            }
            if (!ok) {
                Log.w((String)TAG, (String)("Not using Camera2 API for camera " + this.name + ": absurd autoexposure ranges " + Arrays.toString(aeRanges)));
                throw new LmiVideoCapturer.CameraNotSupportedException();
            }
        }
        catch (LmiVideoCapturer.CameraNotSupportedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Exception checking for camera bugs for camera " + this.name), (Throwable)ex);
            throw new LmiVideoCapturer.CameraNotSupportedException();
        }
    }

    @Override
    public LmiVideoCapturerCapability[] getCapabilities() {
        Log.i((String)TAG, (String)"getCapabilities()");
        if (null == this.capabilityArray) {
            this.enumerateCapabilities();
        }
        return this.capabilityArray;
    }

    @Override
    public LmiVideoCapturerCapability[] getCapabilitiesCapture() {
        Log.i((String)TAG, (String)"getCapabilitiesCapture()");
        if (null == this.capabilityArrayCapture) {
            this.enumerateCapabilitiesJPEG();
        }
        return this.capabilityArrayCapture;
    }

    public static boolean hasCapabilities(CameraManager manager, String deviceId) {
        Log.i((String)TAG, (String)"hasCapabilities()");
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(deviceId);
            LmiVideoCapturerCapability[] capabilities = LmiVideoCapturerCamera2.enumerateCapabilitiesStatic(characteristics, deviceId);
            return capabilities != null && capabilities.length > 0;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    private Range<Integer> findBestRange(Range<Integer>[] ranges, int value) {
        Range<Integer> contained = null;
        Range<Integer> below = null;
        Range<Integer> above = null;
        if (ranges == null) {
            return null;
        }
        for (Range<Integer> range : ranges) {
            if (range.contains((Comparable)Integer.valueOf(value))) {
                if (contained == null) {
                    contained = range;
                } else if ((Integer)contained.getUpper() > (Integer)range.getUpper()) {
                    contained = range;
                } else if (((Integer)contained.getUpper()).equals(range.getUpper()) && (Integer)contained.getLower() > (Integer)range.getLower()) {
                    contained = range;
                }
            }
            if ((Integer)range.getUpper() < value) {
                if (below == null) {
                    below = range;
                } else if ((Integer)below.getUpper() < (Integer)range.getUpper()) {
                    below = range;
                } else if (((Integer)below.getUpper()).equals(range.getUpper()) && (Integer)below.getLower() > (Integer)range.getLower()) {
                    below = range;
                }
            }
            if ((Integer)range.getLower() <= value) continue;
            if (above == null) {
                above = range;
                continue;
            }
            if ((Integer)above.getLower() > (Integer)range.getLower()) {
                above = range;
                continue;
            }
            if (!((Integer)above.getLower()).equals(range.getLower()) || (Integer)above.getUpper() <= (Integer)range.getUpper()) continue;
            above = range;
        }
        if (contained != null) {
            return contained;
        }
        if (below != null) {
            return below;
        }
        return above;
    }

    private void setFrameRate(CaptureRequest.Builder requestBuilder, long interval) {
        StreamConfigurationMap configMap = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        long minFrameDuration = configMap.getOutputMinFrameDuration(this.imagereader.getImageFormat(), new Size(this.imagereader.getWidth(), this.imagereader.getHeight()));
        int[] supportedAfModes = (int[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        Range exposureTimeRange = (Range)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
        int frameRate = (int)(TimeUnit.SECONDS.toNanos(1L) / interval);
        Range[] aeRanges = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        Range<Integer> bestAeRange = this.findBestRange(aeRanges, frameRate);
        requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        if (bestAeRange != null) {
            Log.i((String)TAG, (String)("Using bestAeRange " + bestAeRange.toString()));
            requestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, bestAeRange);
        } else if (minFrameDuration != 0L) {
            if (interval < minFrameDuration) {
                interval = minFrameDuration;
            }
            Log.i((String)TAG, (String)("NOT Using bestAeRange, setting frame duration to " + interval));
            requestBuilder.set(CaptureRequest.SENSOR_FRAME_DURATION, (Object)interval);
        }
    }

    private static boolean isSupported(int[] supported, int value) {
        if (supported == null) {
            return false;
        }
        for (int val : supported) {
            if (val != value) continue;
            return true;
        }
        return false;
    }

    private void setAdvancedCameraParameters(CaptureRequest.Builder requestBuilder) {
        Log.i((String)TAG, (String)"Setting advanced camera parameters");
        requestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        int[] afModes = (int[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (LmiVideoCapturerCamera2.isSupported(afModes, 3)) {
            requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        } else if (LmiVideoCapturerCamera2.isSupported(afModes, 1)) {
            requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        }
        requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        requestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
        int[] opticalStabilization = (int[])this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
        int[] digitalStabilization = (int[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        if (LmiVideoCapturerCamera2.isSupported(opticalStabilization, 1)) {
            requestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
            requestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
        } else if (LmiVideoCapturerCamera2.isSupported(digitalStabilization, 1)) {
            requestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
        }
    }

    private static String cameraDeviceErrToString(int err) {
        switch (err) {
            case 4: {
                return "fatal device error";
            }
            case 3: {
                return "camera disabled";
            }
            case 1: {
                return "camera in use";
            }
            case 5: {
                return "fatal camera service error";
            }
            case 2: {
                return "too many open cameras";
            }
        }
        return "unknown error " + err;
    }

    @Override
    public boolean startInternal(String format, int width, int height, long interval, boolean startVideoFlag, int pictureWidth, int pictureHeight, int maxNumberOfPictures) {
        int formatInt = LmiVideoCapturerCamera2.pixelFormatFromString(format);
        StreamConfigurationMap map = null;
        this.stopping = false;
        if (formatInt == 0) {
            Log.e((String)TAG, (String)("Unknown format " + format));
            return false;
        }
        if (maxNumberOfPictures < 1) {
            maxNumberOfPictures = 1;
        }
        if (maxNumberOfPictures > 33) {
            maxNumberOfPictures = 33;
        }
        if (this.imagereadercapture == null) {
            if (pictureWidth > 0 && pictureHeight > 0) {
                this.imagereadercapture = ImageReader.newInstance((int)pictureWidth, (int)pictureHeight, (int)LmiVideoCapturerCamera2.pixelFormatFromString(this.capturePictureFormat), (int)maxNumberOfPictures);
                Log.i((String)TAG, (String)("startInternal: using width: " + pictureWidth + " height: " + pictureHeight + " for " + this.capturePictureFormat + " capture"));
            } else {
                try {
                    map = (StreamConfigurationMap)this.manager.getCameraCharacteristics(this.deviceId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                }
                catch (Exception e) {
                    map = null;
                }
                if (map != null) {
                    Size largest = Collections.max(Arrays.asList(map.getOutputSizes(LmiVideoCapturerCamera2.pixelFormatFromString(this.capturePictureFormat))), new CompareRectArea());
                    this.imagereadercapture = ImageReader.newInstance((int)largest.getWidth(), (int)largest.getHeight(), (int)LmiVideoCapturerCamera2.pixelFormatFromString(this.capturePictureFormat), (int)maxNumberOfPictures);
                    Log.i((String)TAG, (String)("startInternal: using sensor width: " + largest.getWidth() + " sensor height: " + largest.getHeight() + " for " + this.capturePictureFormat + " capture"));
                } else if (startVideoFlag) {
                    this.imagereadercapture = ImageReader.newInstance((int)width, (int)height, (int)LmiVideoCapturerCamera2.pixelFormatFromString(this.capturePictureFormat), (int)maxNumberOfPictures);
                    Log.e((String)TAG, (String)("startInternal: using width: " + width + " height: " + height + " for " + this.capturePictureFormat + " capture"));
                } else {
                    Log.e((String)TAG, (String)("startInternal: unable to get width or height for " + this.capturePictureFormat + " capture"));
                }
            }
            if (this.imagereadercapture != null) {
                this.imageReaderCaptureWrapper = new ImageReaderWrapper(this.imagereadercapture);
            }
        }
        if (startVideoFlag) {
            this.imagereader = ImageReader.newInstance((int)width, (int)height, (int)formatInt, (int)8);
        } else if (this.imagereadercapture == null) {
            Log.e((String)TAG, (String)("startInternal: unable to get imageReader for " + this.capturePictureFormat + " capture"));
            return false;
        }
        this.rotationNotifier.enable();
        Handler handler = LmiVideoCapturerManagerCamera2.getHandler();
        if (this.imagereader != null) {
            this.imagereader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, handler);
            this.imageReaderWrapper = new ImageReaderWrapper(this.imagereader);
        }
        try {
            if (this.context.checkPermission("android.permission.CAMERA", Process.myPid(), Process.myUid()) != 0) {
                Log.e((String)TAG, (String)"Application does not have Camera permission");
                return false;
            }
            if (this.cameraDevice == null) {
                this.openComplete = new Semaphore(0);
                this.manager.openCamera(this.deviceId, new CameraDevice.StateCallback(){

                    public void onOpened(CameraDevice cameraDevice) {
                        Log.i((String)LmiVideoCapturer.TAG, (String)("Camera " + LmiVideoCapturerCamera2.this.deviceId + " opened"));
                        LmiVideoCapturerCamera2.this.startSuccess = true;
                        LmiVideoCapturerCamera2.this.cameraDevice = cameraDevice;
                        LmiVideoCapturerCamera2.this.openComplete.release();
                    }

                    public void onDisconnected(CameraDevice cameraDevice) {
                        Log.e((String)LmiVideoCapturer.TAG, (String)("Camera " + LmiVideoCapturerCamera2.this.deviceId + " disconnected"));
                        LmiVideoCapturerCamera2.this.openComplete.release();
                        LmiVideoCapturerCamera2.this.notifyDisconnected();
                    }

                    public void onError(CameraDevice cameraDevice, int i) {
                        Log.e((String)LmiVideoCapturer.TAG, (String)("Camera " + LmiVideoCapturerCamera2.this.deviceId + " error #" + i + ": " + LmiVideoCapturerCamera2.cameraDeviceErrToString(i)));
                        LmiVideoCapturerCamera2.this.openComplete.release();
                        LmiVideoCapturerCamera2.this.notifyError(LmiVideoCapturerCamera2.cameraDeviceErrToString(i));
                    }
                }, handler);
                this.openComplete.acquireUninterruptibly();
                if (!this.startSuccess) {
                    throw new Exception("Open camera failed");
                }
            }
            ArrayList<Surface> cameraOutputs = new ArrayList<Surface>();
            if (this.imagereadercapture != null) {
                cameraOutputs.add(this.imagereadercapture.getSurface());
            }
            if (this.imagereader != null) {
                cameraOutputs.add(this.imagereader.getSurface());
            }
            this.createCaptureComplete = new Semaphore(0);
            this.cameraDevice.createCaptureSession(cameraOutputs, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    LmiVideoCapturerCamera2.this.captureSession = null;
                    LmiVideoCapturerCamera2.this.captureSession = cameraCaptureSession;
                    LmiVideoCapturerCamera2.this.createCaptureComplete.release();
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    LmiVideoCapturerCamera2.this.startSuccess = false;
                    LmiVideoCapturerCamera2.this.createCaptureComplete.release();
                }
            }, handler);
            this.createCaptureComplete.acquireUninterruptibly();
            if (!this.startSuccess) {
                throw new Exception("Create Capture failed");
            }
            if (this.imagereader != null) {
                CaptureRequest.Builder requestBuilder = this.cameraDevice.createCaptureRequest(1);
                requestBuilder.addTarget(this.imagereader.getSurface());
                requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)this.torchMode);
                this.setFrameRate(requestBuilder, interval);
                this.setAdvancedCameraParameters(requestBuilder);
                CaptureRequest request = requestBuilder.build();
                this.captureSession.setRepeatingRequest(request, null, handler);
                this.frameInterval = interval;
            }
            int imageCaptureCount = this.imageReaderCaptureWrapper.getCountRequested();
            this.imageReaderCaptureWrapper.clearCountRequested();
            for (int i = 0; i < imageCaptureCount; ++i) {
                this.capturePicture(this.capturePictureQuality, this.capturePictureFlashMode);
            }
            if (imageCaptureCount > 0) {
                Log.i((String)TAG, (String)("resume capturing of expected " + imageCaptureCount + " pictures"));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to open camera", (Throwable)e);
            if (this.captureSession != null) {
                this.captureSession.close();
                this.captureSession = null;
            }
            if (this.cameraDevice != null) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (this.imageReaderWrapper != null) {
                this.imageReaderWrapper.close();
                this.imageReaderWrapper = null;
            }
            if (this.imageReaderCaptureWrapper != null) {
                this.imageReaderCaptureWrapper.close();
                this.imageReaderCaptureWrapper = null;
            }
            if (this.imagereader != null) {
                this.imagereader = null;
            }
            if (this.imagereadercapture != null) {
                this.imagereadercapture = null;
            }
            this.rotationNotifier.disable();
            return false;
        }
        return true;
    }

    @Override
    public void stopInternal(boolean stopPictureAndVideo) {
        if (stopPictureAndVideo) {
            Log.i((String)TAG, (String)"stopInternal");
            this.stopping = true;
        } else {
            Log.i((String)TAG, (String)"stopInternal : only video");
        }
        if (this.captureSession != null) {
            try {
                this.captureSession.stopRepeating();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unable to stop Camera capture session", (Throwable)e);
            }
        }
        if (stopPictureAndVideo) {
            if (this.captureSession != null) {
                this.captureSession.close();
                this.captureSession = null;
            }
            if (this.cameraDevice != null) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (this.imagereader != null) {
                this.imagereader.close();
                this.imagereader = null;
            }
            if (this.imagereadercapture != null) {
                this.imagereadercapture.close();
                this.imagereadercapture = null;
            }
            this.rotationNotifier.disable();
        }
    }

    @Override
    public boolean hasTorchInternal() {
        try {
            return (Boolean)this.manager.getCameraCharacteristics(this.deviceId).get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        }
        catch (CameraAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTorchModeSupportedInternal(int mode) {
        return mode == 0 || mode == 1;
    }

    @Override
    public int getTorchModeInternal() {
        int r;
        if (this.torchMode == 0) {
            r = 0;
        } else if (this.torchMode == 2) {
            r = 1;
        } else {
            throw new RuntimeException("Unknown or unsupported torch mode");
        }
        return r;
    }

    @Override
    public void setTorchModeInternal(int mode) {
        try {
            int mode_;
            if (mode == 0 || mode == 1) {
                int n = mode_ = mode == 1 ? 2 : 0;
                if (this.captureSession != null && this.imagereader != null) {
                    CaptureRequest.Builder requestBuilder = this.cameraDevice.createCaptureRequest(1);
                    requestBuilder.addTarget(this.imagereader.getSurface());
                    requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)mode_);
                    this.setFrameRate(requestBuilder, this.frameInterval);
                    this.setAdvancedCameraParameters(requestBuilder);
                    CaptureRequest request = requestBuilder.build();
                    this.captureSession.stopRepeating();
                    this.captureSession.setRepeatingRequest(request, null, LmiVideoCapturerManagerCamera2.getHandler());
                }
            } else {
                throw new RuntimeException("Unknown or unsupported torch mode");
            }
            this.torchMode = mode_;
        }
        catch (CameraAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean CapturePicture(int picQuality, int picFlashMode) {
        boolean incremented = false;
        if (this.imagereadercapture != null) {
            Handler handler = LmiVideoCapturerManagerCamera2.getHandler();
            if (picQuality > 0 && picQuality <= 100) {
                this.capturePictureQuality = (byte)picQuality;
            }
            this.capturePictureFlashMode = picFlashMode;
            if (this.imagereadercapture.getMaxImages() <= this.imageReaderCaptureWrapper.getCountRequested()) {
                Log.i((String)TAG, (String)("unable to take picture number " + (this.imageReaderCaptureWrapper.getCountRequested() + 1) + " as max number of allowed pictures is " + this.imagereadercapture.getMaxImages()));
                return false;
            }
            try {
                int captureTemplate = 4;
                CaptureRequest.Builder requestBuilder = this.cameraDevice.createCaptureRequest(captureTemplate);
                requestBuilder.addTarget(this.imagereadercapture.getSurface());
                if (this.manager != null) {
                    int SensorOrientation = 360 - this.getOrientation();
                    requestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)SensorOrientation);
                }
                if (this.capturePictureQuality > 0) {
                    requestBuilder.set(CaptureRequest.JPEG_QUALITY, (Object)this.capturePictureQuality);
                }
                boolean flashAvailable = false;
                try {
                    flashAvailable = (Boolean)this.manager.getCameraCharacteristics(this.deviceId).get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                }
                catch (CameraAccessException e) {
                    throw new RuntimeException(e);
                }
                if (flashAvailable && this.torchMode == 0) {
                    if (picFlashMode > 0) {
                        requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
                    } else {
                        requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    }
                }
                CaptureRequest request = requestBuilder.build();
                this.imagereadercapture.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, handler);
                this.imageReaderCaptureWrapper.incCountRequested();
                incremented = true;
                MediaActionSound mediaActionSound = new MediaActionSound();
                mediaActionSound.play(0);
                this.captureSession.capture(request, new CameraCaptureSession.CaptureCallback(){

                    public void onCaptureBufferLost(CameraCaptureSession session, CaptureRequest request, Surface surface, long frameNumber) {
                        Log.e((String)LmiVideoCapturer.TAG, (String)"CapturePicture:onCaptureBufferLost Error");
                        LmiVideoCapturerCamera2.this.pictureReceived(null);
                        LmiVideoCapturerCamera2.this.imageReaderCaptureWrapper.decCountRequested();
                        LmiVideoCapturerCamera2.this.captureThreadRunnable = new CaptureThreadRunnable();
                        Thread captureStopThread = new Thread(LmiVideoCapturerCamera2.this.captureThreadRunnable);
                        LmiVideoCapturerCamera2.this.captureThreadRunnable.callStop();
                        captureStopThread.start();
                    }

                    public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
                        Log.e((String)LmiVideoCapturer.TAG, (String)"CapturePicture:onCaptureFailed Error");
                        LmiVideoCapturerCamera2.this.pictureReceived(null);
                        LmiVideoCapturerCamera2.this.imageReaderCaptureWrapper.decCountRequested();
                        LmiVideoCapturerCamera2.this.captureThreadRunnable = new CaptureThreadRunnable();
                        Thread captureStopThread = new Thread(LmiVideoCapturerCamera2.this.captureThreadRunnable);
                        LmiVideoCapturerCamera2.this.captureThreadRunnable.callStop();
                        captureStopThread.start();
                    }
                }, handler);
            }
            catch (CameraAccessException e) {
                if (incremented) {
                    this.imageReaderCaptureWrapper.decCountRequested();
                }
                Log.e((String)TAG, (String)"CapturePicture: Failed to capture image", (Throwable)e);
                return false;
            }
            return true;
        }
        Log.e((String)TAG, (String)"CapturePicture: Failed to access camera");
        return false;
    }

    private static int pixelFormatFromString(String format) {
        int pixelFormatInt = 0;
        if (format.equals("JPEG")) {
            pixelFormatInt = 256;
        } else if (format.equals("NV16")) {
            pixelFormatInt = 16;
        } else if (format.equals("NV21")) {
            pixelFormatInt = 17;
        } else if (format.equals("YUY2")) {
            pixelFormatInt = 20;
        } else if (format.equals("YV12")) {
            pixelFormatInt = 842094169;
        } else if (format.equals("I420")) {
            pixelFormatInt = 35;
        } else if (Build.VERSION.SDK_INT >= 23) {
            pixelFormatInt = LmiVideoCapturerCamera2.pixelFormatFromStringApi23(format);
        }
        return pixelFormatInt;
    }

    @TargetApi(value=23)
    private static int pixelFormatFromStringApi23(String format) {
        int pixelFormatInt = 0;
        if (format.equals("I422")) {
            pixelFormatInt = 39;
        } else if (format.equals("I444")) {
            pixelFormatInt = 40;
        } else if (format.equals("PRGB")) {
            pixelFormatInt = 41;
        } else if (format.equals("PRGA")) {
            pixelFormatInt = 42;
        }
        return pixelFormatInt;
    }

    static String pixelFormatToString(int formatInt) {
        String format = null;
        switch (formatInt) {
            case 256: {
                format = "JPEG";
                break;
            }
            case 16: {
                format = "NV16";
                break;
            }
            case 20: {
                format = "YUY2";
                break;
            }
            case 842094169: {
                format = "YV12";
                break;
            }
            case 35: {
                format = "I420";
                break;
            }
            case 39: {
                format = "I422";
                break;
            }
            case 40: {
                format = "I444";
                break;
            }
            case 41: {
                format = "PRGB";
                break;
            }
            case 42: {
                format = "PRGA";
                break;
            }
            case 0: 
            case 4: 
            case 17: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 257: 
            case 1144402265: {
                break;
            }
            default: {
                Log.i((String)TAG, (String)("Unknown/unsupported pixel format " + formatInt));
            }
        }
        return format;
    }

    private static LmiVideoCapturerCapability[] enumerateCapabilitiesStatic(CameraCharacteristics cameraCharacteristics, String deviceId) {
        try {
            int[] formats;
            StreamConfigurationMap configMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Object[] aeRanges = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            Log.i((String)TAG, (String)("Camera " + deviceId + ": AE ranges " + Arrays.toString(aeRanges)));
            ArrayList<LmiVideoCapturerCapability> capabilityArrayList = new ArrayList<LmiVideoCapturerCapability>();
            for (int format : formats = configMap.getOutputFormats()) {
                Size[] sizes;
                String formatStr = LmiVideoCapturerCamera2.pixelFormatToString(format);
                if (formatStr == null || format == 256 && formats.length > 1) continue;
                for (Size size : sizes = configMap.getOutputSizes(format)) {
                    long minDuration = configMap.getOutputMinFrameDuration(format, size);
                    long stall = configMap.getOutputStallDuration(format, size);
                    if (stall > 0L) continue;
                    for (Object range : aeRanges) {
                        long rangeMinDuration = TimeUnit.SECONDS.toNanos(1L) / (long)((Integer)range.getUpper()).intValue();
                        long rangeMaxDuration = TimeUnit.SECONDS.toNanos(1L) / (long)((Integer)range.getLower()).intValue();
                        if (minDuration > 0L) {
                            if (rangeMaxDuration < minDuration) continue;
                            if (rangeMinDuration < minDuration) {
                                rangeMinDuration = minDuration;
                            }
                        }
                        Log.i((String)TAG, (String)("Found Configuration format for device " + deviceId + LmiVideoCapturerCamera2.pixelFormatToString(format) + " size: " + size.getWidth() + "x" + size.getHeight() + " range: " + range.getLower() + " - " + range.getUpper()));
                        capabilityArrayList.add(new LmiVideoCapturerCapability(size.getWidth(), size.getHeight(), rangeMaxDuration, rangeMinDuration, formatStr));
                    }
                }
            }
            return capabilityArrayList.toArray(new LmiVideoCapturerCapability[capabilityArrayList.size()]);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception enumerating capabilities", (Throwable)ex);
            return null;
        }
    }

    private void enumerateCapabilities() {
        this.capabilityArray = LmiVideoCapturerCamera2.enumerateCapabilitiesStatic(this.cameraCharacteristics, this.deviceId);
    }

    private void enumerateCapabilitiesJPEG() {
        try {
            int[] formats;
            StreamConfigurationMap configMap = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            ArrayList<LmiVideoCapturerCapability> capabilityArrayList = new ArrayList<LmiVideoCapturerCapability>();
            for (int format : formats = configMap.getOutputFormats()) {
                Size[] sizes;
                String formatStr = LmiVideoCapturerCamera2.pixelFormatToString(format);
                if (formatStr == null || format != 256) continue;
                for (Size size : sizes = configMap.getOutputSizes(format)) {
                    long minDuration = configMap.getOutputMinFrameDuration(format, size);
                    long stall = configMap.getOutputStallDuration(format, size);
                    if (stall == 0L) {
                        stall = 10000000L;
                    }
                    long fps = TimeUnit.SECONDS.toNanos(1L) / stall;
                    capabilityArrayList.add(new LmiVideoCapturerCapability(size.getWidth(), size.getHeight(), fps, fps, formatStr));
                    Log.i((String)TAG, (String)("Found Configuration format for device " + this.deviceId + " (" + this.name + "): " + LmiVideoCapturerCamera2.pixelFormatToString(format) + " size: " + size.getWidth() + "x" + size.getHeight() + " range: " + fps + " - " + fps + " stall[msec]: " + stall / 1000000L));
                }
            }
            this.capabilityArrayCapture = capabilityArrayList.toArray(new LmiVideoCapturerCapability[capabilityArrayList.size()]);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception enumerating capabilities", (Throwable)ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDeviceRotation() {
        Integer n = this.mDeviceRotation;
        synchronized (n) {
            if (this.mDeviceRotation == Integer.MAX_VALUE) {
                return 0;
            }
            return this.mDeviceRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAppUiRotation() {
        Integer n = this.mAppUiRotation;
        synchronized (n) {
            if (this.mAppUiRotation == Integer.MAX_VALUE) {
                return 0;
            }
            return this.mAppUiRotation;
        }
    }

    @Override
    public int getOrientation() {
        int deviceRotation = this.getDeviceRotation();
        if (this.facing == 0) {
            return (deviceRotation - this.cameraRotation + 360) % 360;
        }
        return (720 - this.cameraRotation - deviceRotation) % 360;
    }

    public int getOrientationRelativeToInterface() {
        int appUiRotation = this.getAppUiRotation();
        if (this.facing == 0) {
            return (720 - this.cameraRotation + appUiRotation) % 360;
        }
        return (720 - this.cameraRotation - appUiRotation) % 360;
    }

    @Override
    public boolean getMirrored() {
        return this.mirrored;
    }

    @Override
    public int getFacing() {
        return this.facing;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void onImageAvailable(ImageReader reader) {
        Image image;
        try {
            image = reader.acquireLatestImage();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"unable to acquire latest frame", (Throwable)e);
            return;
        }
        if (image == null) {
            return;
        }
        boolean incremented = false;
        if (reader == this.imagereader) {
            try {
                LmiVideoFrame frame = new LmiVideoFrame(image);
                frame.setMirrored(this.mirrored);
                frame.setOrientation(this.getOrientation());
                frame.setOrientationRelativeToInterface(this.getOrientationRelativeToInterface());
                this.imageReaderWrapper.incCount();
                incremented = true;
                frame.setObject(this.imageReaderWrapper);
                this.frameReceived(frame);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"unable to add captured frame", (Throwable)e);
                if (incremented) {
                    this.imageReaderWrapper.decCount();
                }
                image.close();
            }
        } else if (reader == this.imagereadercapture) {
            Image.Plane[] planes = image.getPlanes();
            int width = image.getWidth();
            int height = image.getHeight();
            ByteBuffer buffer = planes[0].getBuffer();
            if (buffer != null) {
                Log.i((String)TAG, (String)("OnImageAvailable: captured picture ts:" + image.getTimestamp() + " width:" + width + " height:" + height + " nBytes:" + buffer.capacity() + " format:" + LmiVideoCapturerCamera2.pixelFormatToString(image.getFormat())));
            } else {
                Log.i((String)TAG, (String)("OnImageAvailable: captured picture ts:" + image.getTimestamp() + " width:" + width + " height:" + height + " format:" + LmiVideoCapturerCamera2.pixelFormatToString(image.getFormat())));
            }
            try {
                LmiVideoFrame frame = new LmiVideoFrame(image);
                frame.setMirrored(this.mirrored);
                frame.setOrientation(this.getOrientation());
                frame.setOrientationRelativeToInterface(this.getOrientationRelativeToInterface());
                this.imageReaderCaptureWrapper.incCount();
                incremented = true;
                frame.setObject(this.imageReaderCaptureWrapper);
                this.pictureReceived(frame);
                this.captureThreadRunnable = new CaptureThreadRunnable();
                Thread captureStopThread = new Thread(this.captureThreadRunnable);
                this.captureThreadRunnable.callStop();
                captureStopThread.start();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"unable to add captured frame", (Throwable)e);
                if (incremented) {
                    this.imageReaderCaptureWrapper.decCountRequested();
                    this.imageReaderCaptureWrapper.decCount();
                }
                image.close();
            }
        }
    }

    @Override
    public void releaseFrame(LmiVideoFrame frame) {
        frame.getImage().close();
        ImageReaderWrapper wr = (ImageReaderWrapper)frame.getObject();
        wr.decCountRequested();
        wr.decCount();
    }

    private class ImageReaderWrapper {
        private ImageReader reader;
        private int count = 0;
        private int countRequested = 0;
        private boolean closed = false;

        ImageReaderWrapper(ImageReader r) {
            this.reader = r;
        }

        synchronized void close() {
            this.closed = true;
            if (this.count == 0) {
                this.countRequested = 0;
                this.reader.close();
            }
        }

        synchronized void clearCountRequested() throws IllegalStateException {
            this.countRequested = 0;
        }

        synchronized int getCountRequested() throws IllegalStateException {
            return this.countRequested;
        }

        synchronized void incCountRequested() throws IllegalStateException {
            ++this.countRequested;
        }

        synchronized void decCountRequested() throws IllegalStateException {
            if (this.countRequested > 0) {
                --this.countRequested;
            }
        }

        synchronized void incCount() throws IllegalStateException {
            if (this.closed) {
                throw new IllegalStateException("count incremented after image reader wrapper closed");
            }
            ++this.count;
        }

        synchronized void decCount() {
            --this.count;
            if (this.closed && this.count == 0) {
                this.reader.close();
            }
        }
    }

    private class CaptureThreadRunnable
    implements Runnable {
        boolean doneWaiting = false;

        CaptureThreadRunnable() {
            LmiVideoCapturerCamera2.this.captureThreadRunnableActive = true;
        }

        public void callStop() {
            this.doneWaiting = true;
        }

        @Override
        public void run() {
            while (!this.doneWaiting) {
                SystemClock.sleep((long)10L);
                if (LmiVideoCapturerCamera2.this.captureThreadRunnableActive) continue;
                this.doneWaiting = true;
                return;
            }
            LmiVideoCapturerCamera2.this.pictureReceivedStop();
            this.doneWaiting = true;
            LmiVideoCapturerCamera2.this.captureThreadRunnableActive = false;
        }
    }

    private class CompareRectArea
    implements Comparator<Size> {
        private CompareRectArea() {
        }

        @Override
        public int compare(Size l, Size r) {
            return Long.signum((long)l.getWidth() * (long)l.getHeight() - (long)r.getWidth() * (long)r.getHeight());
        }
    }
}

