/*
 * Decompiled with CFR 0.152.
 */
package com.vidyo.LmiDeviceManager;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;

public class LmiLocationManager {
    private static String TAG = "LmiLocationManager";
    Location location;
    LocationManager locationManager;
    LocationListener locationListener;
    long address;

    public LmiLocationManager(Context context) {
        Log.d((String)TAG, (String)"Constructing location manager");
        this.locationManager = (LocationManager)context.getApplicationContext().getSystemService("location");
        this.location = null;
        Log.d((String)TAG, (String)"Finished constructing location manager");
    }

    public void setAddress(long addr) {
        Log.d((String)TAG, (String)"Setting address on manager");
        this.address = addr;
    }

    public void startUpdates() {
        Log.d((String)TAG, (String)"Starting location manager updates");
        this.locationListener = new LocationListener(){

            public void onLocationChanged(Location loc) {
                Log.d((String)TAG, (String)("Location update, latitude: " + Double.toString(loc.getLatitude()) + ", longitude: " + Double.toString(loc.getLongitude()) + ", altitude: " + Double.toString(loc.getAltitude())));
                LmiLocationManager.this.location = loc;
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
        Criteria criteria = new Criteria();
        criteria.setAccuracy(2);
        criteria.setAltitudeRequired(false);
        criteria.setBearingRequired(false);
        criteria.setCostAllowed(true);
        criteria.setPowerRequirement(1);
        String provider = this.locationManager.getBestProvider(criteria, true);
        Log.d((String)TAG, (String)("Best provider: " + provider));
        if (provider != null) {
            this.locationManager.requestLocationUpdates(provider, 0L, 0.0f, this.locationListener, null);
        }
    }

    public void stopUpdates() {
        this.locationManager.removeUpdates(this.locationListener);
    }

    public double getLatitude() {
        if (this.location != null) {
            return this.location.getLatitude();
        }
        return 0.0;
    }

    public double getLongitude() {
        if (this.location != null) {
            return this.location.getLongitude();
        }
        return 0.0;
    }

    public double getAltitude() {
        if (this.location != null) {
            return this.location.getAltitude();
        }
        return 0.0;
    }
}

