/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.exception.AuthFailedException;
import com.vesoft.nebula.driver.graph.exception.IOErrorException;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import com.vesoft.nebula.driver.graph.net.NebulaPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLoadBalancer
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinLoadBalancer.class);
    private final List<HostAddress> addresses = new ArrayList<HostAddress>();
    private final boolean strictlyServerHealthy;
    private final String userName;
    private final Map<String, Object> authOptions;
    private final AtomicInteger pos = new AtomicInteger(0);
    private boolean enableTls;
    private boolean disableVerifyServerCert;
    private String tlsCa;
    private String tlsCert;
    private String tlsKey;
    private long connectionTimeout;

    public RoundRobinLoadBalancer(NebulaPool.Builder builder) {
        this.addresses.addAll(builder.address);
        this.strictlyServerHealthy = builder.strictlyServerHealthy;
        this.userName = builder.userName;
        this.authOptions = builder.authOptions;
        this.connectionTimeout = builder.connectTimeoutMills;
        this.enableTls = builder.enableTls;
        this.disableVerifyServerCert = builder.disableVerifyServerCert;
        this.tlsCa = builder.tlsCa;
        this.tlsCert = builder.tlsCert;
        this.tlsKey = builder.tlsKey;
    }

    public int addressSize() {
        return this.addresses.size();
    }

    public HostAddress getAddress() {
        if (this.pos.get() == Integer.MAX_VALUE) {
            this.pos.set(0);
        }
        int newPos = this.pos.getAndIncrement() % this.addresses.size();
        return this.addresses.get(newPos);
    }

    public boolean ping(HostAddress addr) throws AuthFailedException, IOErrorException {
        NebulaClient client = NebulaClient.builder(addr.toString(), this.userName).withConnectTimeoutMills(this.connectionTimeout).withAuthOptions(this.authOptions).withEnableTls(this.enableTls).withDisableVerifyServerCert(this.disableVerifyServerCert).withTlsCa(this.tlsCa).withTlsCert(this.tlsCert, this.tlsKey).build();
        client.close();
        return true;
    }

    public void checkServers() throws AuthFailedException, IOErrorException {
        AuthFailedException lastAuthE = null;
        IOErrorException lastIOE = null;
        int goodAddress = 0;
        for (HostAddress hostAddress : this.addresses) {
            try {
                this.ping(hostAddress);
                ++goodAddress;
            }
            catch (AuthFailedException e) {
                lastAuthE = e;
            }
            catch (IOErrorException ioe) {
                lastIOE = ioe;
            }
        }
        if (this.strictlyServerHealthy ? goodAddress == this.addressSize() : goodAddress >= 1) {
            return;
        }
        if (lastAuthE != null) {
            throw lastAuthE;
        }
        if (lastIOE != null) {
            throw lastIOE;
        }
    }
}

