/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.decode.Batch;
import com.vesoft.nebula.driver.graph.decode.BytesReader;
import com.vesoft.nebula.driver.graph.decode.Row;
import com.vesoft.nebula.driver.graph.decode.ValueParser;
import com.vesoft.nebula.driver.graph.decode.datatype.DataType;
import com.vesoft.nebula.driver.graph.decode.datatype.ValueTypeParser;
import com.vesoft.nebula.driver.graph.decode.struct.ResultGraphSchemas;
import com.vesoft.nebula.proto.graph.ValueType;
import com.vesoft.nebula.proto.graph.VectorBatch;
import com.vesoft.nebula.proto.graph.VectorResultTable;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResultTable {
    private final VectorResultTable resultTable;
    private ByteOrder byteOrder;
    private ValueParser parser;
    private int numBatches;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<DataType> columnDataTypes = new ArrayList<DataType>();
    private int batchIndex = 0;
    private Batch currentBatch;
    private int currentBatchRowIndex = 0;

    public ResultTable(VectorResultTable table) {
        if (table == null || !table.hasMeta()) {
            this.resultTable = null;
            return;
        }
        this.resultTable = table;
        ResultGraphSchemas graphSchemas = new ResultGraphSchemas(table.getMeta().getGraphSchemaList());
        int timeZoneOffset = table.getMeta().getTimeZoneOffset();
        this.byteOrder = table.getMeta().getIsLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.parser = new ValueParser(graphSchemas, timeZoneOffset, this.byteOrder);
        this.numBatches = table.getBatchCount();
        ArrayList<VectorBatch> batches = new ArrayList<VectorBatch>(table.getBatchList());
        if (this.numBatches != batches.size()) {
            throw new RuntimeException("the number of batch if not equal to numBatches");
        }
        this.columnNames.addAll((Collection<String>)table.getMeta().getRowType().getColumnNamesList());
        ValueTypeParser valueTypeParser = new ValueTypeParser(this.byteOrder);
        for (ValueType type : table.getMeta().getRowType().getColumnTypesList()) {
            DataType dataType = valueTypeParser.getDataType(new BytesReader(type.getValueType()));
            this.columnDataTypes.add(dataType);
        }
        if (!table.getBatchList().isEmpty()) {
            this.currentBatch = new Batch(table.getBatchList().get(0), this.byteOrder);
        }
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public long getTotalNumRecords() {
        return this.resultTable.getMeta().getNumRecords();
    }

    private Row getRowByIndex(int index) {
        Row row = new Row();
        for (int i = 0; i < this.currentBatch.getVectorsCount(); ++i) {
            ValueWrapper value = this.parser.decodeValueWrapper(this.currentBatch.getVectors(i), this.columnDataTypes.get(i), index);
            row.addValue(value);
        }
        return row;
    }

    public Row next() {
        if (this.currentBatch == null) {
            throw new RuntimeException("no more batch data");
        }
        int currentBatchRowSize = 0;
        if (this.currentBatch.getVectorsCount() != 0) {
            currentBatchRowSize = this.currentBatch.getBatchRowSize();
        }
        if (this.currentBatch.getVectorsCount() == 0 || this.currentBatchRowIndex >= currentBatchRowSize) {
            ++this.batchIndex;
            if (this.batchIndex >= this.numBatches) {
                throw new RuntimeException("no more batch data");
            }
            this.currentBatchRowIndex = 0;
            this.currentBatch = new Batch(this.resultTable.getBatch(this.batchIndex), this.byteOrder);
        }
        Row row = this.getRowByIndex(this.currentBatchRowIndex);
        ++this.currentBatchRowIndex;
        return row;
    }
}

