/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.utils;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.vesoft.nebula.driver.graph.data.HostAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class AddressUtil {
    public static List<HostAddress> validateAddress(String addresses) throws UnknownHostException {
        ArrayList<HostAddress> newAddrs = new ArrayList<HostAddress>();
        for (String addr : addresses.split(",")) {
            InetAddress[] inetAddresses;
            if (addr == null || addr.isEmpty()) continue;
            int indexOfLastComa = addr.lastIndexOf(":");
            String host = addr.substring(0, indexOfLastComa).trim();
            int port = Integer.parseInt(addr.substring(indexOfLastComa + 1).trim());
            for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                String ip = inetAddress.getHostAddress();
                if ((InetAddresses.isInetAddress((String)ip) || InetAddresses.isUriInetAddress((String)ip) || InternetDomainName.isValid((String)ip)) && port > 0 && port < 65535) continue;
                throw new IllegalArgumentException(String.format("host %s and port %d is invalid.", ip, port));
            }
            newAddrs.add(new HostAddress(host, port));
        }
        return newAddrs;
    }
}

