/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.scan;

import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.scan.TableRow;
import java.util.ArrayList;
import java.util.List;

public abstract class ScanResult {
    protected final List<ResultSet> results;
    protected List<TableRow> tableRows = new ArrayList<TableRow>();
    protected boolean isEmpty;

    public ScanResult(List<ResultSet> results) {
        this.results = results;
        this.isEmpty = this.isResultsEmpty();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public List<TableRow> getTableRows() {
        if (!this.isEmpty && this.tableRows.isEmpty()) {
            this.convertResultToRow();
        }
        return this.tableRows;
    }

    protected abstract void convertResultToRow();

    private boolean isResultsEmpty() {
        for (ResultSet resultSet : this.results) {
            if (resultSet.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

