/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.struct;

import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import com.vesoft.nebula.driver.graph.decode.struct.EdgeSchema;
import com.vesoft.nebula.driver.graph.decode.struct.NodeSchema;
import com.vesoft.nebula.proto.graph.EdgeType;
import com.vesoft.nebula.proto.graph.NodeType;
import com.vesoft.nebula.proto.graph.PropertyGraphSchema;
import java.util.HashMap;
import java.util.Map;

public class GraphSchema {
    private int graphId;
    private String graphName;
    private Map<Integer, NodeSchema> nodeSchemas = new HashMap<Integer, NodeSchema>();
    private Map<Integer, EdgeSchema> edgeSchemas = new HashMap<Integer, EdgeSchema>();

    public GraphSchema(PropertyGraphSchema graphSchema) {
        this.graphId = graphSchema.getGraphId();
        this.graphName = graphSchema.getGraphName().toString(DecodeUtils.charset);
        for (NodeType nodeType : graphSchema.getNodeTypeList()) {
            this.nodeSchemas.put(nodeType.getNodeTypeId(), new NodeSchema(nodeType));
        }
        for (EdgeType edgeType : graphSchema.getEdgeTypeList()) {
            this.edgeSchemas.put(edgeType.getEdgeTypeId(), new EdgeSchema(edgeType));
        }
    }

    public int getGraphId() {
        return this.graphId;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public NodeSchema getNodeSchema(int nodeTypeId) {
        return this.nodeSchemas.get(nodeTypeId);
    }

    public EdgeSchema getEdgeSchema(int edgeTypeId) {
        return this.edgeSchemas.get(edgeTypeId);
    }
}

