/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import java.util.Objects;

public class NDuration {
    private final boolean isMonthBased;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int microSec;

    public NDuration(boolean isMonthBased, int year, int month, int day, int hour, int minute, int second, int microSec) {
        this.isMonthBased = isMonthBased;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microSec = microSec;
    }

    public boolean isMonthBased() {
        return this.isMonthBased;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microSec;
    }

    public String toString() {
        StringBuilder durationStr = new StringBuilder();
        durationStr.append("P");
        if (this.isMonthBased()) {
            if (this.getYear() != 0) {
                durationStr.append(this.getYear()).append("Y");
            }
            if (this.getMonth() != 0 || this.getYear() == 0) {
                durationStr.append(this.getMonth()).append("M");
            }
        } else {
            if (this.getDay() != 0) {
                durationStr.append(this.getDay()).append("D");
            }
            if (this.getDay() == 0 || this.getHour() != 0 || this.getMinute() != 0 || this.getSecond() != 0 || this.getMicrosecond() != 0) {
                durationStr.append("T");
            }
            if (this.getHour() != 0) {
                durationStr.append(this.getHour()).append("H");
            }
            if (this.getMinute() != 0) {
                durationStr.append(this.getMinute()).append("M");
            }
            if (this.getSecond() != 0 || this.getMicrosecond() != 0 || this.getDay() == 0 && this.getHour() == 0 && this.getMinute() == 0 && this.getSecond() == 0) {
                if (this.getMicrosecond() == 0) {
                    durationStr.append(this.getSecond()).append("S");
                } else {
                    boolean isMinus;
                    int totalMicroseconds = this.getSecond() * 1000000 + this.getMicrosecond();
                    boolean bl = isMinus = totalMicroseconds < 0;
                    if (isMinus) {
                        totalMicroseconds = -totalMicroseconds;
                    }
                    int seconds = totalMicroseconds / 1000000;
                    int microSec = totalMicroseconds % 1000000;
                    if (isMinus) {
                        durationStr.append(String.format("-%d.%06d", seconds, microSec));
                    } else {
                        durationStr.append(String.format("%d.%06d", seconds, microSec));
                    }
                    while (durationStr.charAt(durationStr.length() - 1) == '0') {
                        durationStr.setLength(durationStr.length() - 1);
                    }
                    durationStr.append("S");
                }
            }
        }
        return durationStr.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NDuration that = (NDuration)o;
        return this.isMonthBased == that.isMonthBased() && this.year == that.getYear() && this.month == that.getMonth() && this.day == that.getDay() && this.hour == that.getHour() && this.minute == that.getMinute() && this.second == that.getSecond() && this.microSec == that.getMicrosecond();
    }

    public int hashCode() {
        return Objects.hash(this.isMonthBased, this.year, this.month, this.day, this.hour, this.minute, this.second, this.microSec);
    }
}

