/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.exception.AuthFailedException;
import com.vesoft.nebula.driver.graph.exception.IOErrorException;
import com.vesoft.nebula.driver.graph.net.ClientPoolFactory;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import com.vesoft.nebula.driver.graph.net.RoundRobinLoadBalancer;
import com.vesoft.nebula.driver.graph.utils.AddressUtil;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaPool
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GenericObjectPool<NebulaClient> pool;
    private RoundRobinLoadBalancer loadBalancer;
    private final AtomicBoolean hasInit = new AtomicBoolean(false);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private long maxWaitMills;
    private long maxLifeMills;

    public static Builder builder(String addresses, String userName) {
        return NebulaPool.builder(addresses, userName, null);
    }

    public static Builder builder(String addresses, String userName, String password) {
        return new Builder(addresses, userName, password);
    }

    private NebulaPool(Builder builder) throws IOErrorException, AuthFailedException {
        if (this.hasInit.get()) {
            return;
        }
        this.maxWaitMills = builder.maxWaitMills;
        this.maxLifeMills = builder.maxLifeTimeMs;
        this.loadBalancer = new RoundRobinLoadBalancer(builder);
        this.loadBalancer.checkServers();
        GenericObjectPoolConfig objConfig = new GenericObjectPoolConfig();
        objConfig.setMaxIdle(builder.maxClientSize);
        objConfig.setMinIdle(builder.minClientSize);
        objConfig.setMaxTotal(builder.maxClientSize);
        objConfig.setBlockWhenExhausted(builder.blockWhenExhausted);
        objConfig.setMaxWaitMillis(builder.maxWaitMills);
        objConfig.setTimeBetweenEvictionRunsMillis(builder.idleEvictScheduleMills);
        objConfig.setMinEvictableIdleTimeMillis(builder.minEvictableIdleTimeMillis);
        objConfig.setTestOnBorrow(builder.testOnBorrow);
        objConfig.setLifo(builder.lifo);
        if (builder.healthCheckTimeMills > 0L) {
            objConfig.setTestWhileIdle(true);
            objConfig.setTimeBetweenEvictionRunsMillis(builder.healthCheckTimeMills);
        }
        ClientPoolFactory factory = new ClientPoolFactory(this.loadBalancer, builder);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory, objConfig);
        this.hasInit.compareAndSet(false, true);
    }

    public NebulaClient getClient() throws Exception {
        return (NebulaClient)this.pool.borrowObject(this.maxWaitMills);
    }

    public void returnClient(NebulaClient client) {
        if (client.isClosed() || System.currentTimeMillis() - client.getCreateTime() >= this.maxLifeMills) {
            try {
                this.pool.invalidateObject((Object)client);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.pool.returnObject((Object)client);
        }
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.pool.close();
        }
    }

    public int getActiveSessions() {
        return this.pool.getNumActive();
    }

    public int getIdleSessions() {
        return this.pool.getNumIdle();
    }

    public int getWaiters() {
        return this.pool.getNumWaiters();
    }

    public static class Builder {
        protected final List<HostAddress> address;
        protected final String userName;
        protected final String password;
        protected Map<String, Object> authOptions = new HashMap<String, Object>();
        protected int maxClientSize = 10;
        protected int minClientSize = 1;
        protected long connectTimeoutMills = 3000L;
        protected long requestTimeoutMills = 60000L;
        protected long healthCheckTimeMills = 300000L;
        private boolean testOnBorrow = true;
        private boolean lifo = true;
        protected boolean blockWhenExhausted = false;
        protected long maxWaitMills = Long.MAX_VALUE;
        protected long idleEvictScheduleMills = -1L;
        protected long minEvictableIdleTimeMillis = 1800000L;
        protected boolean strictlyServerHealthy = false;
        protected long maxLifeTimeMs = Long.MAX_VALUE;
        protected String graph = null;
        protected String timeZone = null;
        protected String dateFormat = null;
        protected String localDatetimeFormat = null;
        protected String zonedDatetimeFormat = null;
        protected String localTimeFormat = null;
        protected String zonedTimeFormat = null;
        protected Map<String, String> sessionConfigs = new HashMap<String, String>();
        protected String schema = null;
        protected Map<String, String> parameters = new HashMap<String, String>();
        protected List<String> preStatements = new ArrayList<String>();
        protected int scanParallel = 10;
        protected boolean enableTls = false;
        protected boolean disableVerifyServerCert = false;
        protected String tlsCa;
        protected String tlsCert;
        protected String tlsKey;

        public Builder(String addresses, String userName, String password) {
            try {
                this.address = AddressUtil.validateAddress(addresses);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            this.userName = userName;
            this.password = password;
        }

        public Builder withAuthOptions(Map<String, Object> authOptions) {
            if (authOptions != null) {
                this.authOptions.putAll(authOptions);
            }
            return this;
        }

        public Builder withMaxClientSize(int maxClientSize) {
            if (maxClientSize < 1) {
                throw new IllegalArgumentException("maxClientSize cannot be less than 1.");
            }
            this.maxClientSize = maxClientSize;
            return this;
        }

        public Builder withMinClientSize(int minClientSize) {
            if (minClientSize < 0) {
                throw new IllegalArgumentException("minClientSize cannot be less than 0.");
            }
            this.minClientSize = minClientSize;
            return this;
        }

        public Builder withConnectTimeoutMills(long connectTimeoutMills) {
            this.connectTimeoutMills = connectTimeoutMills <= 0L || connectTimeoutMills > Integer.MAX_VALUE ? Integer.MAX_VALUE : connectTimeoutMills;
            return this;
        }

        public Builder withRequestTimeoutMills(long requestTimeoutMills) {
            this.requestTimeoutMills = requestTimeoutMills <= 0L || requestTimeoutMills > Integer.MAX_VALUE ? Integer.MAX_VALUE : requestTimeoutMills;
            return this;
        }

        public Builder withHealthCheckTimeMills(long healthCheckTimeMills) {
            this.healthCheckTimeMills = Math.max(healthCheckTimeMills, 0L);
            return this;
        }

        public Builder withBlockWhenExhausted(boolean blockWhenExhausted) {
            this.blockWhenExhausted = blockWhenExhausted;
            return this;
        }

        public Builder withTestOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public Builder withMaxWaitMills(long maxWaitMills) {
            this.maxWaitMills = maxWaitMills <= 0L ? Long.MAX_VALUE : maxWaitMills;
            return this;
        }

        public Builder withIdleEvictScheduleMills(long idleEvictScheduleMills) {
            this.idleEvictScheduleMills = idleEvictScheduleMills;
            return this;
        }

        public Builder withMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
            return this;
        }

        public Builder withLifo(boolean lifo) {
            this.lifo = lifo;
            return this;
        }

        public Builder withStrictlyServerHealthy(boolean strictlyServerHealthy) {
            this.strictlyServerHealthy = strictlyServerHealthy;
            return this;
        }

        public Builder withMaxLifeTimeMs(long maxLifeTimeMs) {
            this.maxLifeTimeMs = maxLifeTimeMs <= 0L ? Long.MAX_VALUE : maxLifeTimeMs;
            return this;
        }

        public Builder withGraph(String graph) {
            this.graph = graph;
            return this;
        }

        public Builder withTimeZone(String zoneId) {
            this.timeZone = zoneId;
            this.sessionConfigs.put("timezone", "\"" + zoneId + "\"");
            return this;
        }

        public Builder withSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder withParameters(Map<String, String> parameters) {
            if (parameters != null) {
                this.parameters = parameters;
            }
            return this;
        }

        public Builder addParameter(String paramName, String value) {
            if (paramName != null) {
                this.parameters.put(paramName, value);
            }
            return this;
        }

        public Builder withDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            this.sessionConfigs.put("date_format", "\"" + dateFormat + "\"");
            return this;
        }

        public Builder withLocalDatetimeFormat(String localDatetimeFormat) {
            this.localDatetimeFormat = localDatetimeFormat;
            this.sessionConfigs.put("local_datetime_format", "\"" + localDatetimeFormat + "\"");
            return this;
        }

        public Builder withZonedDatetimeFormat(String zonedDatetimeFormat) {
            this.zonedDatetimeFormat = zonedDatetimeFormat;
            this.sessionConfigs.put("zoned_datetime_format", "\"" + zonedDatetimeFormat + "\"");
            return this;
        }

        public Builder withLocalTimeFormat(String localTimeFormat) {
            this.localTimeFormat = localTimeFormat;
            this.sessionConfigs.put("local_time_format", "\"" + localTimeFormat + "\"");
            return this;
        }

        public Builder withZonedTimeFormat(String zonedTimeFormat) {
            this.zonedTimeFormat = zonedTimeFormat;
            this.sessionConfigs.put("zoned_time_format", "\"" + zonedTimeFormat + "\"");
            return this;
        }

        public Builder withSessionConfigs(Map<String, String> sessionConfigs) {
            if (sessionConfigs != null) {
                this.sessionConfigs.putAll(sessionConfigs);
            }
            return this;
        }

        public Builder withPreStatements(List<String> preStatements) {
            if (preStatements != null) {
                this.preStatements.addAll(preStatements);
            }
            return this;
        }

        public Builder withScanParallel(int scanParallel) {
            this.scanParallel = scanParallel;
            return this;
        }

        public Builder withEnableTls(boolean enableTls) {
            this.enableTls = enableTls;
            return this;
        }

        public Builder withDisableVerifyServerCert(boolean disableVerifyServerCert) {
            this.disableVerifyServerCert = disableVerifyServerCert;
            return this;
        }

        public Builder withTlsCa(String ca) {
            this.tlsCa = ca;
            return this;
        }

        public Builder withTlsCert(String cert, String key) {
            this.tlsCert = cert;
            this.tlsKey = key;
            return this;
        }

        public void check() {
            if (this.address == null) {
                throw new IllegalArgumentException("Graph addresses cannot be empty.");
            }
            if (this.enableTls && !this.disableVerifyServerCert && this.tlsCa == null) {
                throw new IllegalArgumentException("no CA certificate provide.");
            }
        }

        public NebulaPool build() throws IOErrorException, AuthFailedException {
            this.check();
            if (this.password != null) {
                this.authOptions.put("password", this.password);
            }
            return new NebulaPool(this);
        }
    }
}

