/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.struct;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EdgeHeader {
    private final ByteOrder byteOrder;
    private int edgeTypeId;
    private int graphId;
    private long rank;
    private long dstId;
    private long srcId;

    public EdgeHeader(ByteString byteString, ByteOrder order) {
        this.byteOrder = order;
        ByteBuffer buffer = ByteBuffer.wrap(byteString.toByteArray()).order(this.byteOrder);
        this.srcId = buffer.getLong();
        this.dstId = this.bytesToLong(buffer.array(), 8, 8);
        this.rank = this.bytesToLong(buffer.array(), 16, 8);
        this.graphId = this.bytesToInt(buffer.array(), 24, 4);
        this.edgeTypeId = this.bytesToInt(buffer.array(), 28, 4);
    }

    private long bytesToLong(byte[] bytes, int offset, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size).order(this.byteOrder);
        buffer.put(bytes, offset, size);
        buffer.flip();
        return buffer.getLong();
    }

    private int bytesToInt(byte[] bytes, int offset, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size).order(this.byteOrder);
        buffer.put(bytes, offset, size);
        buffer.flip();
        return buffer.getInt();
    }

    public int getEdgeTypeId() {
        return this.edgeTypeId;
    }

    public int getGraphId() {
        return this.graphId;
    }

    public long getRank() {
        return this.rank;
    }

    public long getDstId() {
        return this.dstId;
    }

    public long getSrcId() {
        return this.srcId;
    }
}

