/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.datatype;

import com.vesoft.nebula.driver.graph.decode.ColumnType;
import com.vesoft.nebula.driver.graph.decode.datatype.DataType;
import com.vesoft.nebula.driver.graph.decode.datatype.EdgeType;
import com.vesoft.nebula.driver.graph.decode.datatype.NodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathType
extends DataType {
    private final List<DataType> dataTypes;
    private final List<NodeType> nodeTypes = new ArrayList<NodeType>();
    private final List<EdgeType> edgeTypes = new ArrayList<EdgeType>();
    private final Map<Integer, Map<Integer, Map<String, DataType>>> nodeTypesMap = new HashMap<Integer, Map<Integer, Map<String, DataType>>>();
    private final Map<Integer, Map<Integer, Map<String, DataType>>> edgeTypesMap = new HashMap<Integer, Map<Integer, Map<String, DataType>>>();

    public PathType(List<DataType> dataTypes) {
        super(ColumnType.COLUMN_TYPE_PATH);
        this.dataTypes = dataTypes;
        for (DataType dataType : dataTypes) {
            if (dataType.getType() == ColumnType.COLUMN_TYPE_NODE) {
                this.nodeTypes.add((NodeType)dataType);
            }
            if (dataType.getType() != ColumnType.COLUMN_TYPE_EDGE) continue;
            this.edgeTypes.add((EdgeType)dataType);
        }
    }

    public List<DataType> getDataTypes() {
        return this.dataTypes;
    }

    public Map<Integer, Map<Integer, Map<String, DataType>>> getNodeTypes() {
        if (this.nodeTypesMap.isEmpty()) {
            for (NodeType nodeType : this.nodeTypes) {
                for (Map.Entry<Integer, Map<Integer, Map<String, DataType>>> graphEntry : nodeType.getNodeTypes().entrySet()) {
                    int graphId = graphEntry.getKey();
                    Map<Integer, Map<String, DataType>> nodeTypeMap = graphEntry.getValue();
                    if (this.nodeTypesMap.containsKey(graphId)) {
                        Map<Integer, Map<String, DataType>> existNodeTypeMap = this.nodeTypesMap.get(graphId);
                        for (Map.Entry<Integer, Map<String, DataType>> nodeTypeEntry : nodeTypeMap.entrySet()) {
                            int nodeTypeId = nodeTypeEntry.getKey();
                            Map<String, DataType> propMap = nodeTypeEntry.getValue();
                            if (existNodeTypeMap.containsKey(nodeTypeId)) {
                                existNodeTypeMap.get(nodeTypeId).putAll(propMap);
                                continue;
                            }
                            existNodeTypeMap.put(nodeTypeId, propMap);
                        }
                        continue;
                    }
                    this.nodeTypesMap.put(graphId, nodeTypeMap);
                }
            }
        }
        return this.nodeTypesMap;
    }

    public Map<Integer, Map<Integer, Map<String, DataType>>> getEdgeTypes() {
        if (this.edgeTypesMap.isEmpty()) {
            for (EdgeType edgeType : this.edgeTypes) {
                for (Map.Entry<Integer, Map<Integer, Map<String, DataType>>> graphEntry : edgeType.getEdgeTypes().entrySet()) {
                    Integer graphId = graphEntry.getKey();
                    Map<Integer, Map<String, DataType>> edgeTypeMap = graphEntry.getValue();
                    if (this.edgeTypesMap.containsKey(graphId)) {
                        Map<Integer, Map<String, DataType>> existEdgeTypeMap = this.edgeTypesMap.get(graphId);
                        for (Map.Entry<Integer, Map<String, DataType>> edgeTypeEntry : edgeTypeMap.entrySet()) {
                            Integer edgeTypeId = edgeTypeEntry.getKey();
                            Map<String, DataType> propMap = edgeTypeEntry.getValue();
                            if (existEdgeTypeMap.containsKey(edgeTypeId)) {
                                existEdgeTypeMap.get(edgeTypeId).putAll(propMap);
                                continue;
                            }
                            existEdgeTypeMap.put(edgeTypeId, propMap);
                        }
                        continue;
                    }
                    this.edgeTypesMap.put(graphId, new HashMap<Integer, Map<String, DataType>>(edgeTypeMap));
                }
            }
        }
        return this.edgeTypesMap;
    }
}

