/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode;

import com.google.protobuf.ByteString;
import com.vesoft.nebula.driver.graph.decode.BytesReader;
import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import com.vesoft.nebula.driver.graph.decode.datatype.VectorType;
import com.vesoft.nebula.driver.graph.decode.struct.PathSpecialMetaData;
import com.vesoft.nebula.proto.graph.NestedVector;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VectorWrapper {
    private final ByteOrder byteOrder;
    private final NestedVector vector;
    private final List<VectorWrapper> vectorWrappers = new ArrayList<VectorWrapper>();
    private final boolean nullAllSet;
    private Map<Integer, Map<Integer, Map<String, Integer>>> graphElementTypeIdAndPropVectorIndexMap = null;
    private PathSpecialMetaData pathSpecialMetaData = null;
    private Object constValue = null;

    public VectorWrapper(NestedVector vector, ByteOrder order) {
        this.byteOrder = order;
        this.vector = vector;
        this.nullAllSet = DecodeUtils.isNullBitMapAllSet(vector);
        for (NestedVector vec : vector.getNestedVectorsList()) {
            this.vectorWrappers.add(new VectorWrapper(vec, this.byteOrder));
        }
    }

    public NestedVector getVector() {
        return this.vector;
    }

    public int getNumNestedVectors() {
        return this.vector.getNumNestedVectors();
    }

    public int getVectorNumRecords() {
        return this.vector.getCommonMetaData().getNumRecords();
    }

    public VectorType getVectorType() {
        return DecodeUtils.getVectorType(this.vector);
    }

    public ByteString getVectorData() {
        return this.vector.getVectorData();
    }

    public ByteString getSpecialMetaData() {
        return this.vector.getSpecialMetaData();
    }

    public ByteString getNullBitMap() {
        return this.vector.getNullBitMap();
    }

    public List<VectorWrapper> getNestedVectors() {
        return this.vectorWrappers;
    }

    public VectorWrapper getVectorWrapper(int index) {
        return this.vectorWrappers.get(index);
    }

    public boolean isNullAllSet() {
        return this.nullAllSet;
    }

    public void setConstValue(Object value) {
        this.constValue = value;
    }

    public Object getConstValue() {
        return this.constValue;
    }

    public Map<Integer, Map<Integer, Map<String, Integer>>> getGraphElementTypeIdAndPropVectorIndexMap(int typeIdSize) {
        if (this.graphElementTypeIdAndPropVectorIndexMap == null) {
            this.graphElementTypeIdAndPropVectorIndexMap = new HashMap<Integer, Map<Integer, Map<String, Integer>>>();
            BytesReader reader = new BytesReader(this.vector.getSpecialMetaData());
            int propertyNum = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
            String[] propNames = new String[propertyNum];
            for (int i = 0; i < propertyNum; ++i) {
                propNames[i] = reader.readSizedString(this.byteOrder);
            }
            int typeNum = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
            for (int i = 0; i < typeNum; ++i) {
                int graphId = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                int typeId = typeIdSize == 2 ? (int)DecodeUtils.bytesToInt16(reader.read(typeIdSize), this.byteOrder).shortValue() : DecodeUtils.bytesToInt32(reader.read(typeIdSize), this.byteOrder);
                int nodePropNum = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                HashMap<String, Integer> propNameToVectorIndex = new HashMap<String, Integer>();
                for (int j = 0; j < nodePropNum; ++j) {
                    int propVectorIndex = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                    propNameToVectorIndex.put(propNames[propVectorIndex], propVectorIndex);
                }
                if (!this.graphElementTypeIdAndPropVectorIndexMap.containsKey(graphId)) {
                    this.graphElementTypeIdAndPropVectorIndexMap.put(graphId, new HashMap());
                }
                this.graphElementTypeIdAndPropVectorIndexMap.get(graphId).put(typeId, propNameToVectorIndex);
            }
        }
        return this.graphElementTypeIdAndPropVectorIndexMap;
    }

    public PathSpecialMetaData getPathSpecialMetaData() {
        if (this.pathSpecialMetaData == null) {
            this.pathSpecialMetaData = new PathSpecialMetaData(this.vector, this.byteOrder);
        }
        return this.pathSpecialMetaData;
    }
}

