/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.Edge;
import com.vesoft.nebula.driver.graph.data.Node;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Path {
    private String decodeType = "utf-8";
    private List<ValueWrapper> values;
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();

    public Path(List<ValueWrapper> values) {
        this.values = values;
        for (ValueWrapper value : values) {
            if (value.isNode()) {
                this.nodes.add(value.asNode());
                continue;
            }
            this.edges.add(value.asEdge());
        }
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public List<Edge> edges() {
        return this.edges;
    }

    public List<ValueWrapper> values() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Path that = (Path)obj;
        return this.values.equals(that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        if (this.values.size() == 0) {
            return null;
        }
        Node prefixNode = this.nodes.get(0);
        ArrayList<String> prefixNodePropStrs = new ArrayList<String>();
        Map<String, ValueWrapper> prefixNodeProps = prefixNode.getProperties();
        for (String key : prefixNodeProps.keySet()) {
            prefixNodePropStrs.add(key + ":" + prefixNodeProps.get(key).toString());
        }
        if (this.edges.size() == 0) {
            String template = "(%d@%s:%s{%s})";
            return String.format(template, prefixNode.getId(), prefixNode.getType(), String.join((CharSequence)"&", prefixNode.getLabels()), String.join((CharSequence)",", prefixNodePropStrs));
        }
        ArrayList<String> edgeStrs = new ArrayList<String>();
        for (int i = 0; i < this.edges.size(); ++i) {
            String template;
            Edge edge = this.edges.get(i);
            ArrayList<String> edgePropStrs = new ArrayList<String>();
            Map<String, ValueWrapper> props = edge.getProperties();
            for (String key : props.keySet()) {
                edgePropStrs.add(key + ":" + props.get(key).toString());
            }
            Node suffixNode = this.nodes.get(i + 1);
            ArrayList<String> suffixNodePropStrs = new ArrayList<String>();
            Map<String, ValueWrapper> suffixNodeProps = suffixNode.getProperties();
            for (String key : suffixNodeProps.keySet()) {
                suffixNodePropStrs.add(key + ":" + suffixNodeProps.get(key).toString());
            }
            if (i == 0) {
                template = "(%d@%s:%s{%s})~[%d@%s:%s{%s}]~(%d@%s:%s{%s})";
                if (edge.isDirected() && edge.getSrcId() == prefixNode.getId()) {
                    template = "(%d@%s:%s{%s})-[%d@%s:%s{%s}]->(%d@%s:%s{%s})";
                }
                if (edge.isDirected() && edge.getSrcId() != prefixNode.getId()) {
                    template = "(%d@%s:%s{%s})<-[%d@%s:%s{%s}]-(%d@%s:%s{%s})";
                }
                edgeStrs.add(String.format(template, prefixNode.getId(), prefixNode.getType(), String.join((CharSequence)"&", prefixNode.getLabels()), String.join((CharSequence)",", prefixNodePropStrs), edge.getRank(), edge.getType(), String.join((CharSequence)"&", edge.getLabels()), String.join((CharSequence)",", edgePropStrs), suffixNode.getId(), suffixNode.getType(), String.join((CharSequence)"&", suffixNode.getLabels()), String.join((CharSequence)",", suffixNodePropStrs)));
                continue;
            }
            template = "~[%d@%s:%s{%s}]~(%d@%s:%s{%s})";
            if (edge.isDirected() && edge.getDstId() == suffixNode.getId()) {
                template = "-[%d@%s:%s{%s}]->(%d@%s:%s{%s})";
            }
            if (edge.isDirected() && edge.getDstId() != suffixNode.getId()) {
                template = "<-[%d@%s:%s{%s}]-(%d@%s:%s{%s})";
            }
            edgeStrs.add(String.format(template, edge.getRank(), edge.getType(), String.join((CharSequence)"&", edge.getLabels()), String.join((CharSequence)",", edgePropStrs), suffixNode.getId(), suffixNode.getType(), String.join((CharSequence)"&", suffixNode.getLabels()), String.join((CharSequence)",", suffixNodePropStrs)));
        }
        return String.join((CharSequence)"", edgeStrs);
    }
}

