/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.scan;

import com.vesoft.nebula.driver.graph.data.Node;
import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.scan.ScanResult;
import com.vesoft.nebula.driver.graph.scan.TableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScanNodeResult
extends ScanResult {
    private List<String> propNames;

    public ScanNodeResult(List<ResultSet> results, List<String> propNames) {
        super(results);
        this.propNames = propNames;
    }

    public List<String> getPropNames() {
        return this.propNames;
    }

    @Override
    protected void convertResultToRow() {
        if (this.isEmpty) {
            return;
        }
        if (this.tableRows.isEmpty()) {
            for (ResultSet resultSet : this.results) {
                while (resultSet.hasNext()) {
                    ResultSet.Record record = resultSet.next();
                    List<ValueWrapper> values = record.values();
                    ArrayList<ValueWrapper> rowValues = new ArrayList<ValueWrapper>();
                    Node node = values.get(0).asNode();
                    Map<String, ValueWrapper> properties = node.getProperties();
                    for (String propName : this.propNames) {
                        rowValues.add(properties.get(propName));
                    }
                    this.tableRows.add(new TableRow(rowValues));
                }
            }
        }
    }
}

